/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.wagon.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.weigh.wagon.bean.WagonMaterialEntity;
import com.ejianc.business.weigh.wagon.bean.WagonProjectEntity;
import com.ejianc.business.weigh.wagon.enums.AutoWeighEnums;
import com.ejianc.business.weigh.wagon.mapper.WagonMaterialMapper;
import com.ejianc.business.weigh.wagon.service.IWagonMaterialService;
import com.ejianc.business.weigh.wagon.service.IWagonProjectService;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wagonMaterialService")
public class WagonMaterialServiceImpl
extends BaseServiceImpl<WagonMaterialMapper, WagonMaterialEntity>
implements IWagonMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWagonProjectService wagonProjectService;

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, Object> insertBatch(List<WagonMaterialVO> voList) {
        void var10_14;
        if (CollectionUtils.isEmpty(voList)) {
            throw new BusinessException("\u63d2\u5165\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        List materialIdList = voList.stream().map(WagonMaterialVO::getMaterialId).collect(Collectors.toList());
        QueryParam checkParam = new QueryParam();
        checkParam.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        checkParam.getParams().put("materialId", new Parameter("in", materialIdList));
        List checkList = super.queryList(checkParam, false);
        ArrayList<WagonMaterialVO> insertList = new ArrayList<WagonMaterialVO>();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            List checkMaterialIdList = checkList.stream().map(WagonMaterialEntity::getMaterialId).collect(Collectors.toList());
            for (WagonMaterialVO wagonMaterialVO : voList) {
                if (checkMaterialIdList.contains(wagonMaterialVO.getMaterialId())) {
                    String errorMsg = "\u3010" + wagonMaterialVO.getMaterialName() + "\u3011\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01";
                    errorMsgList.add(errorMsg);
                    continue;
                }
                insertList.add(wagonMaterialVO);
            }
        } else {
            insertList.addAll(voList);
        }
        CommonResponse orgResponse = this.iOrgApi.getOneById(orgId);
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)orgResponse));
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        OrgVO orgVO = (OrgVO)orgResponse.getData();
        for (WagonMaterialVO vo : insertList) {
            vo.setOrgCode(orgVO.getCode());
            vo.setOrgId(orgVO.getId());
            vo.setOrgName(orgVO.getName());
            vo.setInnerCode(orgVO.getInnerCode());
            vo.setParentOrgCode(orgVO.getpCode());
            vo.setParentOrgId(orgVO.getParentId());
            vo.setParentOrgName(orgVO.getpFName());
            vo.setAutomaticWeigh(AutoWeighEnums.\u5173\u95ed\u81ea\u52a8\u79f0\u91cd.getCode());
        }
        if (CollectionUtils.isNotEmpty(insertList)) {
            List insertEntityList = BeanMapper.mapList(insertList, WagonMaterialEntity.class);
            super.saveOrUpdateBatch((Collection)insertEntityList, insertEntityList.size());
            List list = BeanMapper.mapList((Iterable)insertEntityList, WagonMaterialVO.class);
        } else {
            ArrayList arrayList = new ArrayList();
        }
        return this.getBatchResultMap(errorMsgList, (List<WagonMaterialVO>)var10_14);
    }

    @Override
    public void updateAutomaticWeigh(WagonMaterialVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getId() == null) {
            throw new BusinessException("\u4fee\u6539\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        WagonMaterialEntity saveEntity = (WagonMaterialEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        if (saveEntity.getScaleFactor() == null) {
            throw new BusinessException("\u8bf7\u5148\u8bbe\u7f6e\u6362\u7b97\u7cfb\u6570\uff01");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        if (!orgId.equals(saveEntity.getOrgId())) {
            throw new BusinessException("\u53ea\u80fd\u64cd\u4f5c\u672c\u7ec4\u7ec7\u4e0b\u7684\u6570\u636e\uff01");
        }
        saveEntity.setAutomaticWeigh(saveOrUpdateVO.getAutomaticWeigh());
        super.saveOrUpdate((Object)saveEntity, false);
    }

    @Override
    public Map<String, Object> updateAutomaticWeighBatch(List<WagonMaterialVO> voList) {
        List<Object> rtnVoList;
        if (CollectionUtils.isEmpty(voList)) {
            throw new BusinessException("\u63d2\u5165\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        List idList = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        Integer automaticWeigh = voList.get(0).getAutomaticWeigh();
        BigDecimal scaleFactor = voList.get(0).getScaleFactor();
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", idList));
        List entityList = super.queryList(param, false);
        ArrayList<String> errorMsgList = new ArrayList<String>();
        ArrayList<WagonMaterialEntity> saveEntityList = new ArrayList<WagonMaterialEntity>();
        for (WagonMaterialEntity entity : entityList) {
            if (orgId.equals(entity.getOrgId())) {
                entity.setAutomaticWeigh(automaticWeigh);
                entity.setScaleFactor(scaleFactor);
                saveEntityList.add(entity);
                continue;
            }
            String errorMsg = "\u6750\u6599\u3010" + entity.getMaterialName() + "\u3011\u4e0d\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0b\uff0c\u65e0\u6cd5\u8fdb\u884c\u8bbe\u7f6e\uff01";
            errorMsgList.add(errorMsg);
        }
        if (CollectionUtils.isNotEmpty(saveEntityList)) {
            super.saveOrUpdateBatch(saveEntityList, saveEntityList.size());
            rtnVoList = BeanMapper.mapList(saveEntityList, WagonMaterialVO.class);
        } else {
            rtnVoList = new ArrayList<WagonMaterialVO>();
        }
        return this.getBatchResultMap(errorMsgList, rtnVoList);
    }

    private Map<String, Object> getBatchResultMap(List<String> errorMsgList, List<WagonMaterialVO> rtnVoList) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        rtnMap.put("successSize", rtnVoList.size());
        rtnMap.put("failSize", errorMsgList.size());
        rtnMap.put("successList", rtnVoList);
        rtnMap.put("errorMsgList", errorMsgList);
        return rtnMap;
    }

    @Override
    public WagonMaterialVO queryMaterialAutomaticWeigh(Long projectId, Long materialId) {
        List<WagonMaterialVO> rtnList = this.queryMaterialAutomaticWeighBatch(projectId, Collections.singletonList(materialId));
        if (CollectionUtils.isNotEmpty(rtnList)) {
            return rtnList.get(0);
        }
        return new WagonMaterialVO();
    }

    @Override
    public List<WagonMaterialVO> queryMaterialAutomaticWeighList(Long projectId, List<Long> materialIdList) {
        List<WagonMaterialVO> rtnList = this.queryMaterialAutomaticWeighBatch(projectId, materialIdList);
        return rtnList;
    }

    @Override
    public List<WagonMaterialVO> queryMaterialAutomaticWeighBatch(Long projectId, List<Long> materialIdList) {
        this.logger.info("\u9879\u76eeid\uff1a{}\uff0c\u6750\u6599id\uff1a{}\uff1b\u5f00\u59cb\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e>>>>>>>>>>>>>>>>>>>>>>", (Object)projectId, (Object)JSONObject.toJSONString(materialIdList));
        ArrayList<WagonMaterialVO> rtnList = new ArrayList<WagonMaterialVO>();
        if (projectId == null || CollectionUtils.isEmpty(materialIdList)) {
            return rtnList;
        }
        materialIdList = materialIdList.stream().distinct().collect(Collectors.toList());
        QueryParam projectParam = new QueryParam();
        projectParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List projectEntityList = this.wagonProjectService.queryList(projectParam, false);
        this.logger.info("\u67e5\u8be2\u79f0\u91cd\u9879\u76ee\u8bbe\u7f6e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectEntityList));
        if (CollectionUtils.isEmpty((Collection)projectEntityList)) {
            this.logger.info("\u9879\u76ee[{}]\u672a\u8bbe\u7f6e\u81ea\u52a8\u79f0\u91cd\u4fe1\u606f", (Object)projectId);
            return rtnList;
        }
        boolean isProjectStartFlag = false;
        for (WagonProjectEntity entity : projectEntityList) {
            if (entity.getStartFlag() != 0) continue;
            isProjectStartFlag = true;
            break;
        }
        if (!isProjectStartFlag) {
            this.logger.info("\u9879\u76ee[{}]\u4e0d\u5b58\u5728\u542f\u7528\u7684\u5730\u78c5", (Object)projectId);
            return rtnList;
        }
        Long orgId = ((WagonProjectEntity)((Object)projectEntityList.get(0))).getOrgId();
        CommonResponse orgResponse = this.iOrgApi.getOneById(orgId);
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)orgResponse));
        if (!orgResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        OrgVO orgVO = (OrgVO)orgResponse.getData();
        String[] innerCodes = orgVO.getInnerCode().split("\\|");
        QueryParam materialParam = new QueryParam();
        materialParam.getParams().put("materialId", new Parameter("in", materialIdList));
        materialParam.getParams().put("orgId", new Parameter("in", Arrays.asList(innerCodes)));
        List materialEntityList = super.queryList(materialParam, false);
        this.logger.info("\u67e5\u8be2\u79f0\u91cd\u6750\u6599\u8bbe\u7f6e\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)materialEntityList));
        if (CollectionUtils.isEmpty((Collection)materialEntityList)) {
            this.logger.info("\u6750\u6599[{}]\u672a\u8bbe\u7f6e\u81ea\u52a8\u79f0\u91cd\u4fe1\u606f", (Object)JSONObject.toJSONString(materialIdList));
            return rtnList;
        }
        Map<Long, List<WagonMaterialEntity>> groupByMaterialMap = materialEntityList.stream().collect(Collectors.groupingBy(WagonMaterialEntity::getMaterialId));
        block1: for (Long materialId : materialIdList) {
            List<WagonMaterialEntity> wagonEntityList = groupByMaterialMap.get(materialId);
            this.logger.info("\u6750\u6599[{}]\u79f0\u91cd\u4fe1\u606f\uff1a{}", (Object)materialId, (Object)JSONObject.toJSONString(wagonEntityList));
            if (CollectionUtils.isEmpty(wagonEntityList)) {
                this.logger.info("\u6750\u6599[{}]\u672a\u8bbe\u7f6e\u81ea\u52a8\u79f0\u91cd\u4fe1\u606f", (Object)materialId);
                continue;
            }
            Map<Long, List<WagonMaterialEntity>> wagonMaterialMap = wagonEntityList.stream().collect(Collectors.groupingBy(WagonMaterialEntity::getOrgId));
            for (int i = innerCodes.length - 1; i >= 0; --i) {
                Long innerOrgId = Long.parseLong(innerCodes[i]);
                List<WagonMaterialEntity> orgMaterialList = wagonMaterialMap.get(innerOrgId);
                if (CollectionUtils.isEmpty(orgMaterialList)) {
                    this.logger.info("\u6750\u6599id[{}]\u7ec4\u7ec7id[{}]\u672a\u8bbe\u7f6e\u81ea\u52a8\u79f0\u91cd\u4fe1\u606f", (Object)materialId, (Object)innerOrgId);
                    continue;
                }
                WagonMaterialEntity wagonMaterialEntity = orgMaterialList.get(0);
                this.logger.info("\u6750\u6599id[{}]\u7ec4\u7ec7id[{}]\u8bbe\u7f6e\u81ea\u52a8\u79f0\u91cd\u7ed3\u679c\uff1a{}\uff0c\u8be6\u60c5\u4fe1\u606f\uff1a{}", new Object[]{materialId, innerOrgId, AutoWeighEnums.getEnumByCode((Integer)wagonMaterialEntity.getAutomaticWeigh()).getDescription(), JSONObject.toJSONString((Object)((Object)wagonMaterialEntity))});
                if (!AutoWeighEnums.\u5f00\u542f\u81ea\u52a8\u79f0\u91cd.getCode().equals(wagonMaterialEntity.getAutomaticWeigh())) continue;
                WagonMaterialVO rtnVo = (WagonMaterialVO)BeanMapper.map((Object)((Object)wagonMaterialEntity), WagonMaterialVO.class);
                rtnList.add(rtnVo);
                continue block1;
            }
        }
        this.logger.info("<<<<<<<<<<<<<<<<\u9879\u76eeid\uff1a{}\uff0c\u6750\u6599id\uff1a{}\uff1b\u67e5\u8be2\u9879\u76ee\u4e0b\u6750\u6599\u81ea\u52a8\u79f0\u91cd\u8bbe\u7f6e\u7ed3\u675f\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", new Object[]{projectId, JSONObject.toJSONString(materialIdList), JSONObject.toJSONString(rtnList)});
        return rtnList;
    }
}

