package com.ejianc.business.wpsofficeedit.constants;

/**
 * WPS回调返回值枚举
 *
 * @author CJ
 * @Description: WPS回调返回值枚举
 * @date 2021/11/30 9:56
 */
public enum  WpsReturnCodeEnum {

    /**
     * 服务器处理正常
     */
    Success(0, "OK", "服务器处理正常"),

    /**
     * token过期
     */
    SessionExpired	(40002, "SessionExpired", "token过期"),

    /**
     * 参数错误
     */
    InvalidArgs(40005, "InvalidArgument", "参数错误"),
    /**
     * 用户无权限访问
     */
    PermissionDenied(40003, "PermissionDenied", "用户无权限访问"),
    /**
     * 资源不存在
     */
    NotExists(40004, "NotExists", "资源不存在"),
    /**
     * 保存空间已满
     */
    SpaceFull(40006, "SpaceFull", "保存空间已满"),
    /**
     * 自定义错误提示
     */
    CustomMsg(40007, "CustomMsg", "自定义错误提示，前端页面将显示此错误内容"),
    /**
     * 文件重命名冲突
     */
    FnameConflict(40008, "FnameConflict", "文件重命名冲突"),
    /**
     * 对接系统错误
     */
    ServerError(50001, "ServerError", "对接系统错误");

    /**
     * 回调返回值
     */
    private Integer code;
    /**
     * 回调调用结果
     */
    private String message;
    /**
     * 说明
     */
    private String details;

    WpsReturnCodeEnum(Integer code, String message, String details) {
        this.code = code;
        this.message = message;
        this.details = details;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDetails() {
        return details;
    }

    public void setDetails(String details) {
        this.details = details;
    }
}
