package com.ejianc.business.wpsofficeedit.controller;

import com.ejianc.business.wpsofficeedit.service.IBillEditInfoService;
import com.ejianc.business.wpsofficeedit.vo.BillEditInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author CJ
 * @Description:
 * @date 2022/6/1 10:26
 */
@RestController
@RequestMapping(value = "/billedit/")
public class BillEditController {

    @Autowired
    private IBillEditInfoService billEditInfoService;

    @PostMapping(value = "saveBillEditInfo")
    public CommonResponse<BillEditInfoVO> saveBillEditInfo(@RequestBody BillEditInfoVO billEditInfoVO) {
        BillEditInfoVO resp = billEditInfoService.saveBillEditInfo(billEditInfoVO);

        return CommonResponse.success("保存成功！", resp);
    }

}
