/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wpsofficeedit.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.ejianc.business.contractbase.api.ITemplateApi;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.business.wpsofficeedit.bean.BillEditInfoEntity;
import com.ejianc.business.wpsofficeedit.constants.WpsReturnCodeEnum;
import com.ejianc.business.wpsofficeedit.service.IBillEditInfoService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DESUtils;
import com.ejianc.framework.core.util.HttpTookit;
import feign.Response;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/wpscbk/"})
public class WpsCallbackController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ITemplateApi templateApi;
    @Autowired
    @Value(value="${wps.domain}")
    private String wpsDomain;
    @Value(value="${wps.appId}")
    private String wpsAppId;
    @Value(value="${wps.appKey}")
    private String wpsAppKey;
    @Value(value="${fileUrl}")
    private String fileUrl;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private CacheManager cacheManager;
    private final String SESSION_PREFIX = "ICOP_SESSION_USER:";
    private final String WPS_ONLINE_USER = "WPS_ONLINE_USER:";
    private final int timeout = 3600;
    @Autowired
    private IBillEditInfoService billEditInfoService;
    private final String templateBillTypeCode = "BT211109000000003";
    private final String templateFileSourceType = "template";

    @GetMapping(value={"getUserToken"})
    public CommonResponse<String> getUserToken() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String cacheKey = DESUtils.decrypt((String)(InvocationInfoProxy.getUserid() + "::wpsUserToken::" + sdf.format(new Date())));
        this.cacheManager.setex(cacheKey, (Serializable)((Object)InvocationInfoProxy.getToken()), 600);
        return CommonResponse.success((String)"\u83b7\u53d6\u7528\u6237wpsToken\u6210\u529f", (Object)cacheKey);
    }

    @GetMapping(value={"getWpsUrl"})
    public CommonResponse<JSONObject> getWpsUrl(@RequestParam(value="categoryId", required=false) Long categoryId, @RequestParam(value="templateId", required=false) Long templateId, @RequestParam(value="permission") String permission, @RequestParam(value="billType") String billType, @RequestParam(value="fileId", required=false) String fileId, @RequestParam(value="sourceId", required=false) String sourceId, @RequestParam(value="reFillData", required=false, defaultValue="false") String reFillData, @RequestParam(value="sourceType", required=false, defaultValue="template") String sourceType) throws UnsupportedEncodingException {
        BillEditInfoEntity billEdit;
        TemplateVO template = null;
        JSONObject resp = new JSONObject();
        String wpsFileId = null;
        String replaceFile = "false";
        if (null == categoryId && null == templateId && "template".equals(sourceType)) {
            return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25\uff0c\u6a21\u677f\u53c2\u6570categoryId/templateId\u4e3a\u7a7a");
        }
        String authority = this.checkOnLine(InvocationInfoProxy.getUserid().toString(), InvocationInfoProxy.getToken());
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        CommonResponse tempResp = null;
        if (null == templateId) {
            tempResp = this.templateApi.getByCategoryId(categoryId);
            if (StringUtils.isBlank((String)sourceId)) {
                return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25\uff0c\u53c2\u6570sourceId\u4e3a\u7a7a");
            }
            if (!tempResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u53c2\u6570: templateId-{}, categoryId-{}[templateId\u4f18\u5148\u7ea7\u9ad8\u4e8ecategoryId]\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{templateId, categoryId, tempResp.getMsg()});
                return CommonResponse.error((String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\uff01");
            }
        } else {
            tempResp = this.templateApi.queryDetailById(templateId);
            if (StringUtils.isBlank((String)sourceId)) {
                sourceId = templateId.toString();
            }
        }
        template = (TemplateVO)tempResp.getData();
        if (null == categoryId) {
            categoryId = template.getCategoryId();
        }
        if ("template".equals(sourceType)) {
            wpsFileId = template.getFileId().toString();
        } else {
            replaceFile = "true";
            CommonResponse fileQueryResp = this.attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, "desc");
            if (!fileQueryResp.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636esourceId-{},sourceType-{},billType-{}\u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{sourceId, billType, sourceType, fileQueryResp.getMsg()});
                return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)fileQueryResp.getData()))) {
                wpsFileId = ((AttachmentVO)((List)fileQueryResp.getData()).get(0)).getId().toString();
            } else {
                CommonResponse fileCopyResp = this.attachmentApi.copyFile(template.getFileId().toString(), sourceId, billType, sourceType, true);
                if (!fileCopyResp.isSuccess()) {
                    this.logger.error("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25: {}", (Object)fileCopyResp.getMsg());
                    return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff01");
                }
                wpsFileId = ((AttachmentVO)fileCopyResp.getData()).getId().toString();
            }
            billEdit = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById((Serializable)((Object)sourceId)));
            resp.put("curQRBase64", (Object)(null != billEdit ? billEdit.getqRCodeBase64() : null));
        }
        Long tmplId = template.getId();
        billEdit = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById(tmplId));
        resp.put("templQRBase64", (Object)(null != billEdit ? billEdit.getqRCodeBase64() : null));
        if ("template".equals(sourceType)) {
            resp.put("curQRBase64", (Object)(null != billEdit ? billEdit.getqRCodeBase64() : null));
        }
        String url = this.wpsDomain + "/office/" + this.getFileType(template.getFileName()) + "/" + wpsFileId + "?";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("_w_appid", this.wpsAppId);
        paramMap.put("_w_fileid", wpsFileId);
        paramMap.put("_w_permission", permission);
        paramMap.put("_w_bill_type", billType);
        paramMap.put("_w_category_id", null != categoryId ? categoryId.toString() : null);
        paramMap.put("_w_token", InvocationInfoProxy.getToken());
        paramMap.put("_w_uid", InvocationInfoProxy.getUserid().toString());
        paramMap.put("_w_source_type", sourceType);
        paramMap.put("_w_refill_data", reFillData);
        paramMap.put("_w_source_id", sourceId);
        paramMap.put("_w_replace", replaceFile);
        paramMap.put("_w_template_id", tmplId.toString());
        paramMap.put("_w_source_attach_id", wpsFileId);
        String signature = this.getSignature(paramMap, this.wpsAppKey);
        url = url + this.getUrlParam(paramMap) + "&_w_signature=" + signature;
        resp.put("wpsUrl", (Object)url);
        resp.put("token", (Object)"1");
        resp.put("metadata", (Object)template.getMetadata());
        resp.put("templateId", (Object)tmplId);
        resp.put("templateInfo", (Object)template);
        resp.put("billId", "template".equals(sourceType) ? tmplId : sourceId);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"/v1/3rd/file/history"})
    public Object getFileHistory(@RequestParam(value="_w_fileid") String wpsFileId, @RequestParam(value="_w_token") String uToken, @RequestParam(value="_w_uid") String userId, @RequestParam(value="_w_bill_type") String billType, @RequestParam(value="_w_template_id") String templateId, @RequestParam(value="_w_source_id") String sourceId, @RequestParam(value="_w_source_type", required=false, defaultValue="template") String sourceType, @RequestParam(value="_w_source_attach_id", required=false) String fileId, @RequestParam(value="_w_category_id", required=false) String categoryId, @RequestParam(value="_w_permission", required=false, defaultValue="read") String permission, @RequestParam(value="_w_previewPages", required=false, defaultValue="0") int previewPages, @RequestBody JSONObject pageParam) {
        JSONObject resp = new JSONObject();
        String authority = this.checkOnLine(userId, uToken);
        if (null == authority) {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u7528\u6237\u4f1a\u8bdd\u4fe1\u606f\u5931\u6548\uff01");
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        ArrayList<JSONObject> fileHistList = new ArrayList<JSONObject>();
        switch (sourceType) {
            case "contractFile": {
                CommonResponse attachResp = this.attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, null);
                if (!attachResp.isSuccess()) {
                    this.logger.error("\u6839\u636etemplateId-{}, start-{}, size-{}\u67e5\u8be2\u6a21\u677f\u7248\u672c\u5217\u8868\u5931\u8d25\uff0c{}", new Object[]{sourceId, pageParam.getInteger("offset"), pageParam.getInteger("count"), attachResp.getMsg()});
                    return this.getReturnMsg(WpsReturnCodeEnum.ServerError, null);
                }
                List files = (List)attachResp.getData();
                if (!CollectionUtils.isNotEmpty((Collection)files)) break;
                AttachmentVO attachmentVO = (AttachmentVO)files.get(0);
                JSONObject tmp = new JSONObject();
                JSONObject creator = new JSONObject();
                tmp.put("id", (Object)sourceId);
                tmp.put("name", (Object)attachmentVO.getFileName());
                tmp.put("size", (Object)attachmentVO.getFileSize());
                tmp.put("version", (Object)attachmentVO.getVersion());
                tmp.put("download_url", (Object)(this.BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type=" + billType + "&_w_source_id=" + sourceId + "&_w_template_id=" + templateId + "&_w_fileid=" + sourceId + "&_w_source_type=template&_w_source_attach_id=" + attachmentVO.getId()));
                tmp.put("create_time", (Object)attachmentVO.getCreateTime().getTime());
                if (null != attachmentVO.getUpdateTime()) {
                    tmp.put("modify_time", (Object)attachmentVO.getUpdateTime().getTime());
                }
                creator.put("id", (Object)attachmentVO.getCreateUserCode());
                creator.put("name", (Object)attachmentVO.getCreateUserName());
                creator.put("avatar_url", (Object)"");
                tmp.put("creator", (Object)creator);
                fileHistList.add(tmp);
                break;
            }
            default: {
                CommonResponse listResp = this.templateApi.getHisListByTemplateId(sourceId, pageParam.getInteger("offset").intValue(), pageParam.getInteger("count").intValue());
                if (!listResp.isSuccess()) {
                    this.logger.error("\u6839\u636etemplateId-{}, start-{}, size-{}\u67e5\u8be2\u6a21\u677f\u7248\u672c\u5217\u8868\u5931\u8d25\uff0c{}", new Object[]{sourceId, pageParam.getInteger("offset"), pageParam.getInteger("count"), listResp.getMsg()});
                    return this.getReturnMsg(WpsReturnCodeEnum.ServerError, null);
                }
                ((List)listResp.getData()).forEach(item -> {
                    JSONObject tmp = new JSONObject();
                    JSONObject creator = new JSONObject();
                    tmp.put("id", (Object)item.getFileId().toString());
                    tmp.put("name", (Object)item.getFileName());
                    tmp.put("size", (Object)item.getFileSize());
                    tmp.put("version", (Object)item.getTemplateVersion());
                    tmp.put("download_url", (Object)(this.BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type=" + billType + "&_w_source_id=" + sourceId + "&_w_template_id=" + templateId + "&_w_fileid=" + item.getFileId().toString() + "&_w_source_type=template&_w_source_attach_id=" + item.getFileId()));
                    tmp.put("create_time", (Object)item.getCreateTime().getTime());
                    if (null != item.getUpdateTime()) {
                        tmp.put("modify_time", (Object)item.getUpdateTime().getTime());
                    }
                    creator.put("id", (Object)item.getCreateUserCode());
                    creator.put("name", (Object)item.getCreateUserName());
                    creator.put("avatar_url", (Object)"");
                    tmp.put("creator", (Object)creator);
                    fileHistList.add(tmp);
                });
            }
        }
        resp.put("histories", fileHistList);
        return resp.toString();
    }

    @GetMapping(value={"/v1/3rd/file/info"}, produces={"application/json;charset=UTF-8"})
    public Object getFileInfo(@RequestParam(value="_w_fileid") String wpsFileId, @RequestParam(value="_w_token") String uToken, @RequestParam(value="_w_uid") String userId, @RequestParam(value="_w_bill_type") String billType, @RequestParam(value="_w_template_id") String templateId, @RequestParam(value="_w_source_id") String sourceId, @RequestParam(value="_w_source_type", required=false, defaultValue="template") String sourceType, @RequestParam(value="_w_source_attach_id", required=false) String fileId, @RequestParam(value="_w_category_id", required=false) String categoryId, @RequestParam(value="_w_permission", required=false, defaultValue="read") String permission, @RequestParam(value="_w_previewPages", required=false, defaultValue="0") int previewPages, @RequestParam(value="_w_replace", required=false, defaultValue="false") String replace) throws Exception {
        return this.fileVersionInfo(null, wpsFileId, uToken, userId, billType, templateId, sourceId, sourceType, fileId, categoryId, permission, previewPages, replace);
    }

    @GetMapping(value={"/v1/3rd/file/version/{version}"}, produces={"application/json;charset=UTF-8"})
    public Object fileVersionInfo(@PathVariable(value="version") Long version, @RequestParam(value="_w_fileid") String wpsFileId, @RequestParam(value="_w_token") String uToken, @RequestParam(value="_w_uid") String userId, @RequestParam(value="_w_bill_type") String billType, @RequestParam(value="_w_template_id") String templateId, @RequestParam(value="_w_source_id") String sourceId, @RequestParam(value="_w_source_type", required=false, defaultValue="template") String sourceType, @RequestParam(value="_w_source_attach_id", required=false) String fileId, @RequestParam(value="_w_category_id", required=false) String categoryId, @RequestParam(value="_w_permission", required=false, defaultValue="read") String permission, @RequestParam(value="_w_previewPages", required=false, defaultValue="0") int previewPages, @RequestParam(value="_w_replace", required=false, defaultValue="false") String replace) throws Exception {
        String authority = this.checkOnLine(userId, uToken);
        if (null == authority) {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u7528\u6237\u4f1a\u8bdd\u4fe1\u606f\u5931\u6548\uff01");
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        JSONObject resp = new JSONObject();
        JSONObject userInfo = this.getCurUser(userId, uToken);
        userInfo.put("permission", (Object)permission);
        JSONObject fileInfo = null;
        switch (sourceType) {
            case "contractFile": {
                fileInfo = this.getFile(sourceId, sourceType, billType, fileId, categoryId);
                break;
            }
            default: {
                fileInfo = this.getTmplFileInfo(Long.valueOf(sourceId), version, billType);
            }
        }
        if (!Boolean.valueOf(fileInfo.get((Object)"oprResult").toString()).booleanValue()) {
            fileInfo.remove((Object)"oprResult");
            return fileInfo;
        }
        fileInfo.put("download_url", (Object)(fileInfo.get((Object)"download_url").toString() + "&_w_source_id=" + sourceId + "&_w_template_id=" + templateId + "&_w_uid=" + userId + "&_w_token=" + uToken + "&_w_replace=" + replace));
        fileInfo.remove((Object)"oprResult");
        fileInfo.put("id", (Object)wpsFileId);
        resp.put("file", (Object)fileInfo);
        resp.put("user", (Object)userInfo);
        this.logger.info("fileVersionInfo: {}", (Object)JSONObject.toJSONString((Object)resp));
        return resp.toString();
    }

    public JSONObject getCurUser(String userId, String uToken) {
        String userContextStr = this.sessionManager.getSessionCacheAttribute("ICOP_SESSION_USER:" + userId, uToken);
        UserContext userContext = (UserContext)JSONObject.parseObject((String)userContextStr, UserContext.class);
        JSONObject resp = new JSONObject();
        resp.put("id", (Object)userContext.getUserId().toString());
        resp.put("name", (Object)userContext.getUserName());
        resp.put("avatar_url", (Object)userContext.getUserAvator());
        return resp;
    }

    @RequestMapping(value={"/v1/3rd/user/info"}, method={RequestMethod.POST})
    @ResponseBody
    public Object onLineUsersInfo(@RequestBody String userIds, @RequestParam(value="_w_fileid") String wpsFileId, @RequestParam(value="_w_token") String uToken, @RequestParam(value="_w_uid") String userId, @RequestParam(value="_w_bill_type") String billType, @RequestParam(value="_w_source_id") String sourceId, @RequestParam(value="_w_source_type", required=false, defaultValue="template") String sourceType, @RequestParam(value="_w_source_attach_id", required=false) String fileId) {
        JSONObject resp = this.getReturnMsg(WpsReturnCodeEnum.Success, null);
        JSONArray users = new JSONArray();
        if (StringUtils.isNotBlank((String)userIds)) {
            JSONArray jsonArray = JSONObject.parseObject((String)userIds).getJSONArray("ids");
            if (null != jsonArray && jsonArray.size() > 0) {
                String authority = this.checkOnLine(userId, uToken);
                InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
                CommonResponse userResp = this.userApi.queryListByIds((String[])jsonArray.toArray((Object[])new String[jsonArray.size()]));
                if (!userResp.isSuccess()) {
                    this.logger.error("\u6839\u636e\u7528\u6237Id-{}\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25, msg-{}", (Object)userIds, (Object)userResp.getMsg());
                    users.add((Object)this.getCurUser(userId, uToken));
                } else {
                    ((List)userResp.getData()).stream().forEach(user -> {
                        JSONObject userInfo = new JSONObject();
                        userInfo.put("id", (Object)user.getId().toString());
                        userInfo.put("name", (Object)user.getUserName());
                        userInfo.put("avatar_url", (Object)(StringUtils.isNotBlank((String)user.getAvator()) ? user.getAvator() : ""));
                        users.add((Object)userInfo);
                    });
                }
            } else {
                users.add((Object)this.getCurUser(userId, uToken));
            }
        } else {
            users.add((Object)this.getCurUser(userId, uToken));
        }
        resp.put("users", (Object)users);
        return resp.toString();
    }

    @RequestMapping(value={"/v1/3rd/file/online"}, method={RequestMethod.POST})
    @ResponseBody
    public Object online(@RequestBody String userIds, @RequestParam(value="_w_fileid") String wpsFileId, @RequestParam(value="_w_token") String uToken, @RequestParam(value="_w_uid") String userId, @RequestParam(value="_w_bill_type") String billType, @RequestParam(value="_w_source_id") String sourceId, @RequestParam(value="_w_source_type", required=false, defaultValue="template") String sourceType, @RequestParam(value="_w_source_attach_id", required=false) String fileId) {
        this.logger.info("\u9644\u4ef6wpsFileId-{},sourceId-{},billType-{},sourceType-{}\u63a5\u6536\u5230\u534f\u4f5c\u7528\u6237\u4fe1\u606fuserIds-{},uid-{},uToken-{}", new Object[]{wpsFileId, sourceId, billType, sourceType, userIds, userId, uToken});
        String cacheKey = "WPS_ONLINE_USER:" + wpsFileId;
        if (StringUtils.isNotBlank((String)userIds)) {
            JSONArray jsonArray = JSONObject.parseObject((String)userIds).getJSONArray("ids");
            if (null != jsonArray && jsonArray.size() > 0) {
                this.cacheManager.setex(cacheKey, (Serializable)((Object)JSONObject.toJSONString((Object)jsonArray)), 3600);
            } else {
                this.cacheManager.removeCache(cacheKey);
            }
        } else {
            this.cacheManager.removeCache(cacheKey);
        }
        return this.getReturnMsg(WpsReturnCodeEnum.Success, null).toString();
    }

    private String checkOnLine(String userId, String token) {
        this.logger.info("wpscbk check user session online: userId-{}, token-{}", (Object)userId, (Object)token);
        boolean isOnline = this.sessionManager.validateOnlineSession(userId, token);
        if (isOnline) {
            return this.getAuthority(userId, token);
        }
        this.logger.info("wpscbk check user session invalid: userId-{}, token-{}", (Object)userId, (Object)token);
        return null;
    }

    private String getAuthority(String userId, String token) {
        try {
            String sid = "ICOP_SESSION_USER:" + userId;
            String userContextStr = this.sessionManager.getSessionCacheAttribute(sid, token);
            if (StringUtils.isNotBlank((String)userContextStr)) {
                UserContext userContext = (UserContext)JSONObject.parseObject((String)userContextStr, UserContext.class);
                this.logger.debug("wpscbk check user session online: userId-{}, token-{}, userContext-{}", new Object[]{userId, token, JSONObject.toJSONString((Object)userContext)});
                return "userType=" + userContext.getUserType() + ";userCode=" + URLEncoder.encode(userContext.getUserCode(), "UTF-8") + ";userName=" + URLEncoder.encode(userContext.getUserName(), "UTF-8") + ";orgId=" + userContext.getOrgId() + ";orgName=" + URLEncoder.encode(userContext.getOrgName(), "UTF-8") + ";tenantid=" + userContext.getTenantid() + ";token=" + userContext.getToken() + ";u_logints=" + userContext.getU_logints() + ";u_usercode=" + userContext.getU_usercode() + ";u_locale=" + userContext.getU_locale() + ";userId=" + userId;
            }
        }
        catch (Exception e) {
            this.logger.info("wpscbk check user session error: userId-{}, token-{}", new Object[]{userId, token, e});
            return null;
        }
        return null;
    }

    @PostMapping(value={"v1/3rd/file/save"}, produces={"application/json;charset=UTF-8"})
    public Object saveFile(@RequestParam(value="file") MultipartFile file, @RequestParam(value="_w_fileid") String wpsFileId, @RequestParam(value="_w_source_type", required=false, defaultValue="template") String sourceType, @RequestParam(value="_w_bill_type") String billType, @RequestParam(value="_w_token") String uToken, @RequestParam(value="_w_uid") String userId, @RequestParam(value="_w_source_id") String sourceId, @RequestParam(value="_w_template_id") String templateId, @RequestParam(value="_w_category_id", required=false) String categoryId, @RequestParam(value="_w_source_attach_id", required=false) String fileId, @RequestParam(value="_w_original_file_name", required=false) String originalFileNameStr, @RequestParam(value="_w_refill_data", required=false, defaultValue="false") String reFillData, @RequestParam(value="_w_replace", required=false, defaultValue="false") String replace) {
        this.logger.info("\u63a5\u6536\u5230\u6a21\u677f\u4fdd\u5b58\u8bf7\u6c42\uff1asourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}", new Object[]{sourceId, sourceType, billType, originalFileNameStr, replace});
        JSONObject resp = new JSONObject();
        JSONObject fileInfo = null;
        String authority = this.checkOnLine(userId, uToken);
        if (null != authority) {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sourceType", sourceType);
            params.put("sourceId", sourceId);
            params.put("billType", billType);
            params.put("originalFileNameStr", StringUtils.isNotBlank((String)originalFileNameStr) ? originalFileNameStr : file.getOriginalFilename());
            params.put("replace", replace);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", authority);
            AttachmentVO attachmentVO = null;
            try {
                String fileUploadRespStr;
                CommonResponse attachmentResp;
                if (!"template".equals(sourceType)) {
                    String queryFileRespStr = HttpTookit.get((String)(this.BASE_HOST + "ejc-file-web/api/attachref/queryListBySourceId"), params, headers);
                    CommonResponse queryFileResp = (CommonResponse)JSONObject.parseObject((String)queryFileRespStr, CommonResponse.class);
                    if (!queryFileResp.isSuccess()) {
                        this.logger.error("\u67e5\u8be2\u5f53\u524d\u5355\u636e\u7f16\u8f91\u6587\u4ef6\u4fe1\u606f\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, originalFileNameStr, replace, queryFileResp.getMsg()});
                        return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff01").toString();
                    }
                    String curBillFileId = queryFileResp.getData() != null ? ((AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)queryFileResp.getData()).get(0)), AttachmentVO.class)).getId().toString() : null;
                    this.logger.info("\u5f53\u524d\u5f85\u4fdd\u5b58\u9644\u4ef6Id-{}\uff0c\u5408\u540c\u6587\u4ef6Id-{}", (Object)wpsFileId, curBillFileId);
                    if (CollectionUtils.isEmpty((Collection)((Collection)queryFileResp.getData())) || !wpsFileId.equals(curBillFileId)) {
                        this.logger.info("\u5f53\u524d\u5f85\u6587\u4ef6\u4fe1\u606f\u4e0e\u5355\u636e\u7f16\u8f91\u6587\u4ef6\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u8fdb\u884c\u4fdd\u5b58\uff01");
                        return this.getReturnMsg(WpsReturnCodeEnum.Success, "\u670d\u52a1\u5904\u7406\u4e2d...").toString();
                    }
                }
                if (!(attachmentResp = (CommonResponse)JSONObject.parseObject((String)(fileUploadRespStr = WpsCallbackController.postFile(this.BASE_HOST + "ejc-file-web/attachment/upload", params, headers, file)), CommonResponse.class)).isSuccess()) {
                    this.logger.error("\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c\u539f\u56e0\uff1a{}", new Object[]{sourceId, sourceType, billType, originalFileNameStr, replace, attachmentResp.getMsg()});
                    return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff01").toString();
                }
                attachmentVO = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString(((List)attachmentResp.getData()).get(0)), AttachmentVO.class);
            }
            catch (Exception e) {
                this.logger.error("\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6\u5f02\u5e38sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}\uff0c", new Object[]{sourceId, sourceType, billType, originalFileNameStr, replace, e});
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u4fdd\u5b58\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff01").toString();
            }
            this.logger.info("\u6a21\u677f\u6587\u4ef6\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)JSONObject.toJSONString((Object)attachmentVO));
            switch (sourceType) {
                case "contractFile": {
                    fileInfo = this.updateFileInfo(attachmentVO, billType, authority, Long.valueOf(templateId), attachmentVO.getId());
                    break;
                }
                default: {
                    fileInfo = this.newTemplateVersion(attachmentVO, sourceId, authority, billType);
                }
            }
            this.logger.info("\u6a21\u677f\u4fe1\u606f\u66f4\u65b0\u7ed3\u679c\uff1a{}", (Object)fileInfo);
            if (!Boolean.valueOf(fileInfo.get((Object)"oprResult").toString()).booleanValue()) {
                fileInfo.remove((Object)"oprResult");
                return fileInfo;
            }
        } else {
            return this.getReturnMsg(WpsReturnCodeEnum.SessionExpired, "\u7528\u6237\u4f1a\u8bdd\u4fe1\u606f\u5931\u6548\uff01").toString();
        }
        fileInfo.put("download_url", (Object)(fileInfo.get((Object)"download_url").toString() + "&_w_source_id=" + sourceId + "&_w_uid=" + userId + "&_w_token=" + uToken));
        fileInfo.remove((Object)"oprResult");
        resp.put("file", (Object)fileInfo);
        return resp.toString();
    }

    @PostMapping(value={"resetContractFile"})
    public CommonResponse<AttachmentVO> resetContractFile(@RequestParam(value="templateId", required=false) String templateId, @RequestParam(value="categoryId", required=false) String categoryId, @RequestParam(value="sourceId") String sourceId, @RequestParam(value="sourceType") String sourceType, @RequestParam(value="billType") String billType, HttpServletRequest request) {
        CommonResponse tempResp;
        if (null == templateId && null == categoryId) {
            return CommonResponse.error((String)"\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff0c\u53c2\u6570templateId\u3001categoryId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        TemplateVO template = null;
        if (null != templateId) {
            tempResp = this.templateApi.queryDetailById(Long.valueOf(templateId));
            if (!tempResp.isSuccess()) {
                this.logger.error("\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25, \u4f9d\u636eid-{}\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25: {}", (Object)templateId, (Object)tempResp.getMsg());
                return CommonResponse.error((String)"\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff0c\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
            }
            template = (TemplateVO)tempResp.getData();
        } else {
            tempResp = this.templateApi.getByCategoryId(Long.valueOf(categoryId));
            if (!tempResp.isSuccess()) {
                this.logger.error("\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25, \u4f9d\u636ecategoryId-{}\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25: {}", (Object)categoryId, (Object)tempResp.getMsg());
                return CommonResponse.error((String)"\u4ece\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u5931\u8d25\uff0c\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
            }
            template = (TemplateVO)tempResp.getData();
        }
        CommonResponse fileCopyResp = this.attachmentApi.copyFile(template.getFileId().toString(), sourceId, billType, sourceType, true);
        this.logger.error("\u6839\u636e\u4ece\u5408\u540c\u6a21\u677f\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6,\u53c2\u6570--->sourceFileId-{}, sourceId-{}, sourceType-{}, billType-{}, \u7ed3\u679c-->{}", new Object[]{template.getFileId().toString(), sourceId, sourceType, billType, JSONObject.toJSONString((Object)fileCopyResp)});
        if (!fileCopyResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25: {}", (Object)fileCopyResp.getMsg());
            return CommonResponse.error((String)"\u83b7\u53d6\u6a21\u677f\u6587\u4ef6\u8bbf\u95eeurl\u5931\u8d25, \u6839\u636e\u6a21\u677f\u6587\u4ef6\u751f\u6210\u65b0\u7684\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff01");
        }
        BillEditInfoEntity billEdit = (BillEditInfoEntity)((Object)this.billEditInfoService.selectById((Serializable)((Object)sourceId)));
        if (null != billEdit) {
            billEdit.setqRCodeBase64(null);
            this.billEditInfoService.saveOrUpdate((Object)billEdit, false);
        }
        this.updateFileInfo((AttachmentVO)fileCopyResp.getData(), billType, request.getHeader("authority"), null, null);
        return CommonResponse.success((String)"\u91cd\u65b0\u751f\u6210\u6587\u4ef6\u6210\u529f\uff01", (Object)fileCopyResp.getData());
    }

    @PostMapping(value={"updateSignFileInfo"})
    public CommonResponse<AttachmentVO> updateSignFileInfo(@RequestBody AttachmentVO attachmentVO) {
        String authority = this.getAuthority(InvocationInfoProxy.getUserid().toString(), InvocationInfoProxy.getToken());
        if (StringUtils.isBlank((String)authority)) {
            this.logger.error("\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606ffileInfo-\u3010{}\u3011\u66f4\u65b0\u5931\u6557\uff0c\u83b7\u53d6Authority\u5931\u8d25\uff01", (Object)JSONObject.toJSONString((Object)attachmentVO));
            return CommonResponse.error((String)"\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u5931\u6557\uff0c\u83b7\u53d6Authority\u5931\u8d25\uff01");
        }
        JSONObject updateResult = this.updateFileInfo(attachmentVO, attachmentVO.getBillType(), authority, null, null);
        if (updateResult.getBoolean("oprResult").booleanValue()) {
            return CommonResponse.success((String)"\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)attachmentVO);
        }
        return CommonResponse.error((String)updateResult.getString("details"));
    }

    public JSONObject updateFileInfo(AttachmentVO attachmentVO, String billType, String authority, Long templateId, Long mainFileId) {
        JSONObject resp = new JSONObject();
        resp.put("oprResult", (Object)true);
        boolean mergeFlag = false;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("authority", authority);
        headerMap.put("content-type", "application/json;charset=UTF-8");
        CommonResponse mdRefResp = this.billTypeApi.queryMetadataByBillType(billType);
        if (!mdRefResp.isSuccess()) {
            this.logger.error("\u9644\u4ef6\u66f4\u65b0\u5931\u8d25,\u6839\u636ebillType-{}\u67e5\u8be2\u5143\u6570\u636e\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a{}\uff01", (Object)billType, (Object)mdRefResp.getMsg());
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u66f4\u65b0\u5931\u8d25\uff01");
        }
        MdReferVO mdRef = (MdReferVO)mdRefResp.getData();
        String entityNameFmt = mdRef.getEntityName().replace("Entity", "");
        String httpReqPrefix = this.BASE_HOST + mdRef.getProjectName() + "/" + entityNameFmt.substring(0, 1).toLowerCase() + entityNameFmt.substring(1);
        AttachmentVO wholeDataFile = null;
        if (null != templateId) {
            HashMap<String, Long> detailQueryParam = new HashMap<String, Long>();
            detailQueryParam.put("templateId", templateId);
            try {
                String detailExportListJson = HttpTookit.get((String)(this.BASE_HOST + "ejc-contractbase-web/api/templDetail/findExportDetailByCategoryId"), detailQueryParam, headerMap);
                this.logger.error("\u67e5\u8be2\u5408\u540c\u6a21\u677fId-{},\u5bf9\u5e94\u5bfc\u51fa\u6a21\u677f\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\uff1a{}", (Object)templateId, (Object)detailExportListJson);
                CommonResponse templDetailResp = (CommonResponse)JSONObject.parseObject((String)detailExportListJson, CommonResponse.class);
                if (!templDetailResp.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u5408\u540c\u6a21\u677fId-{},\u5bf9\u5e94\u5bfc\u51fa\u6a21\u677f\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)templateId), (Object)templDetailResp.getMsg());
                    return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u540c\u6b65\u4fdd\u5b58\u5931\u8d25\uff01");
                }
                List detailList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)templDetailResp.getData()), TemplDetailExportSettingVO.class);
                HashMap billData = new HashMap();
                HashMap<String, String> billDataQuery = new HashMap<String, String>();
                billDataQuery.put("id", attachmentVO.getSourceId().toString());
                String billDataQueryUrl = httpReqPrefix + "FileUpdate/getBillDataJson";
                String billDataQueryRespStr = HttpTookit.get((String)billDataQueryUrl, billDataQuery, headerMap);
                this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{}\u67e5\u8be2\u4e1a\u52a1\u5355\u636e\u8be6\u60c5\u7ed3\u679c\uff1a{}", new Object[]{billDataQueryUrl, JSONObject.toJSONString(billDataQuery), billDataQueryRespStr});
                CommonResponse billDataResp = (CommonResponse)JSONObject.parseObject((String)billDataQueryRespStr, CommonResponse.class);
                if (!billDataResp.isSuccess()) {
                    return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5355\u636e\u8be6\u60c5\u4fe1\u606f\u5931\u8d25\uff01");
                }
                JSONObject billDataJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)billDataResp.getData()));
                ArrayList<Future<File>> backFileIdFutures = new ArrayList<Future<File>>(detailList.size());
                HashMap<String, Integer> sequence = new HashMap<String, Integer>();
                for (TemplDetailExportSettingVO templDetail : detailList) {
                    if (null == templDetail.getCustomFileId() && null == templDetail.getSysFileId()) continue;
                    backFileIdFutures.add(this.getTemplDetailPdfFileId(templDetail, attachmentVO.getSourceId(), billDataJson.getJSONArray(templDetail.getMainAttrName()), authority, sequence));
                }
                File tempFile = null;
                HashMap filesMap = new HashMap();
                for (Future future : backFileIdFutures) {
                    HashMap<String, FileInputStream> fileMap = new HashMap<String, FileInputStream>();
                    tempFile = (File)future.get();
                    this.logger.info("\u83b7\u53d6\u5230\u5b50\u8868\u6587\u4ef6\uff1a{}", (Object)tempFile.getName());
                    fileMap.put(tempFile.getName(), new FileInputStream(tempFile));
                    filesMap.put(tempFile.getName(), fileMap);
                }
                HashMap<String, String> mergeParams = new HashMap<String, String>();
                mergeParams.put("sourceId", attachmentVO.getSourceId().toString());
                mergeParams.put("sourceType", "billWholeDataPdf");
                mergeParams.put("billType", attachmentVO.getBillType());
                mergeParams.put("mainFileId", attachmentVO.getId().toString());
                mergeParams.put("replace", "true");
                mergeParams.put("mergeSequence", JSONObject.toJSONString(sequence));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("authority", authority);
                String fileMergeResult = HttpTookit.postFiles((String)(this.BASE_HOST + "ejc-file-web/attachment/uploadAndMerge2Pdf"), mergeParams, hashMap, filesMap, (Integer)10000, (Integer)10000);
                this.logger.info("\u6587\u4ef6\u5408\u5e76-\u3010\u53c2\u6570\uff1a{}\uff0cheader-{}, \u4e0a\u4f20\u6587\u4ef6\u6570\u91cf\uff1a{}\u3011\u7ed3\u679c\uff1a{}", new Object[]{JSONObject.toJSONString(mergeParams), JSONObject.toJSONString(hashMap), filesMap.keySet().size(), fileMergeResult});
                CommonResponse wholeDataAttchResp = (CommonResponse)JSONObject.parseObject((String)fileMergeResult, CommonResponse.class);
                if (!wholeDataAttchResp.isSuccess()) {
                    this.logger.error("\u751f\u6210\u5355\u636e\u5168\u6570\u636ePDF\u6587\u4ef6\u5931\u8d25\uff01");
                }
                wholeDataFile = (AttachmentVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)wholeDataAttchResp.getData()), AttachmentVO.class);
                mergeFlag = true;
            }
            catch (Exception e) {
                this.logger.error("\u67e5\u8be2\u5408\u540c\u6a21\u677fId-{},\u5bf9\u5e94\u5bfc\u51fa\u6a21\u677f\u8bbe\u7f6e\u5217\u8868\u5f02\u5e38\uff1a", (Object)templateId, (Object)e);
            }
        }
        String url = httpReqPrefix + "FileUpdate/updateFileInfo";
        this.logger.info("\u66f4\u65b0\u4e1a\u52a1\u7cfb\u7edf\u9644\u4ef6\u4fe1\u606f\u5730\u5740\uff1a{}", (Object)url);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (mergeFlag && wholeDataFile != null) {
            param.put("billId", wholeDataFile.getSourceId());
            param.put("sourceType", wholeDataFile.getSourceType());
            param.put("billType", billType);
            param.put("fileId", wholeDataFile.getId());
            param.put("fileSize", wholeDataFile.getFileSize());
            param.put("fileName", wholeDataFile.getFileName());
            param.put("fileOnlinePath", wholeDataFile.getOnlinePath());
            param.put("imgServerPath", wholeDataFile.getImgServerPath());
            param.put("formatPathStr", wholeDataFile.getFileFormatPathStr());
            param.put("fileVersion", wholeDataFile.getVersion());
        } else {
            param.put("billId", attachmentVO.getSourceId());
            param.put("sourceType", attachmentVO.getSourceType());
            param.put("billType", billType);
            param.put("fileId", attachmentVO.getId());
            param.put("fileSize", attachmentVO.getFileSize());
            param.put("fileName", attachmentVO.getFileName());
            param.put("fileOnlinePath", attachmentVO.getOnlinePath());
            param.put("imgServerPath", attachmentVO.getImgServerPath());
            param.put("formatPathStr", attachmentVO.getFileFormatPathStr());
            param.put("fileVersion", attachmentVO.getVersion());
        }
        try {
            String httpRespStr = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(param), headerMap, (Integer)10000, (Integer)10000);
            this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{}\u66f4\u65b0\u5355\u636e\u6587\u6863\u4fe1\u606f\u7ed3\u679c\uff1a{}", new Object[]{url, JSONObject.toJSONString(param), httpRespStr});
            resp.put("id", (Object)attachmentVO.getSourceId().toString());
            resp.put("name", (Object)attachmentVO.getFileName());
            resp.put("size", (Object)attachmentVO.getFileSize());
            resp.put("version", (Object)attachmentVO.getVersion());
            resp.put("download_url", (Object)(this.BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type=" + billType + "&_w_fileid=" + attachmentVO.getSourceId().toString() + "&_w_source_type=template&_w_source_attach_id=" + attachmentVO.getId()));
            return resp;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfurl-{},param-{}\u66f4\u65b0\u5355\u636e\u6587\u6863\u4fe1\u606f\u5f02\u5e38\uff1a", new Object[]{url, JSONObject.toJSONString(param), e});
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u66f4\u65b0\u5931\u8d25\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="commonTask")
    public Future<File> getTemplDetailPdfFileId(TemplDetailExportSettingVO templDetail, Long sourceId, JSONArray billData, String authority, Map<String, Integer> sequence) throws Exception {
        HashMap<String, JSONArray> dataMap = new HashMap<String, JSONArray>();
        dataMap.put(templDetail.getMainAttrName(), null == billData || billData.size() == 0 ? new ArrayList() : billData);
        this.logger.info("\u5c06\u6570\u636e{}\u5199\u5165\u5b50\u8868\uff1a{}", (Object)JSONObject.toJSONString(dataMap), (Object)templDetail.getMainAttrName());
        File dataFile = File.createTempFile(templDetail.getBelongEntityId().toString(), ".xlsx");
        sequence.put(dataFile.getName(), null != templDetail.getDetailSequence() ? templDetail.getDetailSequence() : 0);
        FileOutputStream dataOuts = new FileOutputStream(dataFile);
        XLSTransformer transformer = new XLSTransformer();
        Workbook workbook = null;
        try {
            Response fileResponse = this.attachmentApi.downloadFileById(null != templDetail.getCustomFileId() ? templDetail.getCustomFileId() : templDetail.getSysFileId());
            Response.Body body = fileResponse.body();
            InputStream inputStream = body.asInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            workbook = transformer.transformXLS((InputStream)bufferedInputStream, dataMap);
            Sheet sheet = workbook.getSheetAt(0);
            sheet.setAutobreaks(true);
            WpsCallbackController.autoColumnWidthForChineseChar(sheet, 0, sheet.getRow(0).getLastCellNum());
            workbook.write((OutputStream)dataOuts);
        }
        catch (Exception e) {
            this.logger.error("\u5b50\u8868-\u3010{}\u3011\u6570\u636e\u5199\u5165\u5bfc\u51fa\u6a21\u677f\u5f02\u5e38:", (Throwable)e);
            AsyncResult asyncResult = new AsyncResult(null);
            return asyncResult;
        }
        finally {
            if (null != workbook) {
                workbook.close();
            }
            if (null != dataOuts) {
                dataOuts.flush();
            }
            if (null != dataOuts) {
                ((OutputStream)dataOuts).close();
            }
        }
        return new AsyncResult((Object)dataFile);
    }

    private JSONObject newTemplateVersion(AttachmentVO attachmentVO, String sourceId, String authority, String billType) {
        JSONObject resp = new JSONObject();
        resp.put("oprResult", (Object)true);
        CommonResponse tmplVersionResp = this.templateApi.getTemplateVersionInfo(Long.valueOf(sourceId), null);
        if (!tmplVersionResp.isSuccess()) {
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
        }
        TemplateVersionVO template = (TemplateVersionVO)tmplVersionResp.getData();
        this.logger.info("\u83b7\u53d6\u5230\u5f53\u524d\u6700\u65b0\u6a21\u677f\u7248\u672c\u4fe1\u606f: {}", (Object)JSONObject.toJSONString((Object)template));
        TemplateVersionVO newTmplVersion = this.generateNewTemplateVersion(template, attachmentVO);
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("authority", authority);
            header.put("content-type", "application/json;charset=UTF-8");
            String newTmplVersionRespStr = HttpTookit.postByJson((String)(this.BASE_HOST + "ejc-contractbase-web/api/template/createNewTmplVersion"), (String)JSONObject.toJSONString((Object)newTmplVersion), header, (Integer)10000, (Integer)1000);
            CommonResponse newTmplVersionResp = (CommonResponse)JSONObject.parseObject((String)newTmplVersionRespStr, CommonResponse.class);
            if (!newTmplVersionResp.isSuccess()) {
                this.logger.error("\u8c03\u7528\u6a21\u677f\u670d\u52a1\u66f4\u65b0\u6a21\u677f\u7248\u672c\u4fe1\u606f-{}\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)newTmplVersion), (Object)newTmplVersionResp.getMsg());
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u540c\u6b65\u4fdd\u5b58\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6a21\u677f\u670d\u52a1\u66f4\u65b0\u6a21\u677f\u7248\u672c\u4fe1\u606f-{}\u5f02\u5e38\uff1a", (Object)JSONObject.toJSONString((Object)newTmplVersion), (Object)e);
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6587\u4ef6\u540c\u6b65\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        resp.put("id", (Object)newTmplVersion.getFileId().toString());
        resp.put("name", (Object)newTmplVersion.getFileName());
        resp.put("size", (Object)newTmplVersion.getFileSize());
        resp.put("version", (Object)newTmplVersion.getTemplateVersion());
        resp.put("download_url", (Object)(this.BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type=" + billType + "&_w_fileid=" + sourceId + "&_w_source_type=template&_w_source_attach_id=" + attachmentVO.getId()));
        return resp;
    }

    private JSONObject getReturnMsg(WpsReturnCodeEnum backState, String customMsg) {
        JSONObject resp = new JSONObject();
        resp.put("code", (Object)backState.getCode());
        resp.put("message", (Object)backState.getMessage());
        resp.put("details", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("hint", (Object)(StringUtils.isNotBlank((String)customMsg) ? customMsg : backState.getDetails()));
        resp.put("oprResult", (Object)false);
        return resp;
    }

    @GetMapping(value={"downloadFileByTmpId"})
    public void downloadFileByTmpId(@RequestParam(value="_w_fileid") String wpsFileId, @RequestParam(value="_w_bill_type") String billType, @RequestParam(value="_w_source_attach_id", required=false) String fileId, @RequestParam(value="_w_source_id") String sourceId, @RequestParam(value="_w_refill_data", required=false, defaultValue="false") String reFillData, @RequestParam(value="_ejc_source_type", required=false, defaultValue="template") String sourceType, @RequestParam(value="_w_category_id", required=false) String categoryId, @RequestParam(value="_w_token") String uToken, @RequestParam(value="_w_uid") String userId, HttpServletResponse response) {
        this.logger.info("\u4e0b\u8f7d\u6587\u4ef6\u53c2\u6570\uff1asourceId-{},billType-{},fileId-{},reFillData-{},sourceType-{},-categoryId{},", new Object[]{sourceId, billType, fileId, reFillData, sourceType, categoryId});
        String authority = this.checkOnLine(userId, uToken);
        if (null == authority) {
            throw new BusinessException("\u7528\u6237\u4f1a\u8bdd\u5931\u6548\uff01");
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        Long attachId = null;
        if (StringUtils.isNotBlank((String)fileId)) {
            attachId = Long.valueOf(fileId);
        } else {
            switch (sourceType) {
                case "contractFile": {
                    if ("false".equals(reFillData)) {
                        CommonResponse attachResp = this.attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, null);
                        if (!attachResp.isSuccess()) {
                            this.logger.error("\u6839\u636esourceId-{},billType-{},sourceType-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", new Object[]{sourceId, billType, sourceType, attachResp.getMsg()});
                            throw new BusinessException("\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
                        }
                        if (CollectionUtils.isEmpty((Collection)((Collection)attachResp.getData()))) {
                            this.logger.error("\u6839\u636esourceId-{},billType-{},sourceType-{}\u627e\u4e0d\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f", new Object[]{sourceId, billType, sourceType});
                            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f\uff01");
                        }
                        attachId = ((AttachmentVO)((List)attachResp.getData()).get(0)).getId();
                        break;
                    }
                    this.logger.info("\u6839\u636ecategoryId-{}\u67e5\u627e\u6587\u4ef6\u4fe1\u606f", (Object)categoryId);
                    CommonResponse tmplResp = this.templateApi.getByCategoryId(Long.valueOf(categoryId));
                    if (!tmplResp.isSuccess()) {
                        this.logger.error("\u6839\u636ecategoryId-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", new Object[]{sourceId, billType, sourceType, tmplResp.getMsg()});
                        throw new BusinessException("\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
                    }
                    attachId = ((TemplateVO)tmplResp.getData()).getFileId();
                    break;
                }
                default: {
                    CommonResponse tmplVersionResp = this.templateApi.getTemplateVersionInfo(Long.valueOf(sourceId), null);
                    if (!tmplVersionResp.isSuccess()) {
                        this.logger.error("\u83b7\u53d6templateId-{}\u5bf9\u5e94\u6587\u4ef6\u5931\u8d25\uff01", (Object)sourceId, (Object)tmplVersionResp.getMsg());
                        throw new BusinessException("\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25");
                    }
                    attachId = ((TemplateVersionVO)tmplVersionResp.getData()).getFileId();
                }
            }
        }
        this.logger.info("\u4e0b\u8f7d\u6587\u4ef6fileId-{} ", (Object)attachId);
        InputStream inputStream = null;
        try {
            Response fileResponse = this.attachmentApi.downloadFileById(attachId);
            Response.Body body = fileResponse.body();
            inputStream = body.asInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            response.setHeader("Content-Disposition", ((Collection)fileResponse.headers().get("Content-Disposition")).toString().replace("[", "").replace("]", ""));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            int length = 0;
            byte[] temp = new byte[10240];
            while ((length = bufferedInputStream.read(temp)) != -1) {
                bufferedOutputStream.write(temp, 0, length);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedInputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private TemplateVersionVO generateNewTemplateVersion(TemplateVersionVO tmplVersion, AttachmentVO attachmentVO) {
        TemplateVersionVO newTmplVersion = new TemplateVersionVO();
        newTmplVersion.setFileId(attachmentVO.getId());
        newTmplVersion.setFileName(attachmentVO.getFileName());
        newTmplVersion.setFilePath(attachmentVO.getFilePath());
        newTmplVersion.setFileSize(attachmentVO.getFileSize());
        newTmplVersion.setFileType(this.getFileType(attachmentVO.getFileName()));
        newTmplVersion.setSequence(tmplVersion.getSequence());
        newTmplVersion.setOnlinePath(attachmentVO.getOnlinePath());
        newTmplVersion.setTemplateName(tmplVersion.getTemplateName());
        newTmplVersion.setTemplateVersion(Long.valueOf(tmplVersion.getTemplateVersion() + 1L));
        newTmplVersion.setTenantId(tmplVersion.getTenantId());
        newTmplVersion.setTemplateId(tmplVersion.getTemplateId());
        return newTmplVersion;
    }

    private JSONObject getFile(String sourceId, String sourceType, String billType, String fileId, String categoryId) {
        JSONObject fileInfo = new JSONObject();
        fileInfo.put("oprResult", (Object)true);
        AttachmentVO file = null;
        if (StringUtils.isNotBlank((String)fileId)) {
            CommonResponse attachmentResp = this.attachmentApi.queryDetail(fileId);
            if (!attachmentResp.isSuccess()) {
                this.logger.error("\u6839\u636eId-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)fileId, (Object)attachmentResp.getMsg());
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u6839\u636eId\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            file = (AttachmentVO)attachmentResp.getData();
        } else {
            CommonResponse attachResp = this.attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, null);
            if (!attachResp.isSuccess()) {
                this.logger.error("\u6839\u636esourceId-{},billType-{},sourceType-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", new Object[]{sourceId, billType, sourceType, attachResp.getMsg()});
                return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)attachResp.getData()))) {
                this.logger.info("\u6839\u636esourceId-{},billType-{},sourceType-{}\u627e\u4e0d\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f, \u7ee7\u7eed\u6839\u636ecategoryId-{}\u67e5\u627e\u6587\u4ef6\u4fe1\u606f", new Object[]{sourceId, billType, sourceType, categoryId});
                CommonResponse tmplResp = this.templateApi.getByCategoryId(Long.valueOf(categoryId));
                if (!tmplResp.isSuccess()) {
                    this.logger.error("\u6839\u636ecategoryId-{}\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c{}", new Object[]{sourceId, billType, sourceType, tmplResp.getMsg()});
                    return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff01");
                }
                TemplateVO tmpl = (TemplateVO)tmplResp.getData();
                file = new AttachmentVO();
                file.setId(tmpl.getFileId());
                file.setFileName(tmpl.getFileName());
                file.setFileSize(tmpl.getFileSize());
                file.setVersion(Integer.valueOf(1));
                file.setCreateUserCode(tmpl.getCreateUserCode());
                file.setUpdateUserCode(tmpl.getUpdateUserCode());
            } else {
                file = (AttachmentVO)((List)attachResp.getData()).get(0);
            }
        }
        fileInfo.put("name", (Object)file.getFileName());
        fileInfo.put("version", (Object)file.getVersion());
        fileInfo.put("size", (Object)file.getFileSize());
        fileInfo.put("creator", (Object)file.getCreateUserCode());
        fileInfo.put("modifier", (Object)file.getUpdateUserCode());
        fileInfo.put("download_url", (Object)(this.BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type=" + billType + "&_w_fileid=" + sourceId + "&_w_source_type=" + sourceType + "&_w_source_attach_id=" + file.getId().toString()));
        return fileInfo;
    }

    private JSONObject getTmplFileInfo(Long templateId, Long version, String billType) {
        CommonResponse versionResp = this.templateApi.getTemplateVersionInfo(templateId, version);
        JSONObject fileInfo = new JSONObject();
        if (!versionResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u53c2\u6570: templateId-{}\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)templateId, (Object)versionResp.getMsg());
            return this.getReturnMsg(WpsReturnCodeEnum.CustomMsg, "\u83b7\u53d6\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff01");
        }
        TemplateVersionVO templateVersionVO = (TemplateVersionVO)versionResp.getData();
        fileInfo.put("name", (Object)templateVersionVO.getFileName());
        fileInfo.put("version", (Object)templateVersionVO.getTemplateVersion());
        fileInfo.put("size", (Object)templateVersionVO.getFileSize());
        fileInfo.put("creator", (Object)templateVersionVO.getCreateUserCode());
        fileInfo.put("modifier", (Object)templateVersionVO.getUpdateUserCode());
        fileInfo.put("download_url", (Object)(this.BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type=" + billType + "&_w_fileid=" + templateVersionVO.getFileId() + "&_w_source_type=template&_w_source_attach_id=" + templateVersionVO.getFileId()));
        fileInfo.put("oprResult", (Object)true);
        return fileInfo;
    }

    private String getFileType(String fileName) {
        if (fileName.indexOf(".doc") >= 0) {
            return "w";
        }
        if (fileName.indexOf(".xls") >= 0) {
            return "s";
        }
        if (fileName.indexOf(".ppt") >= 0) {
            return "p";
        }
        return "f";
    }

    private String getUrlParam(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (builder.length() > 0) {
                builder.append('&');
            }
            builder.append(URLEncoder.encode(entry.getKey(), "utf-8")).append('=').append(URLEncoder.encode(entry.getValue(), "utf-8"));
        }
        return builder.toString();
    }

    private String getSignature(Map<String, String> params, String appSecret) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            keys.add(entry.getKey());
        }
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        StringBuilder contents = new StringBuilder("");
        for (String key : keys) {
            if (key == "_w_signature") continue;
            contents.append(key + "=").append(params.get(key));
            System.out.println("key:" + key + ",value:" + params.get(key));
        }
        contents.append("_w_secretkey=").append(appSecret);
        byte[] byArray = this.hmacSha1(appSecret.getBytes(), contents.toString().getBytes());
        String sign = Base64.encodeBase64String((byte[])byArray);
        try {
            sign = URLEncoder.encode(sign, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println(sign);
        return sign;
    }

    public byte[] hmacSha1(byte[] key, byte[] data) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance(signingKey.getAlgorithm());
            mac.init(signingKey);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, MultipartFile file) throws Exception {
        String charset = "UTF-8";
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 30000;
        Integer readTimeout = 30000;
        try {
            HttpResponse res;
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file", file.getInputStream(), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), file.getOriginalFilename());
            for (String key : params.keySet()) {
                builder.addPart(key, (ContentBody)new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key2 = null;
                for (String key2 : headers.keySet()) {
                    post.addHeader(key2, headers.get(key2));
                }
            } else {
                request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
                res = client.execute((HttpUriRequest)post);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)charset);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        try {
            WpsCallbackController.registerPdf_v_21_7();
        }
        catch (Exception e) {
            throw new RuntimeException("Aspose\u6ce8\u518c\u5931\u8d25", e);
        }
        XLSTransformer transformer = new XLSTransformer();
        File f = new File("D:\\SettlePool-export.xlsx");
        FileInputStream is = new FileInputStream(f);
        HashMap billData = new HashMap();
        File pdfFile = new File("D:\\testPdf2.xlsx");
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        for (int i = 0; i < 50; ++i) {
            JSONObject oneData = new JSONObject();
            oneData.put("billCode", (Object)("pdf-b-" + i));
            oneData.put("handleTypeStr", (Object)("\u624b\u52a8\u65b0\u589e-" + i));
            oneData.put("sourceTypeName", (Object)("\u52b3\u52a1\u5206\u5305\u5408\u540c-" + i));
            if (i % 2 == 0) {
                oneData.put("projectName", (Object)("\u6d4b\u8bd5\u9879\u76ee\u6d4b\u8bd5\u52b3\u52a1\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c-" + i));
                oneData.put("contractName", (Object)("\u6d4b\u8bd5\u52b3\u52a1\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c-" + i));
                oneData.put("partyaName", (Object)("\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8-" + i));
            } else {
                oneData.put("projectName", (Object)("\u6d4b\u8bd5\u9879\u76ee\u6d4b\u8bd5\u52b3\u52a1\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c-" + i));
                oneData.put("contractName", (Object)("\u6d4b\u8bd5\u52b3\u52a1\u6d4b\u8bd5\u52b3-" + i));
                oneData.put("partyaName", (Object)("\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8-" + i));
            }
            oneData.put("projectName", (Object)("\u6d4b\u8bd5\u9879\u76ee\u6d4b\u8bd5\u52b3\u52a1\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c-" + i));
            oneData.put("contractName", (Object)("\u6d4b\u8bd5\u52b3\u52a1\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c\u6d4b\u8bd5\u52b3\u52a1\u5206\u5305\u5408\u540c-" + i));
            oneData.put("partyaName", (Object)("\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8-" + i));
            oneData.put("partybName", (Object)("\u6d4b\u8bd5\u4f9b\u6d4b\u8bd5\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4f9b\u5e94\u5546\u5e94\u5546-" + i));
            oneData.put("settleDate", (Object)new Date());
            oneData.put("curTaxMny", (Object)"123,456.00");
            oneData.put("lastTaxMny", (Object)"789,456.00");
            oneData.put("settlePropertyName", (Object)"\u652f\u51fa\u5408\u540c");
            data.add(oneData);
        }
        billData.put("records", data);
        FileOutputStream outs = new FileOutputStream(pdfFile);
        Workbook workbook = transformer.transformXLS((InputStream)is, billData);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);
        Sheet sheet = workbook.getSheetAt(0);
        sheet.setAutobreaks(true);
        WpsCallbackController.autoColumnWidthForChineseChar(sheet, 0, sheet.getRow(0).getLastCellNum());
        workbook.write((OutputStream)outs);
        workbook.close();
        outs.flush();
        ((OutputStream)outs).close();
        File pdfF = new File("D:\\test.pdf");
        File excelFile = new File("D:\\testPdf2.xlsx");
        FileOutputStream outs2 = new FileOutputStream(pdfF);
        FileInputStream fis = new FileInputStream(excelFile);
        com.aspose.cells.Workbook cellBook = new com.aspose.cells.Workbook((InputStream)fis);
        int[] autoDrawSheets = new int[]{1};
        WpsCallbackController.autoDraw(cellBook, autoDrawSheets);
        PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
        pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
        cellBook.save((OutputStream)outs2, (SaveOptions)pdfSaveOptions);
        outs2.flush();
        ((OutputStream)outs2).close();
        ((InputStream)fis).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File byte2file(byte[] bytes, String fileFullPath) {
        if (bytes == null) {
            return null;
        }
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(fileFullPath);
            if (file.exists()) {
                file.mkdirs();
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(bytes);
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void registerPdf_v_21_7() throws Exception {
        Date licenseExpiry = new Date(Long.MAX_VALUE);
        Class<?> l9yClass = Class.forName("com.aspose.pdf.l9y");
        Constructor<?> constructor = l9yClass.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Object l9yInstance = constructor.newInstance(new Object[0]);
        Field lc = l9yClass.getDeclaredField("lc");
        lc.setAccessible(true);
        lc.set(l9yInstance, licenseExpiry);
        Field ly = l9yClass.getDeclaredField("ly");
        ly.setAccessible(true);
        ly.set(l9yInstance, licenseExpiry);
        Field l0if = l9yClass.getDeclaredField("l0if");
        l0if.setAccessible(true);
        Class<?> l9nClass = Class.forName("com.aspose.pdf.l9n");
        Field lfField = l9nClass.getDeclaredField("lf");
        lfField.setAccessible(true);
        Object lf = lfField.get(null);
        l0if.set(l9yInstance, lf);
        Class<?> l9yLfClass = Class.forName("com.aspose.pdf.l9y$lf");
        Field l9y$lf = l9yLfClass.getDeclaredField("lI");
        l9y$lf.setAccessible(true);
        l9y$lf.set(null, l9yInstance);
        Class<?> l19jClass = Class.forName("com.aspose.pdf.l19j");
        Field l19jlI = l19jClass.getDeclaredField("lI");
        l19jlI.setAccessible(true);
        l19jlI.set(null, 128);
        Field l19jLf = l19jClass.getDeclaredField("lf");
        l19jLf.setAccessible(true);
        l19jLf.set(null, false);
    }

    public static void autoDraw(com.aspose.cells.Workbook wb, int[] page) {
        if (null != page && page.length > 0) {
            for (int i = 0; i < page.length; ++i) {
                wb.getWorksheets().get(i).getHorizontalPageBreaks().clear();
                wb.getWorksheets().get(i).getVerticalPageBreaks().clear();
            }
        }
    }

    public static float getExcelCellAutoHeight(String str, float fontCountInline) {
        float defaultRowHeight = 12.0f;
        float defaultCount = 0.0f;
        for (int i = 0; i < str.length(); ++i) {
            float ff = WpsCallbackController.getregex(str.substring(i, i + 1));
            defaultCount += ff;
        }
        return (float)((int)(defaultCount / fontCountInline) + 1) * defaultRowHeight;
    }

    public static float getregex(String charStr) {
        if (charStr == " ") {
            return 0.5f;
        }
        if (Pattern.compile("^[A-Za-z0-9]+$").matcher(charStr).matches()) {
            return 0.5f;
        }
        if (Pattern.compile("[\u4e00-\u9fa5]+$").matcher(charStr).matches()) {
            return 1.0f;
        }
        if (Pattern.compile("[^x00-xff]").matcher(charStr).matches()) {
            return 1.0f;
        }
        return 0.5f;
    }

    public static void autoColumnWidthForChineseChar(Sheet sheet, int startColumnNum, int size) {
        int oneLineHeight = 220;
        int twentyWordsColumnWidth = 5120;
        int fortyFiveWordsColumnWidth = 8960;
        int sixtyWordsColumnWidth = 12800;
        int actualColWith = 5120;
        Integer mapxRowHeight = 1;
        for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
            if (rowNum < 2 || sheet.getRow(rowNum) == null) continue;
            Row currentRow = sheet.getRow(rowNum);
            for (int columnNum = 0; columnNum < size; ++columnNum) {
                int columnWidth;
                sheet.autoSizeColumn(columnNum);
                int newWidth = columnWidth = sheet.getColumnWidth(columnNum);
                boolean newHeight = false;
                actualColWith = 5120;
                if (currentRow.getCell(columnNum) != null) {
                    Cell currentCell = currentRow.getCell(columnNum);
                    String value = WpsCallbackController.getCellContentAsString(currentCell);
                    System.out.println("\u5185\u5bb9\uff1a" + value);
                    int count = WpsCallbackController.chineseCharCountOf(value);
                    System.out.println("\u4e2d\u6587\u6570\u91cf\uff1a" + count);
                    newWidth = value.length() * 256 + count * 256 * 2;
                    System.out.println("\u5217\u5bbd\uff1a" + newWidth);
                    System.out.println("\u7b2c" + rowNum + "\u884c \u7b2c" + columnNum + "\u5217 \u5bbd\u5ea6\uff1a" + newWidth + ", \u539f\u672c\u5bbd\u5ea6\uff1a" + columnWidth);
                }
                if (newWidth > columnWidth) {
                    if (newWidth > actualColWith && Math.ceil(newWidth / actualColWith) > (double)mapxRowHeight.intValue()) {
                        if (Math.ceil(newWidth / actualColWith) > 30.0) {
                            actualColWith = Math.ceil(newWidth / 8960) <= 30.0 ? 8960 : 12800;
                        }
                        mapxRowHeight = Double.valueOf(Math.ceil(newWidth / actualColWith)).intValue();
                    }
                    sheet.setColumnWidth(columnNum, newWidth > actualColWith ? actualColWith + 30 : newWidth + 30);
                }
                currentRow.setHeight(Integer.valueOf(220 * mapxRowHeight).shortValue());
            }
            System.out.println("\u7b2c" + rowNum + "\u884c \u6700\u5927\u884c\u9ad8\uff1a" + mapxRowHeight);
        }
    }

    private static String getCellContentAsString(Cell cell) {
        if (null == cell) {
            return "";
        }
        String result = "";
        switch (cell.getCellType()) {
            case 0: {
                String s = String.valueOf(cell.getNumericCellValue());
                if (s != null && s.endsWith(".0")) {
                    s = s.substring(0, s.length() - 2);
                }
                result = s;
                break;
            }
            case 1: {
                result = null != cell.getStringCellValue() ? String.valueOf(cell.getStringCellValue()).trim() : "";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                result = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                break;
            }
        }
        return result;
    }

    private static int chineseCharCountOf(String input) {
        int count = 0;
        if (null != input) {
            String regEx = "[\\u4e00-\\u9fa5]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(input);
            int len = m.groupCount();
            while (m.find()) {
                for (int i = 0; i <= len; ++i) {
                    ++count;
                }
            }
        }
        return count;
    }
}

