package com.ejianc.business.wpsofficeedit.service.impl;

import com.ejianc.business.wpsofficeedit.bean.BillEditInfoEntity;
import com.ejianc.business.wpsofficeedit.mapper.BillEditInfoMapper;
import com.ejianc.business.wpsofficeedit.service.IBillEditInfoService;
import com.ejianc.business.wpsofficeedit.vo.BillEditInfoVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 单据在线编辑服务实现
 *
 * @author CJ
 * @Description:
 * @date 2022/6/1 10:22
 */
@Service(value = "billEditInfoService")
public class BillEditInfoServiceImpl extends BaseServiceImpl<BillEditInfoMapper, BillEditInfoEntity> implements IBillEditInfoService {

    @Override
    public BillEditInfoVO saveBillEditInfo(BillEditInfoVO billEditInfoVO) {
        BillEditInfoEntity saveEntity = null;

        if(null != billEditInfoVO.getId()) {
            saveEntity = BeanMapper.map(billEditInfoVO, BillEditInfoEntity.class);
        } else {
            saveEntity = super.selectById(billEditInfoVO.getId());
            saveEntity.setqRCodeBase64(billEditInfoVO.getqRCodeBase64());
        }

        super.saveOrUpdate(saveEntity, false);

        return BeanMapper.map(saveEntity, BillEditInfoVO.class);
    }
}
