package com.ejianc.business.wpsofficeedit.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.wpsofficeedit.bean.BillEditInfoEntity;
import com.ejianc.business.wpsofficeedit.mapper.BillEditInfoMapper;
import com.ejianc.business.wpsofficeedit.service.IBillEditInfoService;
import com.ejianc.business.wpsofficeedit.vo.BillEditInfoVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 单据在线编辑服务实现
 *
 * @author CJ
 * @Description:
 * @date 2022/6/1 10:22
 */
@Service(value = "billEditInfoService")
public class BillEditInfoServiceImpl extends BaseServiceImpl<BillEditInfoMapper, BillEditInfoEntity> implements IBillEditInfoService {

    @Override
    public BillEditInfoVO saveBillEditInfo(BillEditInfoVO billEditInfoVO) {
        BillEditInfoEntity saveEntity = null;

        if(null != billEditInfoVO.getId()) {
            saveEntity = BeanMapper.map(billEditInfoVO, BillEditInfoEntity.class);
        } else {
            saveEntity = super.selectById(billEditInfoVO.getId());
            saveEntity.setqRCodeBase64(billEditInfoVO.getqRCodeBase64());
        }

        super.saveOrUpdate(saveEntity, false);

        return BeanMapper.map(saveEntity, BillEditInfoVO.class);
    }

    @Override
    public BillEditInfoEntity getByFileId(Long fileId) {
        QueryWrapper<BillEditInfoEntity> query = new QueryWrapper<>();
        query.eq("file_id", fileId);

        return super.getOne(query);
    }

    @Override
    public BillEditInfoEntity generateNewBillEditInfo(String sourceId, String billType, String sourceType, Long categoryId,
                                                      String wpsFileId, String fileName, String filePath, Long fileSize, Boolean replaceFile, Long templateId) {
        BillEditInfoEntity newEntity = new BillEditInfoEntity();
        newEntity.setId(Long.valueOf(sourceId));
        newEntity.setSourceId(Long.valueOf(sourceId));
        newEntity.setBillType(billType);
        newEntity.setBillEditType(sourceType);
        newEntity.setCategoryId(categoryId);
        newEntity.setFileId(Long.valueOf(wpsFileId));
        newEntity.setFileName(fileName);
        newEntity.setFilePath(filePath);
        newEntity.setFileSize(fileSize);
        newEntity.setFileReplace(replaceFile);
        newEntity.setTemplateId(templateId);
        super.saveOrUpdate(newEntity);
        return newEntity;
    }

    @Override
    public BillEditInfoEntity updateBillEditInfo(String sourceId, String billType, String sourceType, Long categoryId, String fileId,
                                                 String fileName, String filePath, Long fileSize, Boolean replaceFile, Long templateId) {
        BillEditInfoEntity entity = super.selectById(sourceId);
        if(null == entity.getSourceId()) {
            entity.setSourceId(Long.valueOf(sourceId));
        }
        if(null != billType) {
            entity.setBillType(billType);
        }
        if(null != sourceType) {
            entity.setBillEditType(sourceType);
        }
        if(null != categoryId) {
            entity.setCategoryId(categoryId);
        }
        if(null != fileId) {
            entity.setFileId(Long.valueOf(fileId));
        }
        if(null != fileName) {
            entity.setFileName(fileName);
        }
        if(null != filePath) {
            entity.setFilePath(filePath);
        }
        if(null != fileSize) {
            entity.setFileSize(fileSize);
        }
        if(null != replaceFile) {
            entity.setFileReplace(replaceFile);
        }
        if(null != templateId) {
            entity.setTemplateId(templateId);
        }
        super.saveOrUpdate(entity);
        return entity;
    }
}
