package com.ejianc.business.wpsofficeedit.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aspose.cells.*;
import com.ejianc.business.contractbase.api.ITemplateApi;
import com.ejianc.business.contractbase.vo.TemplateVO;
import com.ejianc.business.contractbase.vo.TemplateVersionVO;
import com.ejianc.business.contractbase.vo.tempDetail.TemplDetailExportSettingVO;
import com.ejianc.business.wpsofficeedit.bean.BillEditInfoEntity;
import com.ejianc.business.wpsofficeedit.constants.WpsReturnCodeEnum;
import com.ejianc.business.wpsofficeedit.service.IBillEditInfoService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DESUtils;
import com.ejianc.framework.core.util.HttpTookit;
import feign.Response;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static org.apache.tomcat.util.codec.binary.Base64.encodeBase64String;

/**
 * wps回调服务控制器
 *
 * @author CJ
 * @Description: wps回调服务控制器
 * @date 2021/11/10 15:35
 */
@RestController
@RequestMapping("/wpscbk/")
public class WpsCallbackController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private ITemplateApi templateApi;

    @Autowired

    @Value("${wps.domain}")
    private String wpsDomain;

    @Value("${wps.appId}")
    private String wpsAppId;

    @Value("${wps.appKey}")
    private String wpsAppKey;

    @Value("${fileUrl}")
    private String fileUrl;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private CacheManager cacheManager;

    private final String SESSION_PREFIX = "ICOP_SESSION_USER:";
    private final String WPS_ONLINE_USER = "WPS_ONLINE_USER:";
    private final int timeout = 60 * 60;

    @Autowired
    private IBillEditInfoService billEditInfoService;

    /**
     * 模板单据类型
     */
    private final String templateBillTypeCode = "BT211109000000003";

    /**
     * 模板文件业务类型
     */
    private final String templateFileSourceType = "template";

    @GetMapping(value = "getUserToken")
    public CommonResponse<String> getUserToken() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String cacheKey = DESUtils.decrypt(InvocationInfoProxy.getUserid() + "::wpsUserToken::"+sdf.format(new Date()));
        cacheManager.setex(cacheKey, InvocationInfoProxy.getToken(), 60 * 10);

        return CommonResponse.success("获取用户wpsToken成功", cacheKey);
    }


    /**
     * 拼接wps初始化模板文件访问url信息
     *
     * @param categoryId 模板分类Id
     * @param templateId 模板Id
     * @param permission 用户操作权限
     * @param billType 单据类型
     * @param fileId 实际附件Id
     * @param sourceId 附件sourceId
     * @param sourceType 业务类型
     * @return
     * @throws UnsupportedEncodingException
     */
    @GetMapping(value = "getWpsUrl")
    public CommonResponse<JSONObject> getWpsUrl(@RequestParam(value = "categoryId", required = false) Long categoryId,
                                                @RequestParam(value = "templateId", required = false) Long templateId,
                                                @RequestParam(value = "permission") String permission,
                                                @RequestParam(value = "billType") String billType,
                                                @RequestParam(value = "fileId", required = false) String fileId,
                                                @RequestParam(value = "sourceId", required = false) String sourceId,
                                                @RequestParam(value = "reFillData", required = false, defaultValue = "false") String reFillData,
                                                @RequestParam(value = "sourceType", required = false, defaultValue = "template") String sourceType) throws UnsupportedEncodingException {
        TemplateVO template = null;
        JSONObject resp = new JSONObject();
        String wpsFileId = null;
        String replaceFile = "false";
        if(null == categoryId && null == templateId && "template".equals(sourceType)) {
            return CommonResponse.error("获取模板文件访问url失败，模板参数categoryId/templateId为空");
        }
        String authority = checkOnLine(InvocationInfoProxy.getUserid().toString(), InvocationInfoProxy.getToken());
        InvocationInfoProxy.setExtendAttribute("authority", authority);
        CommonResponse<TemplateVO> tempResp = null;
        if(null == templateId) {
            tempResp = templateApi.getByCategoryId(categoryId);
            if(StringUtils.isBlank(sourceId)) {
                return CommonResponse.error("获取模板文件访问url失败，参数sourceId为空");
            }
            if(!tempResp.isSuccess()) {
                logger.error("根据参数: templateId-{}, categoryId-{}[templateId优先级高于categoryId]获取对应模板信息失败，原因：{}",
                        templateId, categoryId, tempResp.getMsg());
                return CommonResponse.error("未获取到对应模板信息！");
            }
        } else {
            //传递了合同模板Id
            tempResp = templateApi.queryDetailById(templateId);
            if(StringUtils.isBlank(sourceId)) {
                sourceId = templateId.toString();
            }
        }

        template = tempResp.getData();
        if(null == categoryId) {
            categoryId = template.getCategoryId();
        }
        if("template".equals(sourceType)) {
            wpsFileId = template.getFileId().toString();
        } else {
            replaceFile = "true";
//            if(null != fileId) {
//                wpsFileId = fileId;
//            } else {
                //现根据单据id 查询单据是否已存在对应编辑文件
               CommonResponse<List<AttachmentVO>> fileQueryResp = attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, "desc");
               if(!fileQueryResp.isSuccess()) {
                   logger.error("获取模板文件访问url失败, 根据sourceId-{},sourceType-{},billType-{}查询对应文件信息失败: {}",sourceId, billType, sourceType, fileQueryResp.getMsg());
                   return CommonResponse.error("获取模板文件访问url失败, 根据模板文件生成新的合同文件失败！");
               }
               if(CollectionUtils.isNotEmpty(fileQueryResp.getData())) {
                   wpsFileId = fileQueryResp.getData().get(0).getId().toString();
               } else {
                    //根据从合同模板生成新的合同文件
                   CommonResponse<AttachmentVO> fileCopyResp = attachmentApi.copyFile(template.getFileId().toString(),
                           sourceId, billType, sourceType, true);

                   if(!fileCopyResp.isSuccess()) {
                       logger.error("获取模板文件访问url失败, 根据模板文件生成新的合同文件失败: {}", fileCopyResp.getMsg());
                       return CommonResponse.error("获取模板文件访问url失败, 根据模板文件生成新的合同文件失败！");
                   }
                   wpsFileId = fileCopyResp.getData().getId().toString();
               }
//            }

            BillEditInfoEntity billEdit = billEditInfoService.selectById(sourceId);
            resp.put("curQRBase64", null != billEdit ? billEdit.getqRCodeBase64() : null);
        }

        Long tmplId = template.getId();
        BillEditInfoEntity billEdit = billEditInfoService.selectById(tmplId);
        resp.put("templQRBase64", null != billEdit ? billEdit.getqRCodeBase64() : null);

        if("template".equals(sourceType)) {
            resp.put("curQRBase64", null != billEdit ? billEdit.getqRCodeBase64() : null);
        }

        //1、根据合同分类Id查询对应的启用模板信息,获取到当前最新版本的id信息
        String url = wpsDomain + "/office/" + getFileType(template.getFileName()) + "/" + wpsFileId + "?" ;

        Map paramMap= new HashMap<String, String>();
        paramMap.put("_w_appid", wpsAppId);
        paramMap.put("_w_fileid", wpsFileId);
        paramMap.put("_w_permission", permission);
        paramMap.put("_w_bill_type", billType);
        paramMap.put("_w_category_id", null != categoryId ? categoryId.toString() : null);
        paramMap.put("_w_token", InvocationInfoProxy.getToken());
        paramMap.put("_w_uid", InvocationInfoProxy.getUserid().toString());
        paramMap.put("_w_source_type", sourceType);
        paramMap.put("_w_refill_data", reFillData);
        paramMap.put("_w_source_id", sourceId);
        paramMap.put("_w_replace", replaceFile);
        paramMap.put("_w_template_id", tmplId.toString());
        paramMap.put("_w_source_attach_id", wpsFileId);
        String signature = getSignature(paramMap, wpsAppKey);
        url += getUrlParam(paramMap) + "&_w_signature=" + signature;

        resp.put("wpsUrl", url);
        resp.put("token", "1");
        resp.put("metadata", template.getMetadata());
        resp.put("templateId", tmplId);
        resp.put("templateInfo", template);
        resp.put("billId", "template".equals(sourceType) ? tmplId : sourceId);

        return CommonResponse.success(resp);
    }


    /**
     * 获取当前文档所有历史版本的文件信息
     *
     * @param sourceId 附件绑定业务单据Id
     * @param uToken 用户会话token
     * @param userId 当前用户Id
     * @param billType 单据类型
     * @param sourceType 业务类型
     * @param fileId 实际附件Id
     * @param categoryId 模板分类Id
     * @param permission 操作权限，read-可读，write-可编辑
     * @param previewPages 浏览页数限制,操作权限为read时生效，默认值为0，不限制预览页数。previewPages >= 1 时，限制生效，限制的页数为 previewpages 字段的值
     * @return
     */
    @PostMapping("/v1/3rd/file/history")
    public Object getFileHistory(@RequestParam(value = "_w_fileid") String wpsFileId,
                                 @RequestParam(value = "_w_token") String uToken,
                                 @RequestParam(value = "_w_uid") String userId,
                                 @RequestParam(value = "_w_bill_type") String billType,
                                 @RequestParam(value = "_w_template_id") String templateId,
                                 @RequestParam(value = "_w_source_id") String sourceId,
                                 @RequestParam(value = "_w_source_type", required = false, defaultValue = "template") String sourceType,
                                 @RequestParam(value = "_w_source_attach_id", required = false) String fileId,
                                 @RequestParam(value = "_w_category_id", required = false) String categoryId,
                                 @RequestParam(value = "_w_permission", required = false, defaultValue = "read") String permission,
                                 @RequestParam(value = "_w_previewPages", required = false, defaultValue = "0") int previewPages,
                                 @RequestBody JSONObject pageParam) {
        JSONObject resp = new JSONObject();

        String authority = checkOnLine(userId, uToken);
        if(null == authority) {
            return getReturnMsg(WpsReturnCodeEnum.SessionExpired, "用户会话信息失效！");
        }
        InvocationInfoProxy.setExtendAttribute("authority", authority);
        List<JSONObject> fileHistList = new ArrayList<>();

        switch (sourceType) {
            case "contractFile":
                //若为合同文件，则只返回最新的附件信息,查询业务单据的附件信息
                CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, null);
                if(!attachResp.isSuccess()) {
                    logger.error("根据templateId-{}, start-{}, size-{}查询模板版本列表失败，{}",
                            sourceId,
                            pageParam.getInteger("offset"),
                            pageParam.getInteger("count"), attachResp.getMsg());
                    return getReturnMsg(WpsReturnCodeEnum.ServerError, null);
                }
                List<AttachmentVO> files = attachResp.getData();
                if(CollectionUtils.isNotEmpty(files)) {
                    AttachmentVO attachmentVO = files.get(0);
                    JSONObject tmp = new JSONObject();
                    JSONObject creator = new JSONObject();
                    tmp.put("id", sourceId);
                    tmp.put("name", attachmentVO.getFileName());
                    tmp.put("size", attachmentVO.getFileSize());
                    tmp.put("version", attachmentVO.getVersion());
                    tmp.put("download_url", BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type="+billType
                            +"&_w_source_id="+sourceId+"&_w_template_id="+templateId+"&_w_fileid="+sourceId+"&_w_source_type=template&_w_source_attach_id="+attachmentVO.getId());
                    tmp.put("create_time", attachmentVO.getCreateTime().getTime());
                    if(null != attachmentVO.getUpdateTime()) {
                        tmp.put("modify_time", attachmentVO.getUpdateTime().getTime());
                    }
                    creator.put("id", attachmentVO.getCreateUserCode());
                    creator.put("name", attachmentVO.getCreateUserName());
                    creator.put("avatar_url", "");
                    tmp.put("creator", creator);
                    fileHistList.add(tmp);
                }
                break;
            default:
                CommonResponse<List<TemplateVersionVO>> listResp = templateApi.getHisListByTemplateId(sourceId,
                        pageParam.getInteger("offset"),
                        pageParam.getInteger("count"));
                if(!listResp.isSuccess()) {
                    logger.error("根据templateId-{}, start-{}, size-{}查询模板版本列表失败，{}",
                            sourceId,
                            pageParam.getInteger("offset"),
                            pageParam.getInteger("count"), listResp.getMsg());
                    return getReturnMsg(WpsReturnCodeEnum.ServerError, null);
                }
                listResp.getData().forEach(item -> {
                    JSONObject tmp = new JSONObject();
                    JSONObject creator = new JSONObject();
                    tmp.put("id", item.getFileId().toString());
                    tmp.put("name", item.getFileName());
                    tmp.put("size", item.getFileSize());
                    tmp.put("version", item.getTemplateVersion());
                    tmp.put("download_url", BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type="+billType
                            +"&_w_source_id="+sourceId+"&_w_template_id="+templateId+"&_w_fileid="+item.getFileId().toString()+"&_w_source_type=template&_w_source_attach_id="+item.getFileId());
                    tmp.put("create_time", item.getCreateTime().getTime());
                    if(null != item.getUpdateTime()) {
                        tmp.put("modify_time", item.getUpdateTime().getTime());
                    }
                    creator.put("id", item.getCreateUserCode());
                    creator.put("name", item.getCreateUserName());
                    creator.put("avatar_url", "");
                    tmp.put("creator", creator);
                    fileHistList.add(tmp);
                });
        }

        resp.put("histories", fileHistList);

        return resp.toString();
    }

    /**
     * 根据文件Id获取文件元数据，包括当前文件信息和当前用户信息
     *
     * @param sourceId 附件绑定业务单据Id
     * @param uToken 用户会话token
     * @param userId 当前用户Id
     * @param billType 单据类型
     * @param sourceType 业务类型
     * @param fileId 实际附件Id
     * @param categoryId 模板分类Id
     * @param permission 操作权限，read-可读，write-可编辑
     * @param previewPages 浏览页数限制,操作权限为read时生效，默认值为0，不限制预览页数。previewPages >= 1 时，限制生效，限制的页数为 previewpages 字段的值
     * @return
     */
    @GetMapping(value = "/v1/3rd/file/info", produces = { "application/json;charset=UTF-8" })
    public Object getFileInfo(@RequestParam(value = "_w_fileid") String wpsFileId,
                              @RequestParam(value = "_w_token") String uToken,
                              @RequestParam(value = "_w_uid") String userId,
                              @RequestParam(value = "_w_bill_type") String billType,
                              @RequestParam(value = "_w_template_id") String templateId,
                              @RequestParam(value = "_w_source_id") String sourceId,
                              @RequestParam(value = "_w_source_type", required = false, defaultValue = "template") String sourceType,
                              @RequestParam(value = "_w_source_attach_id", required = false) String fileId,
                              @RequestParam(value = "_w_category_id", required = false) String categoryId,
                              @RequestParam(value = "_w_permission", required = false, defaultValue = "read") String permission,
                              @RequestParam(value = "_w_previewPages", required = false, defaultValue = "0") int previewPages,
                              @RequestParam(value = "_w_replace",required = false, defaultValue = "false") String replace) throws Exception {
        return fileVersionInfo(null, wpsFileId, uToken, userId, billType, templateId, sourceId, sourceType, fileId, categoryId, permission, previewPages, replace);
    }

    /**
     * 根据指定文件Id
     *
     * @param version 版本号
     * @param sourceId 附件绑定业务单据Id
     * @param uToken 用户会话token
     * @param userId 当前用户Id
     * @param billType 单据类型
     * @param sourceType 业务类型
     * @param fileId 实际附件Id
     * @param categoryId 模板分类Id
     * @param permission 操作权限，read-可读，write-可编辑
     * @param previewPages 浏览页数限制
     * @return
     */
    @GetMapping(value = "/v1/3rd/file/version/{version}", produces = { "application/json;charset=UTF-8" })
    public Object fileVersionInfo(@PathVariable("version") Long version,
                                  @RequestParam("_w_fileid") String wpsFileId,
                                  @RequestParam(value = "_w_token") String uToken,
                                  @RequestParam(value = "_w_uid") String userId,
                                  @RequestParam(value = "_w_bill_type") String billType,
                                  @RequestParam(value = "_w_template_id") String templateId,
                                  @RequestParam(value = "_w_source_id") String sourceId,
                                  @RequestParam(value = "_w_source_type", required = false, defaultValue = "template") String sourceType,
                                  @RequestParam(value = "_w_source_attach_id", required = false) String fileId,
                                  @RequestParam(value = "_w_category_id", required = false) String categoryId,
                                  @RequestParam(value = "_w_permission", required = false, defaultValue = "read") String permission,
                                  @RequestParam(value = "_w_previewPages", required = false, defaultValue = "0") int previewPages,
                                  @RequestParam(value = "_w_replace",required = false, defaultValue = "false") String replace) throws Exception {

        String authority = checkOnLine(userId, uToken);
        if(null == authority) {
            return getReturnMsg(WpsReturnCodeEnum.SessionExpired, "用户会话信息失效！");
        }
        InvocationInfoProxy.setExtendAttribute("authority", authority);
        JSONObject resp = new JSONObject();
        //当前用户信息
        JSONObject userInfo = getCurUser(userId, uToken);
        //用户读写权限
        userInfo.put("permission", permission);
        //文件信息
        JSONObject fileInfo = null;

        switch (sourceType) {
            case "contractFile":
                fileInfo = getFile(sourceId, sourceType, billType, fileId, categoryId);
                break;
            default:
                fileInfo = getTmplFileInfo(Long.valueOf(sourceId), version, billType);
        }

        if(!Boolean.valueOf(fileInfo.get("oprResult").toString())) {
            //获取文件信息失败
            fileInfo.remove("oprResult");
            return fileInfo;
        }
        fileInfo.put("download_url", fileInfo.get("download_url").toString()+"&_w_source_id="+sourceId+"&_w_template_id="+templateId+"&_w_uid="+userId+"&_w_token="+uToken+"&_w_replace="+replace);
        fileInfo.remove("oprResult");

        //文件Id,字符串长度小于40，和 URL 中的fileid必须一致
        fileInfo.put("id", wpsFileId);
        resp.put("file", fileInfo);
        resp.put("user", userInfo);

        logger.info("fileVersionInfo: {}", JSONObject.toJSONString(resp));
        return resp.toString();
    }

    public JSONObject getCurUser(String userId, String uToken) {
        String userContextStr = sessionManager.getSessionCacheAttribute(SESSION_PREFIX + userId, uToken);
        UserContext userContext = JSONObject.parseObject(userContextStr, UserContext.class);
        JSONObject resp = new JSONObject();
        //用户id
        resp.put("id", userContext.getUserId().toString());
        //用户名称
        resp.put("name", userContext.getUserName());
        //用户头像
        resp.put("avatar_url", userContext.getUserAvator());
        return resp;
    }

    @RequestMapping(value = "/v1/3rd/user/info", method = RequestMethod.POST)
    @ResponseBody
    public Object onLineUsersInfo(@RequestBody String userIds,
                                  @RequestParam("_w_fileid") String wpsFileId,
                                  @RequestParam(value = "_w_token") String uToken,
                                  @RequestParam(value = "_w_uid") String userId,
                                  @RequestParam(value = "_w_bill_type") String billType,
                                  @RequestParam(value = "_w_source_id") String sourceId,
                                  @RequestParam(value = "_w_source_type", required = false, defaultValue = "template") String sourceType,
                                  @RequestParam(value = "_w_source_attach_id", required = false) String fileId) {
        JSONObject resp = getReturnMsg(WpsReturnCodeEnum.Success, null);
        JSONArray users = new JSONArray();
        if(StringUtils.isNotBlank(userIds)) {
            JSONArray jsonArray = JSONObject.parseObject(userIds).getJSONArray("ids");

            if(null != jsonArray && jsonArray.size() > 0) {
                String authority = checkOnLine(userId, uToken);
                InvocationInfoProxy.setExtendAttribute("authority", authority);
                CommonResponse<List<UserVO>> userResp = userApi.queryListByIds(jsonArray.toArray(new String[jsonArray.size()]));
                if(!userResp.isSuccess()) {
                    logger.error("根据用户Id-{}查询用户信息失败, msg-{}", userIds, userResp.getMsg());
                    users.add(getCurUser(userId, uToken));
                } else {
                    userResp.getData().stream().forEach(user -> {
                        JSONObject userInfo = new JSONObject();
                        //用户id
                        userInfo.put("id", user.getId().toString());
                        //用户名称
                        userInfo.put("name", user.getUserName());
                        //用户头像
                        userInfo.put("avatar_url", StringUtils.isNotBlank(user.getAvator()) ? user.getAvator() : "");
                        users.add(userInfo);
                    });
                }
            } else {
                users.add(getCurUser(userId, uToken));
            }
        } else {
            // 返回当前用户
            users.add(getCurUser(userId, uToken));
        }

        resp.put("users", users);
        return resp.toString();
    }


    /**
     * 此文件目前有哪些人正在协作
     *
     * @param userIds 当前协作用户Id
     * @param sourceId 附件sourceId
     * @param uToken 当前用户Token
     * @param userId 当前用户Id
     * @param billType 单据类型
     * @param sourceType 业务类型
     * @param fileId 文件Id
     * @return
     */
    @RequestMapping(value="/v1/3rd/file/online", method = RequestMethod.POST)
    @ResponseBody
    public Object online(@RequestBody String userIds,
                         @RequestParam("_w_fileid") String wpsFileId,
                         @RequestParam(value = "_w_token") String uToken,
                         @RequestParam(value = "_w_uid") String userId,
                         @RequestParam(value = "_w_bill_type") String billType,
                         @RequestParam(value = "_w_source_id") String sourceId,
                         @RequestParam(value = "_w_source_type", required = false, defaultValue = "template") String sourceType,
                         @RequestParam(value = "_w_source_attach_id", required = false) String fileId) {

        logger.info("附件wpsFileId-{},sourceId-{},billType-{},sourceType-{}接收到协作用户信息userIds-{},uid-{},uToken-{}",
                wpsFileId, sourceId, billType, sourceType, userIds, userId, uToken);

        String cacheKey = WPS_ONLINE_USER + wpsFileId;
        if(StringUtils.isNotBlank(userIds)) {
            JSONArray jsonArray = JSONObject.parseObject(userIds).getJSONArray("ids");
            if(null != jsonArray && jsonArray.size() > 0) {
                cacheManager.setex(cacheKey, JSONObject.toJSONString(jsonArray), timeout);
            } else {
                cacheManager.removeCache(cacheKey);
            }
        } else {
            cacheManager.removeCache(cacheKey);
        }

        return getReturnMsg(WpsReturnCodeEnum.Success, null).toString();
    }

    private String checkOnLine(String userId, String token) {
        logger.info("wpscbk check user session online: userId-{}, token-{}", userId, token);
        boolean isOnline = sessionManager.validateOnlineSession(userId, token);
        if(isOnline) {
           return getAuthority(userId, token);
        }
        logger.info("wpscbk check user session invalid: userId-{}, token-{}", userId, token);
        return  null;
    }

    private String getAuthority(String userId, String token) {
        try {
            String sid = SESSION_PREFIX + userId;
            String userContextStr = sessionManager.getSessionCacheAttribute(sid, token);
            if(StringUtils.isNotBlank(userContextStr)) {
                UserContext userContext = JSONObject.parseObject(userContextStr, UserContext.class);

                logger.debug("wpscbk check user session online: userId-{}, token-{}, userContext-{}", userId, token, JSONObject.toJSONString(userContext));
                return "userType="+userContext.getUserType() +
                        ";userCode="+URLEncoder.encode(userContext.getUserCode(), "UTF-8") +
                        ";userName="+URLEncoder.encode(userContext.getUserName(), "UTF-8") +
                        ";orgId="+userContext.getOrgId() +
                        ";orgName="+URLEncoder.encode(userContext.getOrgName(),"UTF-8") +
                        ";tenantid="+userContext.getTenantid() +
                        ";token="+userContext.getToken() +
                        ";u_logints="+userContext.getU_logints() +
                        ";u_usercode="+userContext.getU_usercode() +
                        ";u_locale="+userContext.getU_locale() +
                        ";userId="+userId;
            }
        } catch (Exception e) {
            logger.info("wpscbk check user session error: userId-{}, token-{}", userId, token, e);
            return null;
        }
        return null;
    }

    /**
     * 模板文件版本保存
     *
     * @param file 待保存的模板文件
     * @param sourceId 附件绑定业务单据Id
     * @param sourceType 附件业务类型
     * @param billType 附件对应单据类型
     * @param uToken 当前用户会话token
     * @param userId 当前用户ID
     * @param fileId 文件Id
     * @param originalFileNameStr 附件原始名称
     * @param replace 保存时是否覆盖原文件
     * @return
     */
    @PostMapping(value = "v1/3rd/file/save", produces = { "application/json;charset=UTF-8" })
    public Object saveFile(@RequestParam("file") MultipartFile file,
                                         @RequestParam("_w_fileid") String wpsFileId,
                                         @RequestParam(value = "_w_source_type", required = false, defaultValue = "template") String sourceType,
                                         @RequestParam(value = "_w_bill_type") String billType,
                                         @RequestParam(value = "_w_token") String uToken,
                                         @RequestParam(value = "_w_uid") String userId,
                                         @RequestParam(value = "_w_source_id") String sourceId,
                                         @RequestParam(value = "_w_template_id") String templateId,
                                         @RequestParam(value = "_w_category_id", required = false) String categoryId,
                                         @RequestParam(value = "_w_source_attach_id", required = false) String fileId,
                                         @RequestParam(value = "_w_original_file_name", required = false) String originalFileNameStr,
                                         @RequestParam(value = "_w_refill_data", required = false, defaultValue = "false") String reFillData,
                                         @RequestParam(value = "_w_replace",required = false, defaultValue = "false") String replace) {
        logger.info("接收到模板保存请求：sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}",
                sourceId, sourceType, billType, originalFileNameStr, replace);
        JSONObject resp = new JSONObject();
        JSONObject fileInfo = null;

        String authority = checkOnLine(userId, uToken);
        if(null != authority) {
            InvocationInfoProxy.setExtendAttribute("authority", authority);

            Map<String,String> params = new HashMap<>();
            params.put("sourceType", sourceType);
            params.put("sourceId", sourceId);
            params.put("billType", billType);
            params.put("originalFileNameStr", StringUtils.isNotBlank(originalFileNameStr) ? originalFileNameStr : file.getOriginalFilename());
            params.put("replace", replace);
            Map<String,String> headers = new HashMap<>();
            headers.put("authority", authority);
            AttachmentVO attachmentVO = null;
            try {
                if(!"template".equals(sourceType)) {
                    //校验当前文件Id和单据文件是否一致，不一致则不进行保存
                    String queryFileRespStr = HttpTookit.get(BASE_HOST +"ejc-file-web/api/attachref/queryListBySourceId", params, headers);
                    CommonResponse<List<AttachmentVO>> queryFileResp = JSONObject.parseObject(queryFileRespStr, CommonResponse.class);
                    if(!queryFileResp.isSuccess()) {
                        logger.error("查询当前单据编辑文件信息失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}，原因：{}",
                                sourceId, sourceType, billType, originalFileNameStr, replace, queryFileResp.getMsg());
                        return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "保存模板文件失败！").toString();
                    }

                    String curBillFileId = queryFileResp.getData() != null ? JSONObject.parseObject(JSONObject.toJSONString(queryFileResp.getData().get(0)), AttachmentVO.class).getId().toString() : null;
                    logger.info("当前待保存附件Id-{}，合同文件Id-{}", wpsFileId, curBillFileId);
                    if(CollectionUtils.isEmpty(queryFileResp.getData()) || !wpsFileId.equals(curBillFileId)) {
                        logger.info("当前待文件信息与单据编辑文件信息不一致，不进行保存！");
                        return getReturnMsg(WpsReturnCodeEnum.Success, "服务处理中...").toString();
                    }

                    //
                }

                //保存新的模板文件
                String fileUploadRespStr = postFile(BASE_HOST +"ejc-file-web/attachment/upload", params, headers, file);
                CommonResponse<List<AttachmentVO>> attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
                if(!attachmentResp.isSuccess()) {
                    logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}，原因：{}",
                            sourceId, sourceType, billType, originalFileNameStr, replace, attachmentResp.getMsg());
                    return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "保存模板文件失败！").toString();
                }
                attachmentVO = JSONObject.parseObject(JSONObject.toJSONString(attachmentResp.getData().get(0)), AttachmentVO.class);

            } catch (Exception e) {
                logger.error("上传模板文件异常sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}，",
                        sourceId, sourceType, billType, originalFileNameStr, replace, e);
                return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "保存模板文件失败！").toString();
            }
            logger.info("模板文件保存成功：{}", JSONObject.toJSONString(attachmentVO));

            switch (sourceType) {
                case "contractFile":
                    fileInfo = updateFileInfo(attachmentVO, billType, authority, Long.valueOf(templateId), attachmentVO.getId());
                    break;
                default:
                    fileInfo = newTemplateVersion(attachmentVO, sourceId, authority, billType);
            }

            logger.info("模板信息更新结果：{}", fileInfo);
            if(!Boolean.valueOf(fileInfo.get("oprResult").toString())) {
                fileInfo.remove("oprResult");
                return fileInfo;
            }
            fileInfo.put("download_url", fileInfo.get("download_url").toString()+"&_w_source_id="+sourceId+"&_w_uid="+userId+"&_w_token="+uToken);
            fileInfo.remove("oprResult");
            resp.put("file", fileInfo);
        } else {
            return getReturnMsg(WpsReturnCodeEnum.SessionExpired, "用户会话信息失效！").toString();
        }

        return resp.toString();
    }

    /**
     * 从模板重新生成文件
     *
     * @param templateId
     * @param sourceId
     * @param sourceType
     * @param billType
     * @return
     */
    @PostMapping(value = "resetContractFile")
    public CommonResponse<AttachmentVO> resetContractFile(@RequestParam(value = "templateId", required = false) String templateId,
                                                          @RequestParam(value = "categoryId", required = false) String categoryId,
                                                          @RequestParam(value = "sourceId") String sourceId,
                                                          @RequestParam(value = "sourceType") String sourceType,
                                                          @RequestParam(value = "billType") String billType, HttpServletRequest request) {
        if(null == templateId && null == categoryId) {
            return CommonResponse.error("从模板重新生成文件失败，参数templateId、categoryId不能同时为空！");
        }
        TemplateVO template = null;
        if(null != templateId) {
            CommonResponse<TemplateVO> tempResp = templateApi.queryDetailById(Long.valueOf(templateId));
            if(!tempResp.isSuccess()) {
                logger.error("从模板重新生成文件失败, 依据id-{}获取模板信息失败: {}", templateId, tempResp.getMsg());
                return CommonResponse.error("从模板重新生成文件失败，获取模板信息失败！");
            }
            template = tempResp.getData();
        } else {
            CommonResponse<TemplateVO> tempResp = templateApi.getByCategoryId(Long.valueOf(categoryId));
            if(!tempResp.isSuccess()) {
                logger.error("从模板重新生成文件失败, 依据categoryId-{}获取模板信息失败: {}", categoryId, tempResp.getMsg());
                return CommonResponse.error("从模板重新生成文件失败，获取模板信息失败！");
            }
            template = tempResp.getData();
        }

        //根据从合同模板生成新的合同文件
        CommonResponse<AttachmentVO> fileCopyResp = attachmentApi.copyFile(template.getFileId().toString(),
                sourceId, billType, sourceType, true);
        logger.error("根据从合同模板生成新的合同文件,参数--->sourceFileId-{}, sourceId-{}, sourceType-{}, billType-{}, 结果-->{}",
                template.getFileId().toString(), sourceId, sourceType, billType, JSONObject.toJSONString(fileCopyResp));

        if(!fileCopyResp.isSuccess()) {
            logger.error("获取模板文件访问url失败, 根据模板文件生成新的合同文件失败: {}", fileCopyResp.getMsg());
            return CommonResponse.error("获取模板文件访问url失败, 根据模板文件生成新的合同文件失败！");
        }

        //清空当前编辑文件二维码信息
        BillEditInfoEntity billEdit = billEditInfoService.selectById(sourceId);
        if(null != billEdit) {
            billEdit.setqRCodeBase64(null);
            billEditInfoService.saveOrUpdate(billEdit, false);
        }

        //更新单据
        updateFileInfo(fileCopyResp.getData(), billType, request.getHeader("authority"), null, null);

       return CommonResponse.success("重新生成文件成功！", fileCopyResp.getData());
    }

    /**
     * 生成的签章文件信息更新到业务系统
     *
     * @param attachmentVO
     * @return
     */
    @PostMapping(value = "updateSignFileInfo")
    public CommonResponse<AttachmentVO> updateSignFileInfo(@RequestBody AttachmentVO attachmentVO) {
        String authority = getAuthority(InvocationInfoProxy.getUserid().toString(), InvocationInfoProxy.getToken());

        if(StringUtils.isBlank(authority)) {
            logger.error("签章文件信息fileInfo-【{}】更新失敗，获取Authority失败！", JSONObject.toJSONString(attachmentVO));
            return CommonResponse.error("签章文件信息更新失敗，获取Authority失败！");
        }

        JSONObject updateResult = updateFileInfo(attachmentVO, attachmentVO.getBillType(), authority, null, null);
        if(updateResult.getBoolean("oprResult")) {
            return CommonResponse.success("签章文件信息更新成功！", attachmentVO);
        } else {
            return CommonResponse.error(updateResult.getString("details"));
        }
    }

    /**
     * 更新附件信息
     *
     * @param attachmentVO
     * @param billType
     * @return
     */
    public JSONObject updateFileInfo(AttachmentVO attachmentVO, String billType, String authority, Long templateId, Long mainFileId) {
        JSONObject resp = new JSONObject();
        resp.put("oprResult", true);
        boolean mergeFlag = false;

        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("authority", authority);
        headerMap.put("content-type", "application/json;charset=UTF-8");

        //更新业务单据中的附件信息
        //根据单据类型查询元数据信息
        CommonResponse<MdReferVO> mdRefResp = billTypeApi.queryMetadataByBillType(billType);
        if(!mdRefResp.isSuccess()) {
            logger.error("附件更新失败,根据billType-{}查询元数据信息失败,原因：{}！", billType, mdRefResp.getMsg());
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "文件更新失败！");
        }
        MdReferVO mdRef = mdRefResp.getData();
        String entityNameFmt = mdRef.getEntityName().replace("Entity", "");

        String httpReqPrefix = BASE_HOST + mdRef.getProjectName() + "/" +entityNameFmt.substring(0,1).toLowerCase() + entityNameFmt.substring(1);

        AttachmentVO wholeDataFile = null;
        if(null != templateId) {
            Map<String, Object> detailQueryParam = new HashMap<>();
            detailQueryParam.put("templateId", templateId);
            //1、根据单据类型查询对应的子表导出模板
            try {
                String detailExportListJson = HttpTookit.get(
                        BASE_HOST + "ejc-contractbase-web/api/templDetail/findExportDetailByCategoryId",
                        detailQueryParam, headerMap);
                logger.error("查询合同模板Id-{},对应导出模板设置列表结果：{}", templateId, detailExportListJson);

                CommonResponse<List<TemplDetailExportSettingVO>> templDetailResp = JSONObject.parseObject(detailExportListJson, CommonResponse.class);
                if(!templDetailResp.isSuccess()) {
                    logger.error("查询合同模板Id-{},对应导出模板设置列表结果失败：{}", JSONObject.toJSONString(templateId), templDetailResp.getMsg());
                    return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "文件同步保存失败！");
                } else {
                    List<TemplDetailExportSettingVO> detailList = JSONObject.parseArray(JSONObject.toJSONString(templDetailResp.getData()), TemplDetailExportSettingVO.class);
                    Map<String, Object> billData = new HashMap<>();
                    //请求对应服务 查询单据数据
                    Map<String, String> billDataQuery = new HashMap<>();
                    billDataQuery.put("id", attachmentVO.getSourceId().toString());
                    String billDataQueryUrl = httpReqPrefix + "FileUpdate/getBillDataJson";
                    String billDataQueryRespStr = HttpTookit.get(billDataQueryUrl, billDataQuery, headerMap);
                    logger.error("调用业务系统url-{},param-{}查询业务单据详情结果：{}", billDataQueryUrl, JSONObject.toJSONString(billDataQuery), billDataQueryRespStr);
                    CommonResponse<JSONObject> billDataResp = JSONObject.parseObject(billDataQueryRespStr, CommonResponse.class);
                    if(!billDataResp.isSuccess()) {
                        //获取单据详情数据失败
                        return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "获取单据详情信息失败！");
                    } else {
                        JSONObject billDataJson = JSONObject.parseObject(JSONObject.toJSONString(billDataResp.getData()));

                        List<Future<File>> backFileIdFutures = new ArrayList<>(detailList.size());
                        Map<String, Integer> sequence = new HashMap<>();
                        JSONArray billDataJsonArr = null;
                        for(TemplDetailExportSettingVO templDetail : detailList) {
                            logger.info("子表导出设置：{}", JSONObject.toJSONString(templDetail));
                            if(null != templDetail.getCustomFileId() || null != templDetail.getSysFileId()) {
                                billDataJsonArr = billDataJson.getJSONArray(templDetail.getMainAttrName());
                                if(null != templDetail.getEmptyExportFlag() && !templDetail.getEmptyExportFlag() && (null == billDataJsonArr || billDataJsonArr.size() == 0)) {
                                    logger.info("子表-[{}]设置数据为空时不进行导出，跳过该子表导出操作！", templDetail.getDetailName());
                                    continue;
                                }
                                backFileIdFutures.add(getTemplDetailPdfFileId(templDetail, attachmentVO.getSourceId(), billDataJsonArr, authority, sequence));
                            }
                        }

                        File tempFile = null;
                        Map<String, Map<String, InputStream>> filesMap = new HashMap<>();
                        for(Future<File> f : backFileIdFutures) {
                            Map<String, InputStream> fileMap = new HashMap<>();
                            tempFile = f.get();
                            if(null == tempFile) {
                                logger.info("获取子表文件为空，跳过导出");
                                continue;
                            }
                            logger.info("获取到子表文件：{}", tempFile.getName());
                            fileMap.put(tempFile.getName(), new FileInputStream(tempFile));
                            filesMap.put(tempFile.getName(), fileMap);
                        }

                        if(MapUtils.isNotEmpty(filesMap)) {
                            Map<String, String> mergeParams = new HashMap<>();
                            mergeParams.put("sourceId", attachmentVO.getSourceId().toString());
                            mergeParams.put("sourceType", "billWholeDataPdf");
                            mergeParams.put("billType", attachmentVO.getBillType());
                            mergeParams.put("mainFileId", attachmentVO.getId().toString());
                            mergeParams.put("replace", "true");
                            mergeParams.put("mergeSequence", JSONObject.toJSONString(sequence));

                            Map<String, String> uploadHeader =new HashMap<>();
                            uploadHeader.put("authority", authority);
                            //汇总所有文件Id，拼接成PDF文件
                            String fileMergeResult = HttpTookit.postFiles(BASE_HOST + "ejc-file-web/attachment/uploadAndMerge2Pdf", mergeParams, uploadHeader, filesMap, 10000, 10000);
                            logger.info("文件合并-【参数：{}，header-{}, 上传文件数量：{}】结果：{}", JSONObject.toJSONString(mergeParams), JSONObject.toJSONString(uploadHeader), filesMap.keySet().size(), fileMergeResult);
                            CommonResponse<AttachmentVO> wholeDataAttchResp = JSONObject.parseObject(fileMergeResult, CommonResponse.class);
                            if(!wholeDataAttchResp.isSuccess()) {
                                logger.error("生成单据全数据PDF文件失败！");
                            }
                            wholeDataFile = JSONObject.parseObject(JSONObject.toJSONString(wholeDataAttchResp.getData()), AttachmentVO.class);
                            mergeFlag = true;
                        }
                    }
                }

            } catch (Exception e) {
                logger.error("查询合同模板Id-{},对应导出模板设置列表异常：", templateId, e);
//                return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "文件更新失败！");
            }
        }

        //获取到对应工程信息，调用指定工程的文档信息会写服务
        String url = httpReqPrefix + "FileUpdate/updateFileInfo";
        logger.info("更新业务系统附件信息地址：{}", url);
        Map<String, Object> param = new HashMap<>();

        if(mergeFlag && wholeDataFile != null) {
            param.put("billId", wholeDataFile.getSourceId());
            param.put("sourceType", wholeDataFile.getSourceType());
            param.put("billType", billType);
            param.put("fileId", wholeDataFile.getId());
            param.put("fileSize", wholeDataFile.getFileSize());
            param.put("fileName", wholeDataFile.getFileName());
            param.put("fileOnlinePath", wholeDataFile.getOnlinePath());
            param.put("imgServerPath", wholeDataFile.getImgServerPath());
            param.put("formatPathStr", wholeDataFile.getFileFormatPathStr());
            param.put("fileVersion", wholeDataFile.getVersion());
        } else {
            param.put("billId", attachmentVO.getSourceId());
            param.put("sourceType", attachmentVO.getSourceType());
            param.put("billType", billType);
            param.put("fileId", attachmentVO.getId());
            param.put("fileSize", attachmentVO.getFileSize());
            param.put("fileName", attachmentVO.getFileName());
            param.put("fileOnlinePath", attachmentVO.getOnlinePath());
            param.put("imgServerPath", attachmentVO.getImgServerPath());
            param.put("formatPathStr", attachmentVO.getFileFormatPathStr());
            param.put("fileVersion", attachmentVO.getVersion());
        }

        try {
            String httpRespStr = HttpTookit.postByJson(url, JSONObject.toJSONString(param), headerMap, 10000, 10000);
            logger.error("调用业务系统url-{},param-{}更新单据文档信息结果：{}", url, JSONObject.toJSONString(param), httpRespStr);

            resp.put("id", attachmentVO.getSourceId().toString());
            resp.put("name", attachmentVO.getFileName());
            resp.put("size", attachmentVO.getFileSize());
            resp.put("version", attachmentVO.getVersion());
            resp.put("download_url", BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type="+billType+"&_w_fileid="+attachmentVO.getSourceId().toString()+"&_w_source_type=template&_w_source_attach_id="+attachmentVO.getId());

            return resp;
        } catch (Exception e) {
            logger.error("调用业务系统url-{},param-{}更新单据文档信息异常：", url, JSONObject.toJSONString(param), e);
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "文件更新失败！");
        }
    }

    @Async("commonTask")
    public Future<File> getTemplDetailPdfFileId(TemplDetailExportSettingVO templDetail, Long sourceId, JSONArray billData, String authority, Map<String, Integer> sequence) throws Exception {
        Map<String, Object> dataMap = new HashMap<>();
        dataMap.put(templDetail.getMainAttrName(), null == billData || billData.size() == 0 ? new ArrayList<>() : billData);
        logger.info("将数据{}写入子表：{}", JSONObject.toJSONString(dataMap), templDetail.getMainAttrName());
        File dataFile = File.createTempFile(templDetail.getBelongEntityId().toString(), ".xlsx");
        sequence.put(dataFile.getName(), null != templDetail.getDetailSequence() ? templDetail.getDetailSequence() : 0);
        OutputStream dataOuts = new FileOutputStream(dataFile);
        XLSTransformer transformer = new XLSTransformer();
        Workbook workbook = null;

        try {
            //1、获取子表数据，
            Response fileResponse = attachmentApi.downloadFileById(null != templDetail.getCustomFileId() ? templDetail.getCustomFileId() : templDetail.getSysFileId());
            Response.Body body = fileResponse.body();
            InputStream inputStream = body.asInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            workbook = transformer.transformXLS(bufferedInputStream, dataMap);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setWrapText(true);

            Sheet sheet = workbook.getSheetAt(0);
            sheet.setAutobreaks(true);
            autoColumnWidthForChineseChar(sheet, 0, sheet.getRow(0).getLastCellNum(), cellStyle);

            workbook.write(dataOuts);
        }catch (Exception e) {
            logger.error("子表-【{}】数据写入导出模板异常:", e);
            return new AsyncResult<>(null);
        } finally {
            if(null != workbook) {
                workbook.close();
            }
            if(null != dataOuts) {
                dataOuts.flush();
            }
            if(null != dataOuts) {
                dataOuts.close();
            }
        }

//        ByteArrayOutputStream bos = new ByteArrayOutputStream();
//        Document document = new Document(bufferedInputStream);
//
//        Map<String,String> params = new HashMap<>();
//        params.put("sourceType", sourceType);
//        params.put("sourceId", sourceId);
//        params.put("billType", billType);
//        params.put("originalFileNameStr", StringUtils.isNotBlank(originalFileNameStr) ? originalFileNameStr : file.getOriginalFilename());
//        params.put("replace", replace);
//        Map<String,String> headers = new HashMap<>();
//        headers.put("authority", authority);
//
//        //保存新的模板文件
//        String fileUploadRespStr = postFile(BASE_HOST +"ejc-file-web/attachment/upload", params, headers, file);
//        CommonResponse<List<AttachmentVO>> attachmentResp = JSONObject.parseObject(fileUploadRespStr, CommonResponse.class);
//        if(!attachmentResp.isSuccess()) {
//            logger.error("保存模板文件失败sourceId-{}, sourceType-{}, billType-{}, originalFileNameStr-{}, replace-{}，原因：{}",
//                    sourceId, sourceType, billType, originalFileNameStr, replace, attachmentResp.getMsg());
//            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "保存模板文件失败！").toString();
//        }

        return new AsyncResult<>(dataFile);
    }


    private JSONObject newTemplateVersion(AttachmentVO attachmentVO, String sourceId, String authority,String billType) {
        JSONObject resp = new JSONObject();
        resp.put("oprResult", true);

        //查询最细模板信息
        CommonResponse<TemplateVersionVO> tmplVersionResp = templateApi.getTemplateVersionInfo(Long.valueOf(sourceId), null);
        if(!tmplVersionResp.isSuccess()) {
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "获取对应模板信息失败！");
        }
        TemplateVersionVO template = tmplVersionResp.getData();
        logger.info("获取到当前最新模板版本信息: {}", JSONObject.toJSONString(template));

        //更新模板信息
        TemplateVersionVO newTmplVersion = generateNewTemplateVersion(template, attachmentVO);
        try {
            Map<String,String> header = new HashMap<>();
            header.put("authority", authority);
            header.put("content-type", "application/json;charset=UTF-8");
            String newTmplVersionRespStr = HttpTookit.postByJson(  BASE_HOST +"ejc-contractbase-web/api/template/createNewTmplVersion",
                    JSONObject.toJSONString(newTmplVersion), header, 10000, 1000);

            CommonResponse<TemplateVersionVO> newTmplVersionResp = JSONObject.parseObject(newTmplVersionRespStr, CommonResponse.class);
            if(!newTmplVersionResp.isSuccess()) {
                logger.error("调用模板服务更新模板版本信息-{}失败：{}", JSONObject.toJSONString(newTmplVersion), newTmplVersionResp.getMsg());
                return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "文件同步保存失败！");
            }
        } catch (Exception e) {
            logger.error("调用模板服务更新模板版本信息-{}异常：", JSONObject.toJSONString(newTmplVersion), e);
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg,"文件同步保存失败！");
        }

        resp.put("id", newTmplVersion.getFileId().toString());
        resp.put("name", newTmplVersion.getFileName());
        resp.put("size", newTmplVersion.getFileSize());
        resp.put("version", newTmplVersion.getTemplateVersion());
        resp.put("download_url", BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type="+billType+"&_w_fileid="+sourceId+"&_w_source_type=template&_w_source_attach_id="+attachmentVO.getId());

        return resp;
    }

    /**
     * 拼接返回信息
     *
     * @param backState 返回状态
     * @param customMsg 自定义错误信息
     * @return
     */
    private JSONObject getReturnMsg(WpsReturnCodeEnum backState, String customMsg) {
        JSONObject resp = new JSONObject();
        resp.put("code", backState.getCode());
        resp.put("message", backState.getMessage());
        resp.put("details", StringUtils.isNotBlank(customMsg) ? customMsg : backState.getDetails());
        resp.put("hint", StringUtils.isNotBlank(customMsg) ? customMsg : backState.getDetails());
        resp.put("oprResult", false);

        return resp;
    }

    /**
     * 根据模板Id、或者文件Id下载对应模板文件
     *
     * @param sourceId
     * @param billType
     * @param fileId
     * @param reFillData
     * @param sourceType
     * @param categoryId
     * @param uToken
     * @param userId
     * @param response
     */
    @GetMapping(value = "downloadFileByTmpId")
    public void downloadFileByTmpId(@RequestParam("_w_fileid") String wpsFileId,
                                    @RequestParam(value = "_w_bill_type") String billType,
                                    @RequestParam(value = "_w_source_attach_id", required = false) String fileId,
                                    @RequestParam(value = "_w_source_id") String sourceId,
                                    @RequestParam(value = "_w_refill_data", required = false, defaultValue = "false") String reFillData,
                                    @RequestParam(value = "_ejc_source_type", required = false, defaultValue = "template") String sourceType,
                                    @RequestParam(value = "_w_category_id", required = false) String categoryId,
                                    @RequestParam(value = "_w_token") String uToken,
                                    @RequestParam(value = "_w_uid") String userId,
                                    HttpServletResponse response) {
        logger.info("下载文件参数：sourceId-{},billType-{},fileId-{},reFillData-{},sourceType-{},-categoryId{},"
                ,sourceId, billType, fileId, reFillData, sourceType, categoryId);
        String authority = checkOnLine(userId, uToken);
        if(null == authority) {
            throw new BusinessException("用户会话失效！");
        }
        InvocationInfoProxy.setExtendAttribute("authority", authority);
        Long attachId = null;
        if(StringUtils.isNotBlank(fileId)) {
            attachId = Long.valueOf(fileId);
        } else {
            switch (sourceType) {
                case "contractFile":
                    if("false".equals(reFillData)) {
                        CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, null);
                        if(!attachResp.isSuccess()) {
                            logger.error("根据sourceId-{},billType-{},sourceType-{}获取对应文件信息失败，{}", sourceId, billType, sourceType, attachResp.getMsg());
                            throw new BusinessException("获取对应文件信息失败！");
                        }
                        if(CollectionUtils.isEmpty(attachResp.getData())) {
                            logger.error("根据sourceId-{},billType-{},sourceType-{}找不到匹配的文件信息", sourceId, billType, sourceType);
                            throw new BusinessException("未获取到匹配的文件信息！");
                        }
                        attachId = attachResp.getData().get(0).getId();
                    } else {
                        logger.info("根据categoryId-{}查找文件信息", categoryId);
                        CommonResponse<TemplateVO> tmplResp = templateApi.getByCategoryId(Long.valueOf(categoryId));
                        if(!tmplResp.isSuccess()) {
                            logger.error("根据categoryId-{}获取对应文件信息失败，{}", sourceId, billType, sourceType, tmplResp.getMsg());
                            throw new BusinessException("获取对应文件信息失败！");
                        }
                        attachId = tmplResp.getData().getFileId();
                    }
                    break;
                default:
                    //查询最细模板信息
                    CommonResponse<TemplateVersionVO> tmplVersionResp = templateApi.getTemplateVersionInfo(Long.valueOf(sourceId), null);
                    if(!tmplVersionResp.isSuccess()) {
                        logger.error("获取templateId-{}对应文件失败！", sourceId, tmplVersionResp.getMsg());
                        throw new BusinessException("获取对应模板信息失败");
                    }
                    attachId = tmplVersionResp.getData().getFileId();
            }
        }

        logger.info("下载文件fileId-{} ", attachId);

        InputStream inputStream = null;
        try {
            Response fileResponse = attachmentApi.downloadFileById(attachId);
            Response.Body body = fileResponse.body();
            inputStream = body.asInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            response.setHeader("Content-Disposition", fileResponse.headers().get("Content-Disposition").toString().replace("[","").replace("]",""));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(response.getOutputStream());
            int length = 0;
            byte[] temp = new byte[1024 * 10];
            while ((length = bufferedInputStream.read(temp)) != -1) {
                bufferedOutputStream.write(temp, 0, length);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedInputStream.close();
            inputStream.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 生成新的模板版本信息
     *
     * @return
     * @param tmplVersion
     * @param attachmentVO
     */
    private TemplateVersionVO generateNewTemplateVersion(TemplateVersionVO tmplVersion, AttachmentVO attachmentVO) {
        TemplateVersionVO newTmplVersion = new TemplateVersionVO();
        newTmplVersion.setFileId(attachmentVO.getId());
        newTmplVersion.setFileName(attachmentVO.getFileName());
        newTmplVersion.setFilePath(attachmentVO.getFilePath());
        newTmplVersion.setFileSize(attachmentVO.getFileSize());
        newTmplVersion.setFileType(getFileType(attachmentVO.getFileName()));
        newTmplVersion.setSequence(tmplVersion.getSequence());
        newTmplVersion.setOnlinePath(attachmentVO.getOnlinePath());
        newTmplVersion.setTemplateName(tmplVersion.getTemplateName());
        newTmplVersion.setTemplateVersion(tmplVersion.getTemplateVersion()+1);
        newTmplVersion.setTenantId(tmplVersion.getTenantId());
        newTmplVersion.setTemplateId(tmplVersion.getTemplateId());

        return newTmplVersion;
    }

    /**
     * 根据合同Id查询合同草稿附件信息
     *
     * @param sourceId
     * @return
     */
    private JSONObject getFile(String sourceId, String sourceType, String billType, String fileId, String categoryId) {
        //文件信息
        JSONObject fileInfo = new JSONObject();
        fileInfo.put("oprResult", true);
        AttachmentVO file = null;
        if(StringUtils.isNotBlank(fileId)) {
            CommonResponse<AttachmentVO> attachmentResp = attachmentApi.queryDetail(fileId);
            if(!attachmentResp.isSuccess()) {
                logger.error("根据Id-{}获取对应文件信息失败，{}", fileId, attachmentResp.getMsg());
                return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "根据Id获取对应文件信息失败！");
            }
            file = attachmentResp.getData();
        } else {
            CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryListBySourceId(Long.valueOf(sourceId), billType, sourceType, null);
            if(!attachResp.isSuccess()) {
                logger.error("根据sourceId-{},billType-{},sourceType-{}获取对应文件信息失败，{}", sourceId, billType, sourceType, attachResp.getMsg());
                return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "获取对应文件信息失败！");
            }

           if(CollectionUtils.isEmpty(attachResp.getData())) {
               logger.info("根据sourceId-{},billType-{},sourceType-{}找不到匹配的文件信息, 继续根据categoryId-{}查找文件信息", sourceId, billType, sourceType, categoryId);
               CommonResponse<TemplateVO> tmplResp = templateApi.getByCategoryId(Long.valueOf(categoryId));
               if(!tmplResp.isSuccess()) {
                   logger.error("根据categoryId-{}获取对应文件信息失败，{}", sourceId, billType, sourceType, tmplResp.getMsg());
                   return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "获取对应文件信息失败！");
               }
               TemplateVO tmpl = tmplResp.getData();
               file = new AttachmentVO();
               file.setId(tmpl.getFileId());
               file.setFileName(tmpl.getFileName());
               file.setFileSize(tmpl.getFileSize());
               file.setVersion(1);
               file.setCreateUserCode(tmpl.getCreateUserCode());
               file.setUpdateUserCode(tmpl.getUpdateUserCode());
           } else {
               file = attachResp.getData().get(0);
           }
        }

        //文件名(必须带文件后缀)
        fileInfo.put("name", file.getFileName());
        //当前版本号,必须大于 0，同时位数小于 11
        fileInfo.put("version", file.getVersion());
        //文件大小，单位为B(文件真实大小，否则会出现异常)
        fileInfo.put("size", file.getFileSize());
        // 创建者编码，字符串长度小于40
        fileInfo.put("creator", file.getCreateUserCode());
        //修改者i编码，字符串长度小于40
        fileInfo.put("modifier", file.getUpdateUserCode());
        fileInfo.put("download_url", BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type="+billType+"&_w_fileid="+sourceId+"&_w_source_type="+sourceType+"&_w_source_attach_id="+file.getId().toString());

        return fileInfo;
    }

    /**
     * 根据模板Id和版本号查询对应附件信息
     *
     * @param templateId
     * @param version
     * @return
     */
    private JSONObject getTmplFileInfo(Long templateId, Long version, String billType) {
        CommonResponse<TemplateVersionVO> versionResp = templateApi.getTemplateVersionInfo(templateId, version);
        //文件信息
        JSONObject fileInfo = new JSONObject();
        if(!versionResp.isSuccess()) {
            logger.error("根据参数: templateId-{}获取对应模板信息失败，原因：{}",
                    templateId, versionResp.getMsg());
            return getReturnMsg(WpsReturnCodeEnum.CustomMsg, "获取对应模板信息失败！");
        }
        TemplateVersionVO templateVersionVO = versionResp.getData();

        //文件Id,字符串长度小于40，和 URL 中的fileid必须一致
//        fileInfo.put("id", templateId.toString());

        //文件名(必须带文件后缀)
        fileInfo.put("name", templateVersionVO.getFileName());
        //当前版本号,必须大于 0，同时位数小于 11
        fileInfo.put("version", templateVersionVO.getTemplateVersion());
        //文件大小，单位为B(文件真实大小，否则会出现异常)
        fileInfo.put("size", templateVersionVO.getFileSize());
        // 创建者编码，字符串长度小于40
        fileInfo.put("creator", templateVersionVO.getCreateUserCode());
        //修改者i编码，字符串长度小于40
        fileInfo.put("modifier", templateVersionVO.getUpdateUserCode());
        fileInfo.put("download_url", BASE_HOST + "ejc-wpsofficeedit-web/wpscbk/downloadFileByTmpId?_w_bill_type="+billType+"&_w_fileid="+templateVersionVO.getFileId()+"&_w_source_type=template&_w_source_attach_id="+templateVersionVO.getFileId());

        fileInfo.put("oprResult", true);

        return fileInfo;
    }


    /**
     * 根据文档类型返回对应类型
     *
     * @param fileName
     * @return
     */
    private String getFileType(String fileName) {
        if(fileName.indexOf(".doc") >= 0) {
            return "w";
        } else if(fileName.indexOf(".xls") >= 0) {
            return "s";
        } else if(fileName.indexOf(".ppt") >= 0) {
            return "p";
        } else {
            return "f";
        }
    }

    /**
     * 参数urlEncode编码处理
     *
     * @param params 请求参数
     * @return
     * @throws UnsupportedEncodingException
     */
    private String getUrlParam(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (builder.length() > 0) {
                builder.append('&');
            }
            builder.append(URLEncoder.encode(entry.getKey(), "utf-8")).append('=').append(URLEncoder.encode(entry.getValue(), "utf-8"));
        }
        return  builder.toString();
    }

    /**
     * 对参数按照字典顺序排序后进行sha1签名，base64编码
     *
     * @param params 请求参数
     * @param appSecret 密钥
     * @return
     */
    private String getSignature(Map<String, String> params, String appSecret) {
        List<String> keys=new ArrayList();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            keys.add(entry.getKey());
        }

        // 将所有参数按key的升序排序
        Collections.sort(keys, new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });

        // 构造签名的源字符串
        StringBuilder contents=new StringBuilder("");
        for (String key : keys) {
            if (key=="_w_signature"){
                continue;
            }
            contents.append(key+"=").append(params.get(key));
            System.out.println("key:"+key+",value:"+params.get(key));
        }
        contents.append("_w_secretkey=").append(appSecret);

        // 进行hmac sha1 签名
        byte[] bytes= hmacSha1(appSecret.getBytes(),contents.toString().getBytes());
        //字符串经过Base64编码
        String sign= encodeBase64String(bytes);
        try {
            sign = URLEncoder.encode( sign, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println(sign);
        return sign;
    }

    /**
     * 内容加密
     *
     * @param key
     * @param data
     * @return
     */
    public byte[] hmacSha1(byte[] key, byte[] data) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance(signingKey.getAlgorithm());
            mac.init(signingKey);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }


    public static String postFile(String url, Map<String, String> params, Map<String, String> headers, MultipartFile file) throws Exception {
        String charset = "UTF-8";
        HttpClient client = null;

        HttpPost post = new HttpPost(url);
        HttpServletRequest request = null;
        String result = "";
        Integer connTimeout = 30000;
        Integer readTimeout = 30000;

        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.setCharset(Charset.forName("UTF-8")).addBinaryBody("file",
                    file.getInputStream(), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8"), file.getOriginalFilename());
            for(String key : params.keySet()) {
                builder.addPart(key, new StringBody(params.get(key), ContentType.MULTIPART_FORM_DATA.withCharset("UTF-8")));
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);

            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout);
            }

            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }

            post.setConfig(customReqConf.build());
            if (null != headers) {
                String key = null;
                Iterator it = headers.keySet().iterator();

                while(it.hasNext()) {
                    key = (String)it.next();
                    post.addHeader(key, (String)headers.get(key));
                }
            } else {
                request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                post.addHeader("authority", request.getHeader("authority"));
                post.addHeader("ejc-token", request.getHeader("ejc-token"));
            }

            HttpResponse res;
            if (url.startsWith("https")) {
                client = HttpTookit.createSSLInsecureClient();
                res = ((HttpClient)client).execute(post);
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(128);
                cm.setDefaultMaxPerRoute(128);
                client = HttpClients.custom().setConnectionManager(cm).build();
                res = ((HttpClient)client).execute(post);
            }

            result = IOUtils.toString(res.getEntity().getContent(), charset);
        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }

        return result;
    }

    public static void main(String[] args) throws Exception {

        try
        {
            registerPdf_v_21_7();
        }
        catch (Exception e)
        {
            throw new RuntimeException("Aspose注册失败", e);
        }

//        String url = "https://dev.17elian.com/ejc-file-web/api/attachref/downloadFileById";
        XLSTransformer transformer = new XLSTransformer();
        File f = new File("D:\\detailList.xlsx");
        InputStream is = new FileInputStream(f);
        Map<String, Object> billData = new HashMap<>();
        File pdfFile = new File("D:\\testPdf2.xlsx");
//        List<JSONObject> data  = new ArrayList<>();
//        for(int i = 0; i < 50; i++) {
//            JSONObject oneData = new JSONObject();
//            oneData.put("billCode", "pdf-b-"+i);
//            oneData.put("handleTypeStr", "手动新增-"+i);
//            oneData.put("sourceTypeName", "劳务分包合同-"+i);
//            System.out.println("i % 2 = " + (i % 2));
//            if(i % 2 !=0) {
//                oneData.put("projectName", "11内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长");
//                oneData.put("contractName", "测试劳务测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同测试劳务分包合同-"+i);
//                oneData.put("partyaName", "北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司-"+i);
//                oneData.put("partybName", "11内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长-"+i);
//            } else {
//                oneData.put("projectName", "测试项目测试劳务劳务分包合同测试劳务分包合同-"+i);
//                oneData.put("contractName", "测试劳务测试劳-"+i);
//                oneData.put("partyaName", "11内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长内容超长-"+i);
//                oneData.put("partybame", "北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司北京益企联科技有限公司-"+i);
//            }
//            oneData.put("settleDate", new Date());
//            oneData.put("curTaxMny", "123,456.00");
//            oneData.put("lastTaxMny", "789,456.00");
//            oneData.put("settlePropertyName", "支出合同");
//            data.add(oneData);
//        }

        String dataJson = "[{\"id\":\"1587401123357642753\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-01 19:08:15\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":39,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"JZZXZS\",\"detailName\":\"建筑装修装饰工程专业承包\",\"docPriceTypeName\":null,\"treeIndex\":\"1\",\"detailWorkContent\":null,\"detailMeasurementRules\":null,\"detailUnit\":null,\"detailNum\":null,\"detailPrice\":null,\"detailTaxRate\":11,\"detailMny\":31523489484485.64,\"detailTaxPrice\":31523489484485.2658,\"detailTaxMny\":8531523489484485.12,\"detailTax\":0.96,\"detailMemo\":\"\",\"sourceId\":\"1493124046178713602\",\"sourceType\":\"target\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":null,\"tid\":\"1493124046178713602\",\"tpid\":null,\"changeType\":null,\"docCategoryId\":\"1493124046178713602\",\"docId\":null,\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":false,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":null,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1587401123357642753\",\"parentID\":null,\"shadowId\":\"1587401123357642753\"},{\"id\":\"1587401123357642754\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-01 19:08:15\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":39,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"CSCSLJFS001\",\"detailName\":\"测试量价方式\",\"docPriceTypeName\":\"综合单价\",\"treeIndex\":\"1.1\",\"detailWorkContent\":\"测试测试1测试1测试1测试1测试1测试1测试1测试1测试1测试1测试1测试1测试1测试1测试1\",\"detailMeasurementRules\":null,\"detailUnit\":\"m²\",\"detailNum\":1,\"detailPrice\":1.98019802,\"detailTaxRate\":11,\"detailMny\":1.98,\"detailTaxPrice\":2,\"detailTaxMny\":2185641848641641684,\"detailTax\":0.22,\"detailMemo\":\"123\",\"sourceId\":\"622147447699423321\",\"sourceType\":\"target\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1587401123357642753\",\"tid\":\"622147447699423321\",\"tpid\":\"1493124046178713602\",\"changeType\":null,\"docCategoryId\":\"1493124046178713602\",\"docId\":\"622147447699423321\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":1,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"20.0000-200.0000\",\"historyTaxPriceArea\":\"20.2000-210.0000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1587401123357642754\",\"parentID\":\"1587401123357642753\",\"shadowId\":\"1587401123357642754\"},{\"id\":\"1587401560194404354\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-01 19:09:59\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":38,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"CSCSLJFS001\",\"detailName\":\"测试量价方式\",\"docPriceTypeName\":\"综合单价\",\"treeIndex\":\"1.2\",\"detailWorkContent\":\"测试\",\"detailMeasurementRules\":null,\"detailUnit\":\"m²\",\"detailNum\":2,\"detailPrice\":1.98019802,\"detailTaxRate\":11,\"detailMny\":3.96,\"detailTaxPrice\":2,\"detailTaxMny\":4,\"detailTax\":0.44,\"detailMemo\":\"123\",\"sourceId\":\"622147447699423321\",\"sourceType\":\"target\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1587401123357642753\",\"tid\":\"622147447699423321\",\"tpid\":\"1493124046178713602\",\"changeType\":null,\"docCategoryId\":\"1493124046178713602\",\"docId\":\"622147447699423321\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":2,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"20.0000-200.0000\",\"historyTaxPriceArea\":\"20.2000-210.0000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1587401560194404354\",\"parentID\":\"1587401123357642753\",\"shadowId\":\"1587401560194404354\"},{\"id\":\"1587403062371799041\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-01 19:15:57\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":36,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"CSCSLJFS001\",\"detailName\":\"测试量价方式\",\"docPriceTypeName\":\"综合单价\",\"treeIndex\":\"1.3\",\"detailWorkContent\":\"测试\",\"detailMeasurementRules\":null,\"detailUnit\":\"m²\",\"detailNum\":15,\"detailPrice\":1.98019802,\"detailTaxRate\":1,\"detailMny\":29.7,\"detailTaxPrice\":2,\"detailTaxMny\":30,\"detailTax\":0.3,\"detailMemo\":\"123\",\"sourceId\":\"622147447699423321\",\"sourceType\":\"target\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1587401123357642753\",\"tid\":\"622147447699423321\",\"tpid\":\"1493124046178713602\",\"changeType\":null,\"docCategoryId\":\"1493124046178713602\",\"docId\":\"622147447699423321\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":15,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"20.0000-200.0000\",\"historyTaxPriceArea\":\"20.2000-210.0000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1587403062371799041\",\"parentID\":\"1587401123357642753\",\"shadowId\":\"1587403062371799041\"},{\"id\":\"1591061554461335554\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC\",\"detailName\":\"地基基础工程专业承包\",\"docPriceTypeName\":null,\"treeIndex\":\"2\",\"detailWorkContent\":null,\"detailMeasurementRules\":null,\"detailUnit\":null,\"detailNum\":null,\"detailPrice\":null,\"detailTaxRate\":11,\"detailMny\":16035,\"detailTaxPrice\":null,\"detailTaxMny\":17798.85,\"detailTax\":1763.85,\"detailMemo\":\"嗯嗯嗯\",\"sourceId\":\"1493124046233239553\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":null,\"tid\":\"1493124046233239553\",\"tpid\":null,\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":null,\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":false,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":null,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335554\",\"parentID\":null,\"shadowId\":\"1591061554461335554\"},{\"id\":\"1591061554461335555\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"LSD000036\",\"detailName\":\"a劳务\",\"docPriceTypeName\":null,\"treeIndex\":\"2.1\",\"detailWorkContent\":\"测试1\",\"detailMeasurementRules\":\"计量规则1\",\"detailUnit\":null,\"detailNum\":21,\"detailPrice\":11,\"detailTaxRate\":11,\"detailMny\":231,\"detailTaxPrice\":12.21,\"detailTaxMny\":256.41,\"detailTax\":25.41,\"detailMemo\":\"备注1\",\"sourceId\":\"591353489054646281\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"591353489054646281\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"591353489054646281\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":21,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335555\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335555\"},{\"id\":\"1591061554461335560\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC008\",\"detailName\":\"地面面层\",\"docPriceTypeName\":null,\"treeIndex\":\"2.2\",\"detailWorkContent\":\"测试6\",\"detailMeasurementRules\":\"计量规则6\",\"detailUnit\":\"\",\"detailNum\":26,\"detailPrice\":66,\"detailTaxRate\":11,\"detailMny\":1716,\"detailTaxPrice\":73.26,\"detailTaxMny\":1904.76,\"detailTax\":188.76,\"detailMemo\":\"备注6\",\"sourceId\":\"1493470196802756610\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196802756610\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196802756610\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":26,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335560\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335560\"},{\"id\":\"1591061554461335561\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC012\",\"detailName\":\"橡塑面层\",\"docPriceTypeName\":null,\"treeIndex\":\"2.3\",\"detailWorkContent\":\"测试7\",\"detailMeasurementRules\":\"计量规则7\",\"detailUnit\":\"\",\"detailNum\":27,\"detailPrice\":77,\"detailTaxRate\":11,\"detailMny\":2079,\"detailTaxPrice\":85.47,\"detailTaxMny\":2307.69,\"detailTax\":228.69,\"detailMemo\":\"备注7\",\"sourceId\":\"1493470196853088258\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196853088258\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196853088258\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":27,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335561\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335561\"},{\"id\":\"1591061554461335562\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC013\",\"detailName\":\"木竹面层\",\"docPriceTypeName\":null,\"treeIndex\":\"2.4\",\"detailWorkContent\":\"测测试1测试1测试1测试1测试1测试1测试测测试1测试1测试1测试1测试1测试1测试1测1测试1试8\",\"detailMeasurementRules\":\"计量规则8\",\"detailUnit\":\"\",\"detailNum\":28,\"detailPrice\":88,\"detailTaxRate\":11,\"detailMny\":2464,\"detailTaxPrice\":97.68,\"detailTaxMny\":2735.04,\"detailTax\":271.04,\"detailMemo\":\"备注8\",\"sourceId\":\"1493470196869865474\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196869865474\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196869865474\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":28,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335562\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335562\"},{\"id\":\"1591061554461335563\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC014\",\"detailName\":\"防水施工（人工）\",\"docPriceTypeName\":null,\"treeIndex\":\"2.5\",\"detailWorkContent\":\"测试9\",\"detailMeasurementRules\":\"计量规则9\",\"detailUnit\":\"\",\"detailNum\":29,\"detailPrice\":99,\"detailTaxRate\":11,\"detailMny\":2871,\"detailTaxPrice\":109.89,\"detailTaxMny\":3186.81,\"detailTax\":315.81,\"detailMemo\":\"备注9\",\"sourceId\":\"1493470196878254081\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196878254081\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196878254081\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":29,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335563\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335563\"},{\"id\":\"1591061554461335564\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC015\",\"detailName\":\"屋面上口盖板安装\",\"docPriceTypeName\":null,\"treeIndex\":\"2.6\",\"detailWorkContent\":\"测试10\",\"detailMeasurementRules\":\"计量规则10\",\"detailUnit\":\"\",\"detailNum\":30,\"detailPrice\":100,\"detailTaxRate\":11,\"detailMny\":3000,\"detailTaxPrice\":111,\"detailTaxMny\":3330,\"detailTax\":330,\"detailMemo\":\"备注10\",\"sourceId\":\"1493470196886642689\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196886642689\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196886642689\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":30,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335564\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335564\"},{\"id\":\"1591061554461335556\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC001\",\"detailName\":\"整体面层\",\"docPriceTypeName\":\"量价方式\",\"treeIndex\":\"2.7\",\"detailWorkContent\":\"测试2\",\"detailMeasurementRules\":\"计量规则2\",\"detailUnit\":\"\",\"detailNum\":22,\"detailPrice\":22,\"detailTaxRate\":11,\"detailMny\":484,\"detailTaxPrice\":24.42,\"detailTaxMny\":537.24,\"detailTax\":53.24,\"detailMemo\":\"备注2\",\"sourceId\":\"1493470196605624321\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196605624321\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196605624321\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":22,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"180.0000-180.0000\",\"historyTaxPriceArea\":\"0.0000-0.0000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335556\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335556\"},{\"id\":\"1591061554461335557\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC004\",\"detailName\":\"地砖粘贴\",\"docPriceTypeName\":\"量价方式\",\"treeIndex\":\"2.8\",\"detailWorkContent\":\"测试3\",\"detailMeasurementRules\":\"计量规则3\",\"detailUnit\":\"\",\"detailNum\":23,\"detailPrice\":33,\"detailTaxRate\":11,\"detailMny\":759,\"detailTaxPrice\":36.63,\"detailTaxMny\":842.49,\"detailTax\":83.49,\"detailMemo\":\"备注3\",\"sourceId\":\"1493470196744036353\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196744036353\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196744036353\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":23,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"10.0000-50.0000\",\"historyTaxPriceArea\":\"10.1000-50.5000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335557\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335557\"},{\"id\":\"1591061554461335558\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC006\",\"detailName\":\"地面垫层\",\"docPriceTypeName\":\"量价方式\",\"treeIndex\":\"2.9\",\"detailWorkContent\":\"测试4\",\"detailMeasurementRules\":\"计量规则4\",\"detailUnit\":\"\",\"detailNum\":24,\"detailPrice\":44,\"detailTaxRate\":11,\"detailMny\":1056,\"detailTaxPrice\":48.84,\"detailTaxMny\":1172.16,\"detailTax\":116.16,\"detailMemo\":\"备注4\",\"sourceId\":\"1493470196777590785\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196777590785\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196777590785\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":24,\"detailTargetResultSellId\":null,\"historyPriceArea\":\"10.0000-10.0000\",\"historyTaxPriceArea\":\"10.1000-10.1000\",\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335558\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335558\"},{\"id\":\"1591061554461335559\",\"createUserCode\":\"guoming\",\"createTime\":\"2022-11-11 21:33:30\",\"updateUserCode\":\"guoming\",\"updateTime\":\"2022-11-24 10:35:17\",\"dr\":0,\"tenantId\":\"999999\",\"syncEsFlag\":\"0\",\"rowState\":null,\"attachIds\":[],\"version\":30,\"createUserName\":\"guoming\",\"updateUserName\":\"guoming\",\"customField\":{},\"detailCode\":\"DJJC007\",\"detailName\":\"外墙面砖粘贴\",\"docPriceTypeName\":null,\"treeIndex\":\"2.10\",\"detailWorkContent\":\"测试5\",\"detailMeasurementRules\":\"计量规则5\",\"detailUnit\":\"\",\"detailNum\":25,\"detailPrice\":55,\"detailTaxRate\":11,\"detailMny\":1375,\"detailTaxPrice\":61.05,\"detailTaxMny\":1526.25,\"detailTax\":151.25,\"detailMemo\":\"备注5\",\"sourceId\":\"1493470196794368002\",\"sourceType\":\"doc\",\"contractId\":\"1587401123038875649\",\"changeId\":null,\"changeBid\":null,\"parentId\":\"1591061554461335554\",\"tid\":\"1493470196794368002\",\"tpid\":\"1493124046233239553\",\"changeType\":null,\"docCategoryId\":\"1493124046233239553\",\"docId\":\"1493470196794368002\",\"planId\":null,\"detailArtificialTaxMny\":0,\"detailArtificialMny\":0,\"detailArtificialTax\":0,\"detailArtificialTaxPrice\":null,\"detailArtificialPrice\":null,\"leafFlag\":true,\"detailTargetResultNum\":null,\"detailTargetResultPrice\":null,\"detailTargetResultRemainderNum\":null,\"detailBaseTargetResultNum\":25,\"detailTargetResultSellId\":null,\"historyPriceArea\":null,\"historyTaxPriceArea\":null,\"detailPriceStr\":null,\"detailTaxRateStr\":null,\"detailMnyStr\":null,\"detailTaxPriceStr\":null,\"detailTaxMnyStr\":null,\"detailTaxStr\":null,\"detailArtificialTaxMnyStr\":null,\"detailArtificialMnyStr\":null,\"detailArtificialTaxStr\":null,\"detailArtificialTaxPriceStr\":null,\"detailArtificialPriceStr\":null,\"nodeID\":\"1591061554461335559\",\"parentID\":\"1591061554461335554\",\"shadowId\":\"1591061554461335559\"}]";
        List<JSONObject> data = JSONObject.parseArray(dataJson, JSONObject.class);

        billData.put("detailList", data);
        OutputStream outs = new FileOutputStream(pdfFile);
        Workbook workbook = transformer.transformXLS(is, billData);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);


        Sheet sheet = workbook.getSheetAt(0);
        sheet.setAutobreaks(true);

        autoColumnWidthForChineseChar(sheet, 0, sheet.getRow(0).getLastCellNum(), cellStyle);

        workbook.write(outs);
        /*
        Workbook workbook = transformer.transformXLS(is, billData);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setWrapText(true);

        Sheet sheet = workbook.getSheetAt(0);
        sheet.setAutobreaks(true);
//        sheet.setFitToPage(true);
        autoColumnWidthForChineseChar(sheet, 0, sheet.getRow(0).getLastCellNum());
        workbook.write(outs);
        workbook.close();
        outs.flush();
        outs.close();
         */

//
//
        File pdfF = new File("D:\\test.pdf");
        File excelFile = new File("D:\\testPdf2.xlsx");
        OutputStream outs2 = new FileOutputStream(pdfF);
        InputStream fis= new FileInputStream(excelFile);
        com.aspose.cells.Workbook cellBook = new com.aspose.cells.Workbook(fis);
//
        int[] autoDrawSheets={1};
        autoDraw(cellBook, autoDrawSheets);
//
//        Worksheet worksheet = cellBook.getWorksheets().get(0);
//        Cells cells = worksheet.getCells();
//
//        int maxColumns = cells.getMaxDataColumn();
//        int maxDataRows = cells.getMaxDataRow();
//        System.out.println("maxColumns: " + maxColumns);
//        ColumnCollection cc = cells.getColumns();
//
//        System.out.println("maxDataRows: " + maxDataRows);
//
//
//        for (int col = 0; col < maxColumns; col++)
//        {
//            cells.setColumnWidthPixel(col, cells.getColumnWidthPixel(col) + 30);
//        }
//        for (int col = 0; col < maxDataRows; col++)
//        {
//            worksheet.autoFitRow(col, 0, maxDataRows);
//        }
//        Style cellStyles = cells.getStyle();
//        cellStyles.setVerticalAlignment(TextAlignmentType.CENTER);
//        cellStyles.setHorizontalAlignment(TextAlignmentType.CENTER);
//         全局: 单元格内容: 换行
//        cellStyles.setTextWrapped(true);
//
        PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
        pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);

        cellBook.save(outs2, pdfSaveOptions);
        outs2.flush();
        outs2.close();
        fis.close();
//
//        com.aspose.pdf.Document pdf2 = new com.aspose.pdf.Document(new FileInputStream(pdfF));
//        pdf2.setFitWindow(true);
//        File fitPdf = new File("D:\\fit.pdf");
//        OutputStream outs3 = new FileOutputStream(fitPdf);
//        pdf2.save(outs3);
//
//        tmpFile.delete();
//
//
//        Map<String, Map<String, InputStream>> files = new HashMap<>();
//        Map<String, InputStream> uploadFile = new HashMap<>();
//        uploadFile.put("test.pdf", new FileInputStream(pdfF));
//        files.put("test", uploadFile);
//
//        Map<String, String> fileParams = new HashMap<>();
//        fileParams.put("fileName", "test.pdf");
//        fileParams.put("billType", "testBillType001");
//        fileParams.put("sourceType", "testSourceType001");
//        fileParams.put("sourceId", "456789");
//        System.out.println(JSONObject.toJSONString(fileParams));
//        String fileUploadResp = HttpTookit.postFiles("http://localhost:8080/ejc-file-web/attachment/upload", fileParams, headerMap, files, 10000, 10000);
//        System.out.println(fileUploadResp);



//        com.aspose.pdf.Document pdf1 = new com.aspose.pdf.Document("D:\\test.pdf");
//        com.aspose.pdf.Document pdf2 = new com.aspose.pdf.Document("C:\\Users\\39630\\Desktop\\2.pdf");
//        pdf1.setNonFullScreenPageMode(3);
//        pdf2.getPages().add(pdf1.getPages());
//        pdf2.save();


/*
//        File rs = File.createTempFile("tst", ".pdf");
//        OutputStream ots = new FileOutputStream(rs);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
//        ByteArrayInputStream bis = new ByteArrayInputStream(file2byte(new File("C:\\Users\\39630\\Desktop\\5.pdf")));
        com.aspose.pdf.Document pdf1 = new com.aspose.pdf.Document("D:\\test.pdf");
         com.aspose.pdf.Document pdf2 = new com.aspose.pdf.Document("C:\\Users\\39630\\Desktop\\2.pdf");
         com.aspose.pdf.Document pdf3 = new com.aspose.pdf.Document("C:\\Users\\39630\\Desktop\\6.pdf");
//        List<com.aspose.pdf.Document> l = new ArrayList<>();
//        l.add(new com.aspose.pdf.Document(bis));
        pdf1.getPages().add(pdf2.getPages());
//        bos.flush();
//        bos.close();
//        bis.close();
//        bos.reset();
//        bis = new ByteArrayInputStream(file2byte(new File("C:\\Users\\39630\\Desktop\\6.pdf")));
//        l.add(new com.aspose.pdf.Document(bis));
//        pdf1.getPages().add(l.get(1).getPages());
        pdf1.save();
//        byte2file(bos.toByteArray(), rs.getAbsolutePath());
//        bos.flush();
//        bos.close();
//        bis.close();

//         for(com.aspose.pdf.Document d : l) {
//             d.close();
//         }

//        System.out.println(rs.getAbsolutePath());
 */




    }

    public static File byte2file(byte[] bytes, String fileFullPath) {
        if (bytes == null) {
            return null;
        }
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(fileFullPath);
            //判断文件是否存在
            if (file.exists()) {
                file.mkdirs();
            }
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(bytes);
            return file;
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }  catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return null;
    }

    /**
     * aspose-pdf:21.7 版本有效
     */
    public static void registerPdf_v_21_7() throws Exception {
        Date licenseExpiry = new Date(Long.MAX_VALUE);
        Class<?> l9yClass = Class.forName("com.aspose.pdf.l9y");
        Constructor<?> constructor = l9yClass.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Object l9yInstance = constructor.newInstance();

        // lc
        Field lc = l9yClass.getDeclaredField("lc");
        lc.setAccessible(true);
        lc.set(l9yInstance, licenseExpiry);
        // ly
        Field ly = l9yClass.getDeclaredField("ly");
        ly.setAccessible(true);
        ly.set(l9yInstance, licenseExpiry);

        // l0if
        Field l0if = l9yClass.getDeclaredField("l0if");
        l0if.setAccessible(true);

        Class<?> l9nClass = Class.forName("com.aspose.pdf.l9n");
        Field lfField = l9nClass.getDeclaredField("lf");
        lfField.setAccessible(true);
        Object lf = lfField.get(null); // 处理枚举
        l0if.set(l9yInstance, lf);

        Class<?> l9yLfClass = Class.forName("com.aspose.pdf.l9y$lf");
        Field l9y$lf = l9yLfClass.getDeclaredField("lI");
        l9y$lf.setAccessible(true);
        l9y$lf.set(null, l9yInstance);


        Class<?> l19jClass = Class.forName("com.aspose.pdf.l19j");
        Field l19jlI = l19jClass.getDeclaredField("lI");
        l19jlI.setAccessible(true);
        l19jlI.set(null, 128);
        Field l19jLf = l19jClass.getDeclaredField("lf");
        l19jLf.setAccessible(true);
        l19jLf.set(null, false);
    }

    /**
     * @param wb 设置打印的sheet自动拉伸比例
     * @param page 自动拉伸的页的sheet数组
     */
    public static void autoDraw(com.aspose.cells.Workbook wb, int[] page){
        if (null!=page&&page.length>0){
            for (int i = 0; i < page.length; i++) {
                wb.getWorksheets().get(i).getHorizontalPageBreaks().clear();
                wb.getWorksheets().get(i).getVerticalPageBreaks().clear();
            }
        }
    }

    //str 是单元格需要放入的 字符串 fontCountInline 是该单元格每行多少个汉字 全角为1 英文或符号为0.5
    public static float getExcelCellAutoHeight(String str, float fontCountInline) {
        float defaultRowHeight = 12.00f;//每一行的高度指定
        float defaultCount = 0.00f;
        for (int i = 0; i < str.length(); i++) {
            float ff = getregex(str.substring(i, i + 1));
            defaultCount = defaultCount + ff;
        }
        return ((int) (defaultCount / fontCountInline) + 1) * defaultRowHeight;//计算
    }

    public static float getregex(String charStr) {

        if(charStr==" ")
        {
            return 0.5f;
        }
        // 判断是否为字母或字符
        if (Pattern.compile("^[A-Za-z0-9]+$").matcher(charStr).matches()) {
            return 0.5f;
        }
        // 判断是否为全角
        if (Pattern.compile("[\u4e00-\u9fa5]+$").matcher(charStr).matches()) {
            return 1.00f;
        }
        //全角符号 及中文
        if (Pattern.compile("[^x00-xff]").matcher(charStr).matches()) {
            return 1.00f;
        }
        return 0.5f;
    }

    /**
     * 自动调整列表宽度适应中文字符串
     * @param sheet
     * @param startColumnNum 要调整的起始列表号
     * @param size  要调整的列表数量
     */
    public static void autoColumnWidthForChineseChar(Sheet sheet, int startColumnNum, int size, CellStyle defaultCellStyle) {
        final int oneLineHeight = 10 * 20;
        final int twentyWordsColumnWidth = 20 * 256 * 3; //单元格每行最多45个字
        final int fortyFiveWordsColumnWidth = 45 * 256 * 3; //单元格每行最多45个字
        final int sixtyWordsColumnWidth = 60 * 256 * 3; //单元格每行最多60个字
        int actualColWith = twentyWordsColumnWidth; //默认 单元格每行20个字
        Integer rowContentMaxHeight = 1, curCellContentHeight = 1;
        Map<Integer, Integer> colMaxWidth = new HashMap<>();
        CellStyle cellStyle = null;
        for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); rowNum++) {
            Row currentRow;

            if (rowNum < 1 || sheet.getRow(rowNum) == null) {
                continue;
            } else {
                currentRow = sheet.getRow(rowNum);
            }

            rowContentMaxHeight = 1;

            for (int columnNum = 0; columnNum < size; columnNum++) {
                /** 调整每一列宽度 */
                sheet.autoSizeColumn(columnNum);
                /** 获取列宽 */
                final int columnWidth = sheet.getColumnWidth(columnNum);
                /** 新的列宽 */
                int newWidth = columnWidth;
                short newHeight = 0;
                actualColWith = twentyWordsColumnWidth;
                curCellContentHeight = 1;
                if (currentRow.getCell(columnNum) != null) {
                    Cell currentCell = currentRow.getCell(columnNum);
                    String value = getCellContentAsString(currentCell);
                    System.out.println(rowNum + "行列内容：" + value);
                    /** 计算字符串中中文字符的数量 */
                    int count = chineseCharCountOf(value);
                    if((rowNum == 1) && (value.indexOf("（") > -1)) {
                        count+=2;
                    }
                    /**在该列字符长度的基础上加上汉字个数计算列宽 */
                    newWidth = value.length()*256+count*256*2;

                   //设置列换行
                   cellStyle = currentCell.getCellStyle();
                   if(null == cellStyle) {
                       currentCell.setCellStyle(defaultCellStyle);
                   } else {
                       cellStyle.setWrapText(true);
                       currentCell.setCellStyle(cellStyle);
                   }

                }

                if(newWidth > columnWidth){
                    if(newWidth > actualColWith) {
                        if(Math.ceil(Double.valueOf(newWidth) / actualColWith) > 30) {
                            if(Math.ceil(Double.valueOf(newWidth) / fortyFiveWordsColumnWidth) <= 30) {
                                actualColWith = fortyFiveWordsColumnWidth;
                            } else {
                                actualColWith = sixtyWordsColumnWidth;
                            }
                        }

                        curCellContentHeight = Double.valueOf(Math.ceil(Double.valueOf(newWidth) / actualColWith)).intValue();
                        if(curCellContentHeight > rowContentMaxHeight) {
                            rowContentMaxHeight = curCellContentHeight;
                        }
                    }
                    if(null == colMaxWidth.get(columnNum)) {
                        colMaxWidth.put(columnNum, 0);
                    }
                    newWidth = newWidth > actualColWith ? actualColWith + 80 : newWidth + 80;
                    if(newWidth > colMaxWidth.get(columnNum)) {
                        colMaxWidth.put(columnNum, newWidth);
                    }
                    sheet.setColumnWidth(columnNum, newWidth);
                } else {
                    if(null != colMaxWidth.get(columnNum)) {
                        sheet.setColumnWidth(columnNum, colMaxWidth.get(columnNum));
                    }
                }
            }

            if(rowNum == 1) {
                currentRow.setHeight(Double.valueOf(oneLineHeight * rowContentMaxHeight * 2).shortValue());
            } else {
                currentRow.setHeight(Double.valueOf(oneLineHeight * (rowContentMaxHeight == 1 ? 2 : rowContentMaxHeight * 1.3)).shortValue());
            }
        }


    }

    /**
     * 解析一个单元格得到数据
     * @param cell
     * @return
     */
    private static String getCellContentAsString(Cell cell) {
        if(null == cell){
            return "";
        }
        String result = "";
        switch (cell.getCellType()) {
            case Cell.CELL_TYPE_NUMERIC:
                String s = String.valueOf(cell.getNumericCellValue());
                if (s != null) {
                    if (s.endsWith(".0")) {
                        s = s.substring(0, s.length() - 2);
                    }
                }
                result = s;
                break;
            case Cell.CELL_TYPE_STRING:
                result = null != cell.getStringCellValue() ? String.valueOf(cell.getStringCellValue()).trim() : "";
                break;
            case Cell.CELL_TYPE_BLANK:
                break;
            case Cell.CELL_TYPE_BOOLEAN:
                result = String.valueOf(cell.getBooleanCellValue());
                break;
            case Cell.CELL_TYPE_ERROR:
                break;
            default:
                break;
        }
        return result;
    }

    /**
     * 计算字符串中中文字符的数量
     * 参见 <a hrft="https://www.cnblogs.com/straybirds/p/6392306.html">《汉字unicode编码范围》</a>
     * @param input
     * @return
     */
    private static int chineseCharCountOf(String input){
        int count = 0;//汉字数量
        if(null != input){
            String regEx = "[\\u4e00-\\u9fa5]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(input);
            int len = m.groupCount();
            //获取汉字个数
            while (m.find()) {
                for (int i = 0; i <= len; i++) {
                    count = count + 1;
                }
            }
        }
        return count;
    }

}
