package com.ejianc.business.xmgs.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.xmgs.bean.WorkTimeDetailEntity;
import com.ejianc.business.xmgs.bean.ProjectEntity;
/**
 * 工时管理
 *
 * @author generator
 *
 */
 @TableName("ejc_xmgs_work_time")
public class WorkTimeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="fill_id")
    private Long fillId; // 填报人主键
    @TableField(value="fill_name")
    private String fillName; // 填报人名称
    @TableField(value="total_work_time")
    private BigDecimal totalWorkTime; // 工时合计
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="date")
    private Date date; // 日期
    @TableField(value="bill_state")
    private Integer billState; // 审批状态
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="phone")
    private Long phone; // 手机号
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="ext_total_work_time")
    private BigDecimal extTotalWorkTime; // 额外工时合计


    @TableField(exist=false)
    @SubEntity(serviceName="workTimeDetailService",pidName = "wtId")
    private List<WorkTimeDetailEntity> workTimeDetailList = new ArrayList<>(); // 工时管理明细


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getFillId() {
        return fillId;
    }

    public void setFillId(Long fillId) {
        this.fillId = fillId;
    }
    public String getFillName() {
        return fillName;
    }

    public void setFillName(String fillName) {
        this.fillName = fillName;
    }
    public BigDecimal getTotalWorkTime() {
        return totalWorkTime;
    }

    public void setTotalWorkTime(BigDecimal totalWorkTime) {
        this.totalWorkTime = totalWorkTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getPhone() {
        return phone;
    }

    public void setPhone(Long phone) {
        this.phone = phone;
    }


    public List<WorkTimeDetailEntity> getWorkTimeDetailList() {
        return workTimeDetailList;
    }

    public void setWorkTimeDetailList(List<WorkTimeDetailEntity> workTimeDetailList) {
        this.workTimeDetailList = workTimeDetailList;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BigDecimal getExtTotalWorkTime() {
        return extTotalWorkTime;
    }

    public void setExtTotalWorkTime(BigDecimal extTotalWorkTime) {
        this.extTotalWorkTime = extTotalWorkTime;
    }
}
