package com.ejianc.business.xmgs.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.xmgs.bean.WorkTimeEntity;
import com.ejianc.business.xmgs.service.IWorkTimeService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 工时管理提醒
 *
 * @author generator
 */
@Controller
@RequestMapping("warn")
public class WorkTimeWarnController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IWorkTimeService workTimeService;

    /**
     * 微信消息模版ID
     */
    private static final String WX_MSG_ID = "Do0q1JoHifdeXqX1-hty6DjsDY0ZNgD3GRVkFEx5jBI";

    /**
     * 需提醒的默认角色id  生产环境固定id
     */
    private static final Long WARE_ROLE_ID = 597490353083945018L;

    @Value("${common.env.base-host}")
    private String baseHost;

    /**
     * @Description queryDetail 提醒全部人员
     */
    @RequestMapping(value = "/warnAll", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> warnAll(HttpServletRequest request) {

        List<Long> roleIdS = new ArrayList<>();

        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("获取到的参数JSON是：" + param + "----");
        String roleId = null;
        if (json!=null){
            roleId= json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getString("value");
        }

        logger.info("获取到的参数是：" + roleId + "----");
        if (StringUtils.isNotBlank(roleId)) {
            roleIdS.add(Long.valueOf(roleId));
        } else {
            roleIdS.add(WARE_ROLE_ID);
        }

        List<RoleUserRelationVO> roleUserRelationVO = roleApi.getRoleUser(roleIdS, null).getData();

        if (roleUserRelationVO == null || roleUserRelationVO.size() <= 0) {
            logger.info("发送消息完成,对应角色下无人员");
            return CommonResponse.success("发送消息完成,对应角色下无人员");
        }

        List<String> receivers = new ArrayList<>();
        for (RoleUserRelationVO vo : roleUserRelationVO) {
            receivers.add(String.valueOf(vo.getUserId()));
        }

        String subject = "小伙伴们，辛苦了一天，及时总结一下吧^_^";
        String content = subject + "。<a href=" + '"' + getPcUrl() + '"' + ">前往点击</a>";

        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        // 系统消息
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        // 微信公众号消息
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEIXIN);
        JSONObject weixinParams = new JSONObject();
        weixinParams.put("template_id", WX_MSG_ID);
        JSONObject wxparams = new JSONObject();
        wxparams.put("first", subject);
        wxparams.put("keyword1", "工时填报");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        wxparams.put("keyword2", formatter.format(new Date()));
        wxparams.put("remark", "点击我，快速去填报工时！");
        weixinParams.put("data", wxparams);
        weixinParams.put("url", (getMbUrl() + "?openid={openid}"));

        parameter.setWeixinParams(weixinParams);

        parameter.setReceivers(receivers.toArray(new String[receivers.size()]));// 收信人

        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("task");
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setPcUrl(getPcUrl());//
        parameter.setMobileUrl(getMbUrl());//
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse<String> result = pushMessageApi.pushNoAuthMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }

        return CommonResponse.success("发送消息成功");
    }


    /**
     * 昨日工时未填报提醒
     */
    @RequestMapping(value = "/warnSomeUser", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> warnSomeUser(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("获取到的参数JSON是：" + param + "----");
        String userIdsParam = null;
        if (json!=null){
            userIdsParam = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getString("value");
        }

        logger.info("获取到的参数是：" + userIdsParam + "----");

        if (StringUtils.isBlank(userIdsParam)) {
            return CommonResponse.success("未配置提醒人员ID！");
        }

        String[] userIdList = userIdsParam.split (",");
        List<String> receivers = Lists.newArrayList(userIdList);
        List<Long> fillIds = receivers.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());

        LambdaQueryWrapper<WorkTimeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(WorkTimeEntity ::getFillId, fillIds);
        queryWrapper.apply(" DATE_FORMAT( date, '%Y-%m-%d' ) = DATE_FORMAT( DATE_SUB( NOW(), INTERVAL 1 DAY ), '%Y-%m-%d' ) ");
        List<WorkTimeEntity> list = workTimeService.list(queryWrapper);


        if(CollectionUtils.isNotEmpty(list)){
            List<String> fillReceivers = list.stream().map(s -> String.valueOf(s.getFillId())).collect(Collectors.toList());
            receivers.removeAll(fillReceivers);
            logger.info("昨日工时已填报:{}", JSONObject.toJSONString(fillReceivers));
        }

        if(CollectionUtils.isEmpty(receivers)){
            return CommonResponse.success("昨日工时都已填报！");
        }

        String subject = "同学，你昨天的工时没有填哦，块去提填写一下吧^_^";
        String content = subject + "。<a href=" + '"' + getPcUrl() + '"' + ">前往点击</a>";

        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        // 系统消息
        channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        // 微信公众号消息
        channel.add(PushMsgParameter.CHANNEL_TYPE_WEIXIN);
        JSONObject weixinParams = new JSONObject();
        weixinParams.put("template_id", WX_MSG_ID);
        JSONObject wxparams = new JSONObject();
        wxparams.put("first", subject);
        wxparams.put("keyword1", "昨日工时漏填提醒");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        wxparams.put("keyword2", formatter.format(new Date()));
        wxparams.put("remark", "点击我，快速去填报工时！");
        weixinParams.put("data", wxparams);
        weixinParams.put("url", (getMbUrl() + "?openid={openid}"));

        parameter.setWeixinParams(weixinParams);

        parameter.setReceivers(receivers.toArray(new String[receivers.size()]));// 收信人

        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType("task");
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setPcUrl(getPcUrl());//
        parameter.setMobileUrl(getMbUrl());//
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse<String> result = pushMessageApi.pushNoAuthMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }

        return CommonResponse.success("发送消息成功");
    }

    private String getPcUrl() {
        return baseHost + "ejc-xmgs-frontend/#/workTime";
    }

    private String getMbUrl() {
        return baseHost + "ejc-xmgs-mobile/#/workTime";
    }


}
