package com.ejianc.sxjg.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.sxjg.bean.FeeCostSubEntity;
import com.ejianc.sxjg.bean.FeeCostByjEntity;
/**
 * 通用费用报销单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_yanshi_cost")
public class FeeCostEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0 自由态，1 已提交，2审批中，3 审批通过，4 驳回，5 提交后有人审批中
    @TableField(value="person_id")
    private Long personId; // 报销人
    @TableField(value="orgId")
    private Long orgid; // 报销组织
    @TableField(value="work_num")
    private String workNum; // 工号
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 报销金额
    @TableField(value="fee_type")
    private String feeType; // 费用类别
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="feeCostSubService", pidName="pid")//此处有pid="xxx"，默认值pid="pid"
    private List<FeeCostSubEntity> feeCostSubList = new ArrayList<>(); // 费用信息
    @TableField(exist=false)
    @SubEntity(serviceName="feeCostByjService", pidName="pid")//此处有pid="xxx"，默认值pid="pid"
    private List<FeeCostByjEntity> feeCostByjList = new ArrayList<>(); // 备用金
    

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public Long getOrgid() {
        return orgid;
    }

    public void setOrgid(Long orgid) {
        this.orgid = orgid;
    }
    public String getWorkNum() {
        return workNum;
    }

    public void setWorkNum(String workNum) {
        this.workNum = workNum;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }
    
    public List<FeeCostSubEntity> getFeeCostSubList() {
        return feeCostSubList;
    }

    public void setFeeCostSubList(List<FeeCostSubEntity> feeCostSubList) {
        this.feeCostSubList = feeCostSubList;
    }
    public List<FeeCostByjEntity> getFeeCostByjList() {
        return feeCostByjList;
    }

    public void setFeeCostByjList(List<FeeCostByjEntity> feeCostByjList) {
        this.feeCostByjList = feeCostByjList;
    }
}
