package com.ejianc.business.zdkcg.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdkcg.bean.ApplyEntity;
import com.ejianc.business.zdkcg.service.IApplyService;
import com.ejianc.business.zdkcg.vo.ApplyVO;
import com.ejianc.business.zdkcg.vo.PurchaseVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;
import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 采购申请实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("apply")
public class ApplyController implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EJC_ZDKCG_APPLY_BILL_CODE = "EJC_ZDKCG_APPLY";

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IApplyService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO saveorUpdateVO) {
        ApplyEntity entity = BeanMapper.map(saveorUpdateVO, ApplyEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(EJC_ZDKCG_APPLY_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(Long id) {
        ApplyEntity entity = service.selectById(id);
        ApplyVO vo = BeanMapper.map(entity, ApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        service.removeByIds(vos.stream().map(ApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgAgencyName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ApplyEntity> page = service.queryPage(param, false);
        IPage<ApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgAgencyName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<ApplyEntity> pageData = service.queryPage(param, false);
        List<ApplyVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), ApplyVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if (vo.getPurchaseType() == 0) {
                    vo.setPurchaseTypeName("生产科研类");
                }
                if (vo.getPurchaseType() == 1) {
                    vo.setPurchaseTypeName("固定资产投资类");
                }
                if (vo.getPurchaseType() == 2) {
                    vo.setPurchaseTypeName("企业经营消耗类");
                }
                if (vo.getPurchaseType() == 3) {
                    vo.setPurchaseTypeName("科研外协外包");
                }
                //招采方式:0-商城采购、1-招标采购
                if (vo.getInvitationType() == 0) {
                    vo.setInvitationTypeName("商城采购");
                }
                if (vo.getInvitationType() == 1) {
                    vo.setInvitationTypeName("招标采购");
                }
            });

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("applyExport.xlsx", beans, response);
    }

    /**
     * 采购合同申请列表参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/applyRef")
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> applyRef(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                   @RequestParam(defaultValue = "10") Integer pageSize,
                                                   @RequestParam(value = "condition", required = false) String condition,
                                                   @RequestParam(value = "searchText", required = false) String searchText) {

        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("orgName");
        queryParam.getFuzzyFields().add("orgAgencyName");
        List<Integer> billstate = new ArrayList<>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("create_time", QueryParam.DESC);
        IPage<ApplyEntity> pageData = service.queryPage(queryParam, false);
        List<ApplyVO> list = new ArrayList<>();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), ApplyVO.class);
            list.forEach(vo -> {
                if (vo.getPurchaseType() == 0) {
                    vo.setPurchaseTypeName("生产科研类");
                }
                if (vo.getPurchaseType() == 1) {
                    vo.setPurchaseTypeName("固定资产投资类");
                }
                if (vo.getPurchaseType() == 2) {
                    vo.setPurchaseTypeName("企业经营消耗类");
                }
                if (vo.getPurchaseType() == 3) {
                    vo.setPurchaseTypeName("科研外协外包");
                }
                //招采方式:0-商城采购、1-招标采购
                if (vo.getInvitationType() == 0) {
                    vo.setInvitationTypeName("商城采购");
                }
                if (vo.getInvitationType() == 1) {
                    vo.setInvitationTypeName("招标采购");
                }
            });

        }

        IPage<ApplyVO> result = new com.baomidou.mybatisplus.extension.plugins.pagination.Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(list);
        return CommonResponse.success("采购申请参照查询成功！", result);
    }
    /**
     * @Description queryList 报表查询
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDataList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryDataList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<PurchaseVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PurchaseVO> list = service.queryDataList(page,wrapper);
        for (PurchaseVO purchaseVO : list){
            if (purchaseVO.getsMoney() != null && purchaseVO.getsZbMoney() != null && !purchaseVO.getsMoney().equals(BigDecimal.ZERO)){
                purchaseVO.setsRate(new BigDecimal(100).multiply((purchaseVO.getsMoney().subtract(purchaseVO.getsZbMoney())).divide(purchaseVO.getsMoney(),8,ROUND_HALF_DOWN)));
            }
            if (purchaseVO.getsMoney() != null){
                purchaseVO.setsMoney(purchaseVO.getsMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getsZbMoney() != null){
                purchaseVO.setsZbMoney(purchaseVO.getsZbMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getgMoney() != null && purchaseVO.getgZbMoney() != null && !purchaseVO.getgMoney().equals(BigDecimal.ZERO)){
                purchaseVO.setgRate(new BigDecimal(100).multiply((purchaseVO.getgMoney().subtract(purchaseVO.getgZbMoney())).divide(purchaseVO.getgMoney(),8,ROUND_HALF_DOWN)));
            }
            if (purchaseVO.getgMoney() != null){
                purchaseVO.setgMoney(purchaseVO.getgMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getgZbMoney() != null){
                purchaseVO.setgZbMoney(purchaseVO.getgZbMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }

            if (purchaseVO.getqMoney() != null && purchaseVO.getqZbMoney() != null && !purchaseVO.getqMoney().equals(BigDecimal.ZERO)){
                purchaseVO.setqRate(new BigDecimal(100).multiply((purchaseVO.getqMoney().subtract(purchaseVO.getqZbMoney())).divide(purchaseVO.getqMoney(),8,ROUND_HALF_DOWN)));
            }
            if (purchaseVO.getqMoney() != null){
                purchaseVO.setqMoney(purchaseVO.getqMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getqZbMoney() != null){
                purchaseVO.setqZbMoney(purchaseVO.getqZbMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }

            if (purchaseVO.getcMoney() != null && purchaseVO.getcZbMoney() != null && !purchaseVO.getcMoney().equals(BigDecimal.ZERO)){
                purchaseVO.setcRate(new BigDecimal(100).multiply((purchaseVO.getcMoney().subtract(purchaseVO.getcZbMoney())).divide(purchaseVO.getcMoney(),8,ROUND_HALF_DOWN)));
            }
            if (purchaseVO.getcMoney() != null){
                purchaseVO.setcMoney(purchaseVO.getcMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getcZbMoney() != null){
                purchaseVO.setcZbMoney(purchaseVO.getcZbMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    @RequestMapping(value = "/excelAnalysisExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelDataExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<PurchaseVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PurchaseVO> list = service.queryDataList(page,wrapper);
        for (PurchaseVO purchaseVO : list){
            if (purchaseVO.getsMoney() != null && purchaseVO.getsZbMoney() != null && !purchaseVO.getsMoney().equals(BigDecimal.ZERO)){
                purchaseVO.setsRate(new BigDecimal(100).multiply((purchaseVO.getsMoney().subtract(purchaseVO.getsZbMoney())).divide(purchaseVO.getsMoney(),8,ROUND_HALF_DOWN)));
            }
            if (purchaseVO.getsMoney() != null){
                purchaseVO.setsMoney(purchaseVO.getsMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getsZbMoney() != null){
                purchaseVO.setsZbMoney(purchaseVO.getsZbMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getgMoney() != null && purchaseVO.getgZbMoney() != null && !purchaseVO.getgMoney().equals(BigDecimal.ZERO)){
                purchaseVO.setgRate(new BigDecimal(100).multiply((purchaseVO.getgMoney().subtract(purchaseVO.getgZbMoney())).divide(purchaseVO.getgMoney(),8,ROUND_HALF_DOWN)));
            }
            if (purchaseVO.getgMoney() != null){
                purchaseVO.setgMoney(purchaseVO.getgMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getgZbMoney() != null){
                purchaseVO.setgZbMoney(purchaseVO.getgZbMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }

            if (purchaseVO.getqMoney() != null && purchaseVO.getqZbMoney() != null && !purchaseVO.getqMoney().equals(BigDecimal.ZERO)){
                purchaseVO.setqRate(new BigDecimal(100).multiply((purchaseVO.getqMoney().subtract(purchaseVO.getqZbMoney())).divide(purchaseVO.getqMoney(),8,ROUND_HALF_DOWN)));
            }
            if (purchaseVO.getqMoney() != null){
                purchaseVO.setqMoney(purchaseVO.getqMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getqZbMoney() != null){
                purchaseVO.setqZbMoney(purchaseVO.getqZbMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }

            if (purchaseVO.getcMoney() != null && purchaseVO.getcZbMoney() != null && !purchaseVO.getcMoney().equals(BigDecimal.ZERO)){
                purchaseVO.setcRate(new BigDecimal(100).multiply((purchaseVO.getcMoney().subtract(purchaseVO.getcZbMoney())).divide(purchaseVO.getcMoney(),8,ROUND_HALF_DOWN)));
            }
            if (purchaseVO.getcMoney() != null){
                purchaseVO.setcMoney(purchaseVO.getcMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
            if (purchaseVO.getcZbMoney() != null){
                purchaseVO.setcZbMoney(purchaseVO.getcZbMoney().divide(new BigDecimal(10000),8,ROUND_HALF_DOWN));
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("analysisExport.xlsx", beans, response);
    }
}
