package com.ejianc.business.zdkcg.controller;

import java.io.Serializable;

import com.ejianc.business.zdkcg.bean.ApplyEntity;
import com.ejianc.business.zdkcg.service.IApplyService;
import com.ejianc.business.zdkcg.vo.TenderDetailVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdkcg.bean.TenderEntity;
import com.ejianc.business.zdkcg.service.ITenderService;
import com.ejianc.business.zdkcg.vo.TenderVO;

/**
 * 招标定标
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("tender")
public class TenderController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ITenderService service;

    @Autowired
    private IApplyService applyService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<TenderVO> saveOrUpdate(@RequestBody TenderVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TenderVO> queryDetail(Long id) {
    	TenderEntity entity = service.selectById(id);
    	TenderVO vo = BeanMapper.map(entity, TenderVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询复制申请单详情
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<TenderVO> queryCopyDetail(Long id) {
        ApplyEntity applyEntity = applyService.selectById(id);
        TenderVO vo = BeanMapper.map(applyEntity, TenderVO.class);
        vo.setApplyId(applyEntity.getId());
        vo.setApplyCode(applyEntity.getBillCode());
        vo.setId(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBillState(0);
        vo.setBillCode(null);
        vo.setMemo(null);

        List<TenderDetailVO> tenderDetail = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(applyEntity.getApplyDetail())){
            tenderDetail = BeanMapper.mapList(applyEntity.getApplyDetail(), TenderDetailVO.class);
            tenderDetail.forEach(e->{
                e.setApplyDetailId(e.getId());
                e.setRowState("add");
            });
            vo.setTenderDetail(tenderDetail);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TenderVO> vos) {
        service.removeByIds(vos.stream().map(TenderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TenderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.setFuzzyFields(Arrays.asList("billCode", "projectName", "orgAgencyName", "orgName", "supplierName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<TenderEntity> page = service.queryPage(param,false);
        IPage<TenderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), TenderVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
