package com.ejianc.business.zdkcg.controller;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdkcg.bean.WebsiteHelpEntity;
import com.ejianc.business.zdkcg.service.IWebsiteHelpService;
import com.ejianc.business.zdkcg.vo.WebsiteHelpVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;

/**
 * 
 * @author 
 * 
 */
@Controller
@RequestMapping("help")
public class WebsiteHelpController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IWebsiteHelpService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WebsiteHelpVO> saveOrUpdate(@RequestBody WebsiteHelpVO saveorUpdateVO) {
    	return service.saveData(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WebsiteHelpVO> queryDetail(Long id) {
    	WebsiteHelpEntity entity = service.selectById(id);
    	WebsiteHelpVO vo = BeanMapper.map(entity, WebsiteHelpVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WebsiteHelpVO> vos) {
        service.removeByIds(vos.stream().map(WebsiteHelpVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WebsiteHelpVO>> queryList(@RequestBody QueryParam param) {
    	LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
    	orderMap.put("topFlag", "desc");
    	orderMap.put("createTime", "desc");
    	param.setOrderMap(orderMap);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<WebsiteHelpEntity> page = service.queryPage(param,false);
        IPage<WebsiteHelpVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WebsiteHelpVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


	/**
	 * 改变状态信息（是否发布/是否置顶/是否加入轮播）
	 * 
	 * @param orgVO
	 * @return
	 */
	@RequestMapping(value = "/change", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> change(@RequestParam Long id,@RequestParam Integer newState, @RequestParam String field) {
		String msg = "";
    	WebsiteHelpEntity entity = service.selectById(id);
		if(field.equals("publishFlag")){
			if(newState==1){
				msg = "发布";
				entity.setOrgId(InvocationInfoProxy.getOrgId());
				entity.setPublishTime(new Date());
				try {
					JSONArray jArray = ReferObjectUtil.getReferEntityValue(InvocationInfoProxy.getUserid().toString(), "idm-user");
					if(jArray!=null&&jArray.size()>0){
						JSONObject json = (JSONObject) jArray.get(0);
						entity.setPublisher(json.get("name").toString());
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}else{
				msg = "取消发布";
				entity.setPublishTime(null);
				entity.setPublisher(null);
				entity.setOrgId(null);
			}
			entity.setPublishFlag(newState);
		}else if(field.equals("topFlag")){
			if(newState==1){
				msg = "置顶";
			}else{
				msg = "取消置顶";
			}
			entity.setTopFlag(newState);
		}
		service.saveOrUpdate(entity, false);
		return CommonResponse.success(msg+"成功");
	}
}
