package com.ejianc.business.zdkcg.controller;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdkcg.bean.WebsiteNewsEntity;
import com.ejianc.business.zdkcg.service.IWebsiteNewsService;
import com.ejianc.business.zdkcg.vo.WebsiteNewsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 
 * @author 
 * 
 */
@Controller
@RequestMapping("news")
public class WebsiteNewsController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IWebsiteNewsService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WebsiteNewsVO> saveOrUpdate(@RequestBody WebsiteNewsVO saveorUpdateVO) {
    	
    	return service.saveData(saveorUpdateVO);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WebsiteNewsVO> queryDetail(Long id) {
    	WebsiteNewsEntity entity = service.selectById(id);
    	WebsiteNewsVO vo = BeanMapper.map(entity, WebsiteNewsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WebsiteNewsVO> vos) {
        service.removeByIds(vos.stream().map(WebsiteNewsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WebsiteNewsVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("author");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<WebsiteNewsEntity> page = service.queryPage(param,false);
        IPage<WebsiteNewsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        page.getRecords().forEach(e -> {
        	e.setContent(null);
        });
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WebsiteNewsVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

	/**
	 * 改变状态信息（是否发布/是否上架
	 * 
	 * @param orgVO
	 * @return
	 */
	@RequestMapping(value = "/change", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> change(@RequestParam Long id,@RequestParam Integer newState, @RequestParam String field) {
		String msg = "";
    	WebsiteNewsEntity entity = service.selectById(id);
		if(field.equals("shelvesFlag")){
			if(newState==1){
				msg = "上架";
				if(!(entity.getBillState()==1||entity.getBillState()==3)){
					//审批通过的才能上架
					return CommonResponse.error("未审批通过不能上架");
				}
			}else{
				msg = "下架";
			}
			entity.setShelvesFlag(newState);
		}else if(field.equals("topFlag")){
			if(newState==1){
				msg = "置顶";
			}else{
				msg = "取消置顶";
			}
			entity.setTopFlag(newState);
		}
		service.saveOrUpdate(entity, false);
		return CommonResponse.success(msg+"成功");
	}

	/**
	 * 角色参照
	 * 
	 * @param condition
	 * @param searchText
	 * @param pageSize
	 * @param pageNumber
	 * @return
	 */
	@GetMapping(value = "/newsReferList")
	@ResponseBody
	public CommonResponse<IPage<WebsiteNewsVO>> newsReferList(@RequestParam(required = false) String condition,
													   @RequestParam(required = false) String searchText,
													   @RequestParam(required = true) int pageSize,
													   @RequestParam(required = true) int pageNumber,
													   @RequestParam(required=false) String relyCondition,
														@RequestParam(required=false) String searchObject) {
		QueryParam queryParam = new QueryParam();
		if(StringUtils.isNotBlank(searchText)){
			queryParam.setSearchText(searchText);
		}
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("title");
        fuzzyFields.add("author");
    	if(StringUtils.isNotBlank(searchObject)){
    		JSONObject search = JSONObject.parseObject(searchObject);
    		if(search.get("title")!=null){
    			queryParam.getParams().put("title", new Parameter(QueryParam.LIKE, search.get("title").toString()));
    		}
    		if(search.get("author")!=null){
    			queryParam.getParams().put("author", new Parameter(QueryParam.LIKE, search.get("author").toString()));
    		}
    	}
		if(condition!=null){
			JSONObject cond = JSONObject.parseObject(condition);
			if(cond.get("type")!=null){
				queryParam.getParams().put("type", new Parameter(QueryParam.LIKE, cond.get("type").toString()));
			}
		}
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		IPage<WebsiteNewsEntity> ePage = service.queryPage(queryParam, false);
		IPage<WebsiteNewsVO> pageData = new Page<>(ePage.getCurrent(), ePage.getSize(), ePage.getTotal());
		pageData.setRecords(BeanMapper.mapList(ePage.getRecords(), WebsiteNewsVO.class));
		return CommonResponse.success("查询咨询信息成功！", pageData);
	}
}
