package com.ejianc.business.zdkcg.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.zdkcg.vo.TenderVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdkcg.mapper.TenderMapper;
import com.ejianc.business.zdkcg.bean.TenderEntity;
import com.ejianc.business.zdkcg.service.ITenderService;

/**
 * 招标定标
 * 
 * @author generator
 * 
 */
@Service("tenderService")
public class TenderServiceImpl extends BaseServiceImpl<TenderMapper, TenderEntity> implements ITenderService{
    private static final String EJC_ZDKCG_TENDER = "EJC_ZDKCG_TENDER";
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Override
    public TenderVO saveOrUpdate(TenderVO saveorUpdateVO) {
        TenderEntity entity = BeanMapper.map(saveorUpdateVO, TenderEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(EJC_ZDKCG_TENDER, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        TenderVO resVo =  BeanMapper.map(entity, TenderVO.class);
        return resVo;
    }
}
