package com.ejianc.business.zdkcg.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;

import com.ejianc.business.zdkcg.mapper.WebsiteCarouselMapper;
import com.ejianc.business.zdkcg.bean.WebsiteCarouselEntity;
import com.ejianc.business.zdkcg.service.IWebsiteCarouselService;
import com.ejianc.business.zdkcg.vo.WebsiteCarouselVO;
import com.ejianc.foundation.file.api.IAttachmentApi;

/**
 * 
 * @author 
 * 
 */
@Service("websiteCarouselService")
public class WebsiteCarouselServiceImpl extends BaseServiceImpl<WebsiteCarouselMapper, WebsiteCarouselEntity> implements IWebsiteCarouselService{

	@Autowired
	private IAttachmentApi attachmentApi;
	
	@Override
	public CommonResponse<WebsiteCarouselVO> saveData(WebsiteCarouselVO websiteCarouselVO) {
		if(websiteCarouselVO.getId()!=null){
			//保存
			WebsiteCarouselEntity oldEntity = this.selectById(websiteCarouselVO.getId());
			if(StringUtils.isNotBlank(oldEntity.getCarouselPic())){
				if(StringUtils.isNotBlank(websiteCarouselVO.getCarouselPic())){
					if(!oldEntity.getCarouselPic().equals(websiteCarouselVO.getCarouselPic())){
						//删除原先的轮播图
						if(StringUtils.isNotBlank(oldEntity.getCarouselPic())){
							String id = oldEntity.getCarouselPic().split("=")[1];
							if(StringUtils.isNotBlank(id)){
								attachmentApi.delete(id);
							}
						}
						//绑定新的轮播图
						if(StringUtils.isNotBlank(websiteCarouselVO.getCarouselPic())){
							String id = websiteCarouselVO.getCarouselPic().split("=")[1];
							if(StringUtils.isNotBlank(id)){
								List<Long> attachIds = new ArrayList<>();
								attachIds.add(Long.parseLong(id));
								attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
							}
						}
					}
					
				}else{
					//删除原先的轮播图
					if(StringUtils.isNotBlank(oldEntity.getCarouselPic())){
						String id = oldEntity.getCarouselPic().split("=")[1];
						if(StringUtils.isNotBlank(id)){
							attachmentApi.delete(id);
						}
					}
				}
			}else{
				if(StringUtils.isNotBlank(websiteCarouselVO.getCarouselPic())){
					//绑定新的轮播图
					String id = websiteCarouselVO.getCarouselPic().split("=")[1];
					if(StringUtils.isNotBlank(id)){
						List<Long> attachIds = new ArrayList<>();
						attachIds.add(Long.parseLong(id));
						attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
					}
				}
			}
		}
    	WebsiteCarouselEntity entity = BeanMapper.map(websiteCarouselVO, WebsiteCarouselEntity.class);
    	this.saveOrUpdate(entity, false);
    	WebsiteCarouselVO vo = BeanMapper.map(entity, WebsiteCarouselVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
	}
    
}
