package com.ejianc.business.zdkcg.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;

import com.ejianc.business.zdkcg.mapper.WebsiteHelpMapper;
import com.ejianc.business.zdkcg.bean.WebsiteHelpEntity;
import com.ejianc.business.zdkcg.bean.WebsiteNewsEntity;
import com.ejianc.business.zdkcg.service.IWebsiteHelpService;
import com.ejianc.business.zdkcg.vo.WebsiteHelpVO;
import com.ejianc.foundation.file.api.IAttachmentApi;

/**
 * 
 * @author 
 * 
 */
@Service("websiteHelpService")
public class WebsiteHelpServiceImpl extends BaseServiceImpl<WebsiteHelpMapper, WebsiteHelpEntity> implements IWebsiteHelpService{

	@Autowired
	private IAttachmentApi attachmentApi;
	
	@Override
	public CommonResponse<WebsiteHelpVO> saveData(WebsiteHelpVO websiteHelpVO) {
		if(websiteHelpVO.getId()!=null){
			//保存
			WebsiteHelpEntity oldEntity = this.selectById(websiteHelpVO.getId());
			if(StringUtils.isNotBlank(oldEntity.getFile())){
				if(StringUtils.isNotBlank(websiteHelpVO.getFile())){
					if(!oldEntity.getFile().equals(websiteHelpVO.getFile())){
						//删除原先的文件
						if(StringUtils.isNotBlank(oldEntity.getFile())){
							String id = oldEntity.getFile();
							attachmentApi.delete(id);
						}
						//绑定新的文件
						if(StringUtils.isNotBlank(websiteHelpVO.getFile())){
							String id = websiteHelpVO.getFile();
							List<Long> attachIds = new ArrayList<>();
							attachIds.add(Long.parseLong(id));
							attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
						}
					}
					
				}else{
					//删除原先的文件
					if(StringUtils.isNotBlank(oldEntity.getFile())){
						String id = oldEntity.getFile();
						attachmentApi.delete(id);
					}
				}
			}else{
				if(StringUtils.isNotBlank(websiteHelpVO.getFile())){
					//绑定新的文件
					List<Long> attachIds = new ArrayList<>();
					attachIds.add(Long.parseLong(websiteHelpVO.getFile()));
					attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
				}
			}
		}
    	WebsiteHelpEntity entity = BeanMapper.map(websiteHelpVO, WebsiteHelpEntity.class);
    	if(entity.getId()==null){
    		//新增时默认是否发布、置顶为false（0）
    		entity.setPublishFlag(0);
    		entity.setTopFlag(0);
    	}
    	this.saveOrUpdate(entity, false);
    	WebsiteHelpVO vo = BeanMapper.map(entity, WebsiteHelpVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
	}
    
}
