package com.ejianc.business.zdkcg.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;

import com.ejianc.business.zdkcg.mapper.WebsiteNewsMapper;
import com.ejianc.business.zdkcg.bean.WebsiteCarouselEntity;
import com.ejianc.business.zdkcg.bean.WebsiteNewsEntity;
import com.ejianc.business.zdkcg.service.IWebsiteNewsService;
import com.ejianc.business.zdkcg.vo.WebsiteNewsVO;
import com.ejianc.foundation.file.api.IAttachmentApi;

/**
 * 
 * @author 
 * 
 */
@Service("websiteNewsService")
public class WebsiteNewsServiceImpl extends BaseServiceImpl<WebsiteNewsMapper, WebsiteNewsEntity> implements IWebsiteNewsService{

	@Autowired
	private IAttachmentApi attachmentApi;
	
	@Override
	public CommonResponse<WebsiteNewsVO> saveData(WebsiteNewsVO websiteNewsVO) {
		if(websiteNewsVO.getId()!=null){
			//保存
			WebsiteNewsEntity oldEntity = this.selectById(websiteNewsVO.getId());
			if(StringUtils.isNotBlank(oldEntity.getPicPath())){
				if(StringUtils.isNotBlank(websiteNewsVO.getPicPath())){
					if(!oldEntity.getPicPath().equals(websiteNewsVO.getPicPath())){
						//删除原先的轮播图
						if(StringUtils.isNotBlank(oldEntity.getPicPath())){
							String id = oldEntity.getPicPath().split("=")[1];
							if(StringUtils.isNotBlank(id)){
								attachmentApi.delete(id);
							}
						}
						//绑定新的轮播图
						if(StringUtils.isNotBlank(websiteNewsVO.getPicPath())){
							String id = websiteNewsVO.getPicPath().split("=")[1];
							if(StringUtils.isNotBlank(id)){
								List<Long> attachIds = new ArrayList<>();
								attachIds.add(Long.parseLong(id));
								attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
							}
						}
					}
					
				}else{
					//删除原先的轮播图
					if(StringUtils.isNotBlank(oldEntity.getPicPath())){
						String id = oldEntity.getPicPath().split("=")[1];
						if(StringUtils.isNotBlank(id)){
							attachmentApi.delete(id);
						}
					}
				}
			}else{
				if(StringUtils.isNotBlank(websiteNewsVO.getPicPath())){
					//绑定新的轮播图
					String id = websiteNewsVO.getPicPath().split("=")[1];
					if(StringUtils.isNotBlank(id)){
						List<Long> attachIds = new ArrayList<>();
						attachIds.add(Long.parseLong(id));
						attachmentApi.updateAttachRef(oldEntity.getId(), attachIds);
					}
				}
			}
		}
		WebsiteNewsEntity entity = BeanMapper.map(websiteNewsVO, WebsiteNewsEntity.class);
    	if(entity.getId()==null){
    		//新增时默认是否发布、置顶为false（0）
    		entity.setShelvesFlag(0);
    		entity.setTopFlag(0);
    	}
    	this.saveOrUpdate(entity, false);
    	WebsiteNewsVO vo = BeanMapper.map(entity, WebsiteNewsVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
	}
    
}
