package com.ejianc.business.zdscost.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.fieldCompare.DifferenceComparison;
import com.ejianc.framework.skeleton.fieldCompare.FieldDifferenceComparison;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 切包清单-明细
 *
 * @author generator
 *
 */
@ApiModel("切包清单-明细")
@DifferenceComparison(changeFlag = "changeType", differnceList = "differnceList", beforeKeyPrefix = "before")
public class BudgetProjectDetailVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主表主键")
    private Long budgetId;
    @ApiModelProperty("上包清单id")
    private Long packUpId;
    @ApiModelProperty("下包材料清单id")
    private Long materialListId;
    @ApiModelProperty("下包工程清单id")
    private Long engineeringListId;
    @ApiModelProperty("是否上包清单，1是0否")
    private Integer packUpFlag;
    @ApiModelProperty("是否材料清单，1是0否")
    private Integer materialListFlag;
    @ApiModelProperty("是否工程清单，1是0否")
    private Integer engineeringListFlag;
    @ApiModelProperty("上包清单-项目编码")
    @FieldDifferenceComparison(name= "项目编码")
    private String code;
    @ApiModelProperty("上包清单-项目名称")
    private String name;
    @ApiModelProperty("上包清单-项目特征")
    private String feature;
    @ApiModelProperty("上包清单-计量单位")
    private String unit;
    @ApiModelProperty("上包工程量-上包合同量")
    @FieldDifferenceComparison(name= "上包合同量")
    private BigDecimal contractNum;
    @ApiModelProperty("上包工程量-投标复核工程量")
    @FieldDifferenceComparison(name= "投标复核工程量")
    private BigDecimal checkEngineeringNum;
    @ApiModelProperty("上包合同价-上包材料单价")
    @FieldDifferenceComparison(name= "上包材料单价")
    private BigDecimal materialPrice;
    @ApiModelProperty("上包合同价-上包安装单价")
    @FieldDifferenceComparison(name= "上包安装单价")
    private BigDecimal fixPrice;
    @ApiModelProperty("上包合同价-上包综合单价")
    private BigDecimal price;
    @ApiModelProperty("上包合同价-上包合价")
    private BigDecimal money;
    @ApiModelProperty("切包情况-大包id")
    private Long bigPackId;
    @ApiModelProperty("切包情况-大包编码")
    private String bigPackCode;
    @ApiModelProperty("切包情况-大包名称")
    @FieldDifferenceComparison(name= "大包名称")
    private String bigPackName;
    @ApiModelProperty("切包情况-是否公司采购，1是0否")
    private String puchaseFlag;
    @ApiModelProperty("切包情况-材料包id，二级物料类别")
    private Long materialPackId;
    @ApiModelProperty("切包情况-材料包编码")
    @FieldDifferenceComparison(name= "材料包代码")
    private String materialPackCode;
    @ApiModelProperty("切包情况-材料包名称")
    private String materialPackName;
    @ApiModelProperty("切包情况-工程包id，分包领料范围")
    private Long engineeringPackId;
    @ApiModelProperty("切包情况-工程包编码")
    @FieldDifferenceComparison(name= "工程包代码")
    private String engineeringPackCode;
    @ApiModelProperty("切包情况-工程包名称")
    private String engineeringPackName;
    @ApiModelProperty("下包清单-项目编码")
    private String itemCode;
    @ApiModelProperty("下包清单-项目名称")
    private String itemName;
    @ApiModelProperty("下包清单-项目特征")
    private String itemFeature;
    @ApiModelProperty("下包清单-单位")
    private String itemUnit;
    @ApiModelProperty("下包清单-进场二次点量")
    @FieldDifferenceComparison(name= "进场二次点量")
    private BigDecimal itemNum;
    @ApiModelProperty("上限价-上限材料单价")
    @FieldDifferenceComparison(name= "上限材料单价")
    private BigDecimal upperMaterialPrice;
    @ApiModelProperty("上限价-上限安装单价")
    @FieldDifferenceComparison(name= "上限安装单价")
    private BigDecimal upperFixPrice;
    @ApiModelProperty("上限价-上限综合单价")
    private BigDecimal upperPrice;
    @ApiModelProperty("上限价-上限合价")
    private BigDecimal upperMoney;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更子表主键")
    private Long changeBid;
    @ApiModelProperty("切包情况-erp大包id")
    private String bigPackSid;
    @ApiModelProperty("切包情况-erp材料包id")
    private String materialPackSid;
    @ApiModelProperty("切包情况-erp工程包id")
    private String engineeringPackSid;

    private String changeType;

    private Long parentId;

    private List<ITreeNodeB> children;


    @ApiModelProperty("上包清单-项目编码")
    private String beforeCode;

    @ApiModelProperty("上包工程量-上包合同量")
    private BigDecimal beforeContractNum;

    @ApiModelProperty("上包工程量-投标复核工程量")
    private BigDecimal beforeCheckEngineeringNum;
    @ApiModelProperty("上包合同价-上包材料单价")
    private BigDecimal beforeMaterialPrice;
    @ApiModelProperty("上包合同价-上包安装单价")
    private BigDecimal beforeFixPrice;

    @ApiModelProperty("切包情况-大包名称")
    private String beforeBigPackName;
    @ApiModelProperty("切包情况-材料包编码")
    private String beforeMaterialPackCode;
    @ApiModelProperty("切包情况-工程包编码")
    private String beforeEngineeringPackCode;

    @ApiModelProperty("下包清单-进场二次点量")
    private BigDecimal beforeItemNum;
    @ApiModelProperty("上限价-上限材料单价")
    private BigDecimal beforeUpperMaterialPrice;
    @ApiModelProperty("上限价-上限安装单价")
    private BigDecimal beforeUpperFixPrice;

    List<CompareDifferenceUtil.FieldDifference> differnceList;

    private String mateType; // 匹配类型：4-待识别，0-不匹配，1-部分匹配，2-完全匹配，3-识别失败
    private Long materialId; // 物料Id
    private String materialCode; // 物料编码
    private String materialName; // 物料名称
    private String materialSpec; // 物料属性

    private BigDecimal sequen; // 排序字段

    public BigDecimal getSequen() {
        return sequen;
    }

    public void setSequen(BigDecimal sequen) {
        this.sequen = sequen;
    }

    public String getMateType() {
        return mateType;
    }

    public void setMateType(String mateType) {
        this.mateType = mateType;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getBeforeCode() {
        return beforeCode;
    }

    public void setBeforeCode(String beforeCode) {
        this.beforeCode = beforeCode;
    }

    public BigDecimal getBeforeContractNum() {
        return beforeContractNum;
    }

    public void setBeforeContractNum(BigDecimal beforeContractNum) {
        this.beforeContractNum = beforeContractNum;
    }

    public BigDecimal getBeforeCheckEngineeringNum() {
        return beforeCheckEngineeringNum;
    }

    public void setBeforeCheckEngineeringNum(BigDecimal beforeCheckEngineeringNum) {
        this.beforeCheckEngineeringNum = beforeCheckEngineeringNum;
    }

    public BigDecimal getBeforeMaterialPrice() {
        return beforeMaterialPrice;
    }

    public void setBeforeMaterialPrice(BigDecimal beforeMaterialPrice) {
        this.beforeMaterialPrice = beforeMaterialPrice;
    }

    public BigDecimal getBeforeFixPrice() {
        return beforeFixPrice;
    }

    public void setBeforeFixPrice(BigDecimal beforeFixPrice) {
        this.beforeFixPrice = beforeFixPrice;
    }

    public String getBeforeBigPackName() {
        return beforeBigPackName;
    }

    public void setBeforeBigPackName(String beforeBigPackName) {
        this.beforeBigPackName = beforeBigPackName;
    }

    public String getBeforeMaterialPackCode() {
        return beforeMaterialPackCode;
    }

    public void setBeforeMaterialPackCode(String beforeMaterialPackCode) {
        this.beforeMaterialPackCode = beforeMaterialPackCode;
    }

    public String getBeforeEngineeringPackCode() {
        return beforeEngineeringPackCode;
    }

    public void setBeforeEngineeringPackCode(String beforeEngineeringPackCode) {
        this.beforeEngineeringPackCode = beforeEngineeringPackCode;
    }

    public BigDecimal getBeforeItemNum() {
        return beforeItemNum;
    }

    public void setBeforeItemNum(BigDecimal beforeItemNum) {
        this.beforeItemNum = beforeItemNum;
    }

    public BigDecimal getBeforeUpperMaterialPrice() {
        return beforeUpperMaterialPrice;
    }

    public void setBeforeUpperMaterialPrice(BigDecimal beforeUpperMaterialPrice) {
        this.beforeUpperMaterialPrice = beforeUpperMaterialPrice;
    }

    public BigDecimal getBeforeUpperFixPrice() {
        return beforeUpperFixPrice;
    }

    public void setBeforeUpperFixPrice(BigDecimal beforeUpperFixPrice) {
        this.beforeUpperFixPrice = beforeUpperFixPrice;
    }

    public List<CompareDifferenceUtil.FieldDifference> getDiffernceList() {
        return differnceList;
    }

    public void setDiffernceList(List<CompareDifferenceUtil.FieldDifference> differnceList) {
        this.differnceList = differnceList;
    }

    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
    /**
     * 导入失败原因
     */
    private String errorMessage;

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * 主表主键
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 主表主键
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    /**
     * 上包清单id
     */
    public Long getPackUpId() {
        return packUpId;
    }

    /**
     * 上包清单id
     */
    public void setPackUpId(Long packUpId) {
        this.packUpId = packUpId;
    }

    /**
     * 下包材料清单id
     */
    public Long getMaterialListId() {
        return materialListId;
    }

    /**
     * 下包材料清单id
     */
    public void setMaterialListId(Long materialListId) {
        this.materialListId = materialListId;
    }

    /**
     * 下包工程清单id
     */
    public Long getEngineeringListId() {
        return engineeringListId;
    }

    /**
     * 下包工程清单id
     */
    public void setEngineeringListId(Long engineeringListId) {
        this.engineeringListId = engineeringListId;
    }

    /**
     * 是否上包清单，1是0否
     */
    public Integer getPackUpFlag() {
        return packUpFlag;
    }

    /**
     * 是否上包清单，1是0否
     */
    public void setPackUpFlag(Integer packUpFlag) {
        this.packUpFlag = packUpFlag;
    }

    /**
     * 是否材料清单，1是0否
     */
    public Integer getMaterialListFlag() {
        return materialListFlag;
    }

    /**
     * 是否材料清单，1是0否
     */
    public void setMaterialListFlag(Integer materialListFlag) {
        this.materialListFlag = materialListFlag;
    }

    /**
     * 是否工程清单，1是0否
     */
    public Integer getEngineeringListFlag() {
        return engineeringListFlag;
    }

    /**
     * 是否工程清单，1是0否
     */
    public void setEngineeringListFlag(Integer engineeringListFlag) {
        this.engineeringListFlag = engineeringListFlag;
    }

    /**
     * 上包清单-项目编码
     */
    public String getCode() {
        return code;
    }

    /**
     * 上包清单-项目编码
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 上包清单-项目名称
     */
    public String getName() {
        return name;
    }

    /**
     * 上包清单-项目名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 上包清单-项目特征
     */
    public String getFeature() {
        return feature;
    }

    /**
     * 上包清单-项目特征
     */
    public void setFeature(String feature) {
        this.feature = feature;
    }

    /**
     * 上包清单-计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 上包清单-计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * 上包工程量-上包合同量
     */
    public BigDecimal getContractNum() {
        return contractNum;
    }

    /**
     * 上包工程量-上包合同量
     */
    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }

    /**
     * 上包工程量-投标复核工程量
     */
    public BigDecimal getCheckEngineeringNum() {
        return checkEngineeringNum;
    }

    /**
     * 上包工程量-投标复核工程量
     */
    public void setCheckEngineeringNum(BigDecimal checkEngineeringNum) {
        this.checkEngineeringNum = checkEngineeringNum;
    }

    /**
     * 上包合同价-上包材料单价
     */
    public BigDecimal getMaterialPrice() {
        return materialPrice;
    }

    /**
     * 上包合同价-上包材料单价
     */
    public void setMaterialPrice(BigDecimal materialPrice) {
        this.materialPrice = materialPrice;
    }

    /**
     * 上包合同价-上包安装单价
     */
    public BigDecimal getFixPrice() {
        return fixPrice;
    }

    /**
     * 上包合同价-上包安装单价
     */
    public void setFixPrice(BigDecimal fixPrice) {
        this.fixPrice = fixPrice;
    }

    /**
     * 上包合同价-上包综合单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 上包合同价-上包综合单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    /**
     * 上包合同价-上包合价
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 上包合同价-上包合价
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    /**
     * 切包情况-大包id
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBigPackId() {
        return bigPackId;
    }

    /**
     * 切包情况-大包id
     */
    @ReferDeserialTransfer
    public void setBigPackId(Long bigPackId) {
        this.bigPackId = bigPackId;
    }

    /**
     * 切包情况-大包编码
     */
    public String getBigPackCode() {
        return bigPackCode;
    }

    /**
     * 切包情况-大包编码
     */
    public void setBigPackCode(String bigPackCode) {
        this.bigPackCode = bigPackCode;
    }

    /**
     * 切包情况-大包名称
     */
    public String getBigPackName() {
        return bigPackName;
    }

    /**
     * 切包情况-大包名称
     */
    public void setBigPackName(String bigPackName) {
        this.bigPackName = bigPackName;
    }

    /**
     * 切包情况-是否公司采购，1是0否
     */
    public String getPuchaseFlag() {
        return puchaseFlag;
    }

    /**
     * 切包情况-是否公司采购，1是0否
     */
    public void setPuchaseFlag(String puchaseFlag) {
        this.puchaseFlag = puchaseFlag;
    }

    /**
     * 切包情况-材料包id，二级物料类别
     */
    @ReferSerialTransfer(referCode = "ref-zdsmteral-category")
    public Long getMaterialPackId() {
        return materialPackId;
    }

    /**
     * 切包情况-材料包id，二级物料类别
     */
    @ReferDeserialTransfer
    public void setMaterialPackId(Long materialPackId) {
        this.materialPackId = materialPackId;
    }

    /**
     * 切包情况-材料包编码
     */
    public String getMaterialPackCode() {
        return materialPackCode;
    }

    /**
     * 切包情况-材料包编码
     */
    public void setMaterialPackCode(String materialPackCode) {
        this.materialPackCode = materialPackCode;
    }

    /**
     * 切包情况-材料包名称
     */
    public String getMaterialPackName() {
        return materialPackName;
    }

    /**
     * 切包情况-材料包名称
     */
    public void setMaterialPackName(String materialPackName) {
        this.materialPackName = materialPackName;
    }

    /**
     * 切包情况-erp工程包id
     */
    @ReferSerialTransfer(referCode = "zds-subType")
    public Long getEngineeringPackId() {
        return engineeringPackId;
    }

    /**
     * 切包情况-erp工程包id
     */
    @ReferDeserialTransfer
    public void setEngineeringPackId(Long engineeringPackId) {
        this.engineeringPackId = engineeringPackId;
    }

    /**
     * 切包情况-工程包编码
     */
    public String getEngineeringPackCode() {
        return engineeringPackCode;
    }

    /**
     * 切包情况-工程包编码
     */
    public void setEngineeringPackCode(String engineeringPackCode) {
        this.engineeringPackCode = engineeringPackCode;
    }

    /**
     * 切包情况-工程包名称
     */
    public String getEngineeringPackName() {
        return engineeringPackName;
    }

    /**
     * 切包情况-工程包名称
     */
    public void setEngineeringPackName(String engineeringPackName) {
        this.engineeringPackName = engineeringPackName;
    }

    /**
     * 下包清单-项目编码
     */
    public String getItemCode() {
        return itemCode;
    }

    /**
     * 下包清单-项目编码
     */
    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    /**
     * 下包清单-项目名称
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * 下包清单-项目名称
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * 下包清单-项目特征
     */
    public String getItemFeature() {
        return itemFeature;
    }

    /**
     * 下包清单-项目特征
     */
    public void setItemFeature(String itemFeature) {
        this.itemFeature = itemFeature;
    }

    /**
     * 下包清单-单位
     */
    public String getItemUnit() {
        return itemUnit;
    }

    /**
     * 下包清单-单位
     */
    public void setItemUnit(String itemUnit) {
        this.itemUnit = itemUnit;
    }

    /**
     * 下包清单-进场二次点量
     */
    public BigDecimal getItemNum() {
        return itemNum;
    }

    /**
     * 下包清单-进场二次点量
     */
    public void setItemNum(BigDecimal itemNum) {
        this.itemNum = itemNum;
    }

    /**
     * 上限价-上限材料单价
     */
    public BigDecimal getUpperMaterialPrice() {
        return upperMaterialPrice;
    }

    /**
     * 上限价-上限材料单价
     */
    public void setUpperMaterialPrice(BigDecimal upperMaterialPrice) {
        this.upperMaterialPrice = upperMaterialPrice;
    }

    /**
     * 上限价-上限安装单价
     */
    public BigDecimal getUpperFixPrice() {
        return upperFixPrice;
    }

    /**
     * 上限价-上限安装单价
     */
    public void setUpperFixPrice(BigDecimal upperFixPrice) {
        this.upperFixPrice = upperFixPrice;
    }

    /**
     * 上限价-上限综合单价
     */
    public BigDecimal getUpperPrice() {
        return upperPrice;
    }

    /**
     * 上限价-上限综合单价
     */
    public void setUpperPrice(BigDecimal upperPrice) {
        this.upperPrice = upperPrice;
    }

    /**
     * 上限价-上限合价
     */
    public BigDecimal getUpperMoney() {
        return upperMoney;
    }

    /**
     * 上限价-上限合价
     */
    public void setUpperMoney(BigDecimal upperMoney) {
        this.upperMoney = upperMoney;
    }

    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    /**
     * 切包情况-erp大包id
     */
    public String getBigPackSid() {
        return bigPackSid;
    }

    /**
     * 切包情况-erp大包id
     */
    public void setBigPackSid(String bigPackSid) {
        this.bigPackSid = bigPackSid;
    }

    /**
     * 切包情况-erp材料包id
     */
    public String getMaterialPackSid() {
        return materialPackSid;
    }

    /**
     * 切包情况-erp材料包id
     */
    public void setMaterialPackSid(String materialPackSid) {
        this.materialPackSid = materialPackSid;
    }

    /**
     * 切包情况-工程包id，分包领料范围
     */
    public String getEngineeringPackSid() {
        return engineeringPackSid;
    }

    /**
     * 切包情况-工程包id，分包领料范围
     */
    public void setEngineeringPackSid(String engineeringPackSid) {
        this.engineeringPackSid = engineeringPackSid;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Long getParentId() {
        return parentId;
    }
}
