package com.ejianc.business.zdscost.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailQueryVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 切包清单-明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetProjectDetail")
@Api(value = "切包清单-查询", tags = {"切包清单-查询"})
public class BudgetProjectDetailController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBudgetProjectDetailService service;


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailVO>> queryList(@RequestBody BudgetProjectDetailQueryVO queryVO) {
        if (queryVO.getProjectId() == null) {
            throw new BusinessException("参数项目[projectId]为不能为空！");
        }
        QueryParam queryParam = new QueryParam();
        Map<String, Parameter> params = queryParam.getParams();
        /** 租户隔离 */
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<BudgetProjectDetailEntity> page = service.queryPage(queryParam, false);
        IPage<BudgetProjectDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectDetailVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


}
