package com.ejianc.business.zdscost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
/**
 * 切包清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_budget_project")
public class BudgetProjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="engineering_pack_num")
    private BigDecimal engineeringPackNum; // 工程包数量
    @TableField(value="material_pack_num")
    private BigDecimal materialPackNum; // 材料包数量
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_date")
    private Date billDate; // 单据日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本号
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="memo")
    private String memo; // 备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="budgetProjectDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<BudgetProjectDetailEntity> budgetProjectDetailList = new ArrayList<>(); // 切包清单-明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getEngineeringPackNum() {
        return engineeringPackNum;
    }

    public void setEngineeringPackNum(BigDecimal engineeringPackNum) {
        this.engineeringPackNum = engineeringPackNum;
    }
    public BigDecimal getMaterialPackNum() {
        return materialPackNum;
    }

    public void setMaterialPackNum(BigDecimal materialPackNum) {
        this.materialPackNum = materialPackNum;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    public List<BudgetProjectDetailEntity> getBudgetProjectDetailList() {
        return budgetProjectDetailList;
    }

    public void setBudgetProjectDetailList(List<BudgetProjectDetailEntity> budgetProjectDetailList) {
        this.budgetProjectDetailList = budgetProjectDetailList;
    }
}
