package com.ejianc.business.zdscost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectChangeVO;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 切包清单变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetProjectChange")
@Api(value = "切包清单变更", tags = {"切包清单变更"})
public class BudgetProjectChangeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "BUDGET_PROJECT_CHANGE_CODE";

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IBudgetProjectChangeService service;

    @Autowired
    private IBudgetProjectService budgetProjectService;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody BudgetProjectChangeVO saveOrUpdateVO) {
        BudgetProjectChangeEntity entity = BeanMapper.map(saveOrUpdateVO, BudgetProjectChangeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setChangeStatus(2);
            entity.setChangeVersion(entity.getChangeVersion() + 1);
            entity.setBillDate(new Date());
        }

        List<BudgetProjectDetailChangeEntity> detailList = entity.getBudgetProjectDetailChangeList();

        // 上包清单code map
        Map<String, Long> packUpMap = new HashMap<>();
        Map<String, List<String>> codeNumMap = new HashMap<>();
        for (BudgetProjectDetailChangeEntity t : detailList) {
            String code = t.getCode();
            if (StringUtils.isNotBlank(code) && t.getPackUpId() != null) {
                packUpMap.put(code, t.getPackUpId());
            }
            List<String> codeList = codeNumMap.get(code);
            if (codeList == null) {
                codeNumMap.put(code, new ArrayList<>());
            }
            if (StringUtils.isNotBlank(t.getItemCode())) {
                codeNumMap.get(code).add(t.getItemCode());
            }
        }

        Integer engineeringPackNum = 0;
        Integer materialPackNum = 0;
        for (BudgetProjectDetailChangeEntity detailEntity : detailList) {
            if (!"del".equals(detailEntity.getRowState()) && !ChangTypeConst.DELETE.equals(detailEntity.getChangeType())) {
                engineeringPackNum++;
                materialPackNum++;
                String code = detailEntity.getCode();
                if (StringUtils.isNotBlank(code)) {
                    detailEntity.setPackUpFlag(1);
                    Long packUpId = packUpMap.get(code);
                    if (packUpId == null) {
                        packUpId = IdWorker.getId();
                        packUpMap.put(code, packUpId);
                    }
                    detailEntity.setPackUpId(packUpId);
                } else {
                    detailEntity.setPackUpFlag(0);
                    detailEntity.setPackUpId(null);
                    detailEntity.setCode(null);
                    code = null;
                }
                if (StringUtils.isBlank(detailEntity.getItemCode())) {
                    List<String> itemCodeList = codeNumMap.get(code);
                    if (itemCodeList != null) {
                        Integer number = itemCodeList.size() + 1;
                        String itemCode = code + String.format("%02d", number);
                        detailEntity.setItemCode(itemCode);
                        while (itemCodeList.contains(itemCode)) {
                            number++;
                            itemCode = code + String.format("%02d", number);
                            if (!itemCodeList.contains(itemCode)) {
                                detailEntity.setItemCode(itemCode);
                                codeNumMap.get(code).add(itemCode);
                                break;
                            }
                        }
                    } else {
                        String itemCode = code + "01";
                        detailEntity.setItemCode(itemCode);
                        itemCodeList = new ArrayList<>();
                        itemCodeList.add(itemCode);
                        codeNumMap.put(code, itemCodeList);
                    }
                }

                if (detailEntity.getMaterialPackId() != null) {
                    detailEntity.setMaterialListFlag(1);
                    if (detailEntity.getMaterialListId() == null) {
                        detailEntity.setMaterialListId(IdWorker.getId());
                    }
                } else {
                    detailEntity.setMaterialListFlag(0);
                    detailEntity.setMaterialListId(null);
                }
                if (detailEntity.getEngineeringPackId() != null) {
                    detailEntity.setEngineeringListFlag(1);
                    if (detailEntity.getEngineeringListId() == null) {
                        detailEntity.setEngineeringListId(IdWorker.getId());
                    }
                } else {
                    detailEntity.setEngineeringListFlag(0);
                    detailEntity.setEngineeringListId(null);
                }
            }
        }
        entity.setEngineeringPackNum(engineeringPackNum);
        entity.setMaterialPackNum(materialPackNum);

        service.saveOrUpdate(entity, false);
        LambdaUpdateWrapper<BudgetProjectEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BudgetProjectEntity::getId, entity.getChangeId());
        wrapper.set(BudgetProjectEntity::getChangeId, entity.getId());
        wrapper.set(BudgetProjectEntity::getChangeCode, entity.getBillCode());
        wrapper.set(BudgetProjectEntity::getChangeStatus, BudgetProjectVO.CHANGE_STATE_CHANGING);
        budgetProjectService.update(wrapper);
        BudgetProjectChangeVO vo = BeanMapper.map(entity, BudgetProjectChangeVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> queryDetail(@RequestParam Long id) {
        BudgetProjectChangeEntity entity = service.selectById(id);
        BudgetProjectChangeVO vo = BeanMapper.map(entity, BudgetProjectChangeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @RequestMapping(value = "/addByBudgetId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> addByBudgetId(Long budgetId) {
        BudgetProjectChangeVO vo = service.addByBudgetId(budgetId);
        return CommonResponse.success("新增转换数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectChangeVO> vos) {
        BudgetProjectChangeVO changeVo = vos.get(0);
        BudgetProjectChangeEntity entity = service.getById(changeVo.getId());
        LambdaUpdateWrapper<BudgetProjectEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BudgetProjectEntity::getId, entity.getChangeId());
        wrapper.set(BudgetProjectEntity::getChangeId, null);
        wrapper.set(BudgetProjectEntity::getChangeCode, null);
        wrapper.set(BudgetProjectEntity::getChangeStatus, BudgetProjectVO.CHANGE_STATE_UNCHANGED);
        budgetProjectService.update(wrapper);
        service.removeByIds(vos.stream().map(BudgetProjectChangeVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BudgetProjectChangeEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectChangeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetProjectChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetProjectChange-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refBudgetProjectChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeVO>> refBudgetProjectChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                   String condition,
                                                                                   String searchObject,
                                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetProjectChangeEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectChangeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
