package com.ejianc.business.zdscost.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectRecordEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("budgetProjectChange")
public class BudgetProjectChangeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBudgetProjectChangeService changeService;

    @Autowired
    private IBudgetProjectService service;

    @Autowired
    private IBudgetProjectDetailService detailService;

    @Autowired
    private IBudgetProjectRecordService recordService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        /**更新变更的审批时间  begin */
        BudgetProjectChangeEntity changeEntity = changeService.selectById(billId);
        LambdaUpdateWrapper<BudgetProjectChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BudgetProjectChangeEntity::getEffectiveTime, new Date());
        updateWrapper.eq(BudgetProjectChangeEntity::getId, changeEntity.getId());
        changeService.update(updateWrapper);
        /**更新变更的审批时间  end */

        /**复制合同表数据到记录表 begin */
        BudgetProjectEntity budgetProjectEntity = service.selectById(changeEntity.getChangeId());
        Map<Long, Integer> contIdVersionMap = new HashMap<>();
        BudgetProjectRecordEntity recordEntity = BeanMapper.map(budgetProjectEntity, BudgetProjectRecordEntity.class);
        recordEntity.setChangeId(budgetProjectEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getBudgetProjectDetailRecordList())) {
            recordEntity.getBudgetProjectDetailRecordList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setChangeBid(vo.getId());
                vo.setChangeId(vo.getBudgetId());
                vo.setId(null);
            });
        }
        recordService.saveOrUpdate(recordEntity, false);
        /**复制合同表数据到记录表 end */

        /**更新变更表表头数据到合同 begin */
        budgetProjectEntity.setChangeId(null);
        budgetProjectEntity.setChangeStatus(BudgetProjectVO.CHANGE_STATE_CHANGED);
        budgetProjectEntity.setChangeVersion(changeEntity.getChangeVersion());
        budgetProjectEntity.setEffectiveTime(new Date());
        service.updateById(budgetProjectEntity);
        /**复制合同表数据到记录表 end */

        /**复制合同子表数据 begin */
        BudgetProjectEntity contractChangeEntity = BeanMapper.map(changeEntity, BudgetProjectEntity.class);
        List<BudgetProjectDetailEntity> budgetProjectDetailList = contractChangeEntity.getBudgetProjectDetailList();
        if (CollectionUtils.isNotEmpty(budgetProjectDetailList)) {
            budgetProjectDetailList.forEach(contractDetailEntity -> {
                //记录虚拟父子关系
                Long changeBid = contractDetailEntity.getChangeBid();
                contractDetailEntity.setBudgetId(changeEntity.getChangeId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                contractDetailEntity.setChangeId(contractDetailEntity.getId());
                contractDetailEntity.setId(changeBid);
                contractDetailEntity.setVersion(contIdVersionMap.get(changeBid));
            });
            detailService.saveOrUpdateBatch(budgetProjectDetailList, budgetProjectDetailList.size(), false);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("合同变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
