/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.util.CostExcelReader;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.api.IZDSMaterialCategoryApi;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"budgetProject"})
@Api(value="\u5207\u5305\u6e05\u5355", tags={"\u5207\u5305\u6e05\u5355"})
public class BudgetProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IZDSSubTypeApi subTypeApi;
    @Autowired
    private IZDSMaterialCategoryApi materialCategoryApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BUDGET_PROJECT_CODE";
    @Autowired
    private IBudgetProjectService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody BudgetProjectVO saveOrUpdateVO) {
        BudgetProjectEntity entity = (BudgetProjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BudgetProjectEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setChangeStatus(1);
            entity.setChangeVersion(1);
            entity.setBillDate(new Date());
        }
        List<BudgetProjectDetailEntity> detailList = entity.getBudgetProjectDetailList();
        Map<String, Long> packUpMap = detailList.stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getCode()) && t.getPackUpId() != null).collect(Collectors.toMap(s -> s.getCode(), s -> s.getPackUpId()));
        Map<Object, Object> bigPakgMap = new HashMap();
        CommonResponse resp = this.defdocApi.getDefDocByDefCode("professional-package");
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            bigPakgMap = ((List)resp.getData()).stream().collect(Collectors.toMap(BaseVO::getId, v -> v, (p1, p2) -> p1));
        }
        HashMap<String, Integer> codeNumMap = new HashMap<String, Integer>();
        Integer engineeringPackNum = 0;
        Integer materialPackNum = 0;
        for (BudgetProjectDetailEntity detailEntity : detailList) {
            detailEntity.setChangeType("0");
            Long bigPackId = detailEntity.getBigPackId();
            if (bigPackId != null && bigPakgMap.get(bigPackId) != null) {
                detailEntity.setBigPackSid(((DefdocDetailVO)bigPakgMap.get(bigPackId)).getAttrCode());
                detailEntity.setBigPackCode(((DefdocDetailVO)bigPakgMap.get(bigPackId)).getCode());
                detailEntity.setBigPackName(((DefdocDetailVO)bigPakgMap.get(bigPackId)).getName());
            }
            if ("del".equals(detailEntity.getRowState())) continue;
            Integer n = engineeringPackNum;
            Integer n2 = engineeringPackNum = Integer.valueOf(engineeringPackNum + 1);
            n = materialPackNum;
            n2 = materialPackNum = Integer.valueOf(materialPackNum + 1);
            String code = detailEntity.getCode();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                detailEntity.setPackUpFlag(1);
                Long packUpId = packUpMap.get(code);
                if (packUpId == null) {
                    packUpId = IdWorker.getId();
                    packUpMap.put(code, packUpId);
                }
                detailEntity.setPackUpId(packUpId);
            } else {
                detailEntity.setPackUpFlag(0);
                detailEntity.setPackUpId(null);
                detailEntity.setCode(null);
                code = null;
            }
            Integer number = (Integer)codeNumMap.get(code);
            if (number != null) {
                Integer n3 = number;
                Integer n4 = number = Integer.valueOf(number + 1);
                detailEntity.setItemCode(code + String.format("%02d", number));
                codeNumMap.put(code, number);
            } else {
                codeNumMap.put(code, 1);
                detailEntity.setItemCode(code + "01");
            }
            if (detailEntity.getMaterialPackId() != null) {
                detailEntity.setMaterialListFlag(1);
                if (detailEntity.getMaterialListId() == null) {
                    detailEntity.setMaterialListId(IdWorker.getId());
                }
            } else {
                detailEntity.setMaterialListFlag(0);
                detailEntity.setMaterialListId(null);
            }
            if (detailEntity.getEngineeringPackId() != null) {
                detailEntity.setEngineeringListFlag(1);
                if (detailEntity.getEngineeringListId() != null) continue;
                detailEntity.setEngineeringListId(IdWorker.getId());
                continue;
            }
            detailEntity.setEngineeringListFlag(0);
            detailEntity.setEngineeringListId(null);
        }
        entity.setEngineeringPackNum(engineeringPackNum);
        entity.setMaterialPackNum(materialPackNum);
        this.service.saveOrUpdate((Object)entity, false);
        BudgetProjectVO vo = (BudgetProjectVO)BeanMapper.map((Object)((Object)entity), BudgetProjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectVO> queryDetail(@RequestParam Long id) {
        BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.service.selectById(id));
        List<BudgetProjectDetailEntity> budgetProjectDetailList = entity.getBudgetProjectDetailList();
        List<BudgetProjectDetailEntity> projectDetailEntities = budgetProjectDetailList.stream().filter(t -> !"2".equals(t.getChangeType())).collect(Collectors.toList());
        entity.setBudgetProjectDetailList(projectDetailEntities);
        BudgetProjectVO vo = (BudgetProjectVO)BeanMapper.map((Object)((Object)entity), BudgetProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BudgetProjectVO budgetProjectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "parentOrgName", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "parentOrgName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("BudgetProject-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refBudgetProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectVO>> refBudgetProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"budgetProjectDetail-import.xlsx", (String)"\u5207\u5305\u6e05\u5355\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        int codeIndex = 0;
        int nameIndex = 1;
        int featureIndex = 2;
        int unitIndex = 3;
        int contractNumIndex = 10;
        int checkEngineeringNumIndex = 11;
        int materialPriceIndex = 17;
        int fixPriceIndex = 18;
        int bigPackNameIndex = 4;
        int puchaseFlagIndex = 5;
        int materialPackNameIndex = 6;
        int materialPackCodeIndex = 7;
        int engineeringPackNameIndex = 8;
        int engineeringPackCodeIndex = 9;
        int itemNameIndex = 14;
        int itemFeatureIndex = 15;
        int itemUnitIndex = 16;
        int itemNumIndex = 12;
        int upperMaterialPriceIndex = 21;
        int upperFixPriceIndex = 22;
        int upperPriceIndex = 23;
        int upperMoneyIndex = 24;
        List result = CostExcelReader.readExcel((MultipartFile)mf);
        ArrayList<BudgetProjectDetailVO> successList = new ArrayList<BudgetProjectDetailVO>();
        ArrayList<BudgetProjectDetailVO> errorList = new ArrayList<BudgetProjectDetailVO>();
        if (result != null && result.size() > 0) {
            Map<Object, Object> bigPakgMap = new HashMap();
            CommonResponse resp = this.defdocApi.getDefDocByDefCode("professional-package");
            if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
                bigPakgMap = ((List)resp.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, v -> v, (p1, p2) -> p1));
            }
            Map<Object, Object> subTypeCodeMap = new HashMap();
            CommonResponse subTypeList = this.subTypeApi.getSubTypeList();
            if (subTypeList.isSuccess() && subTypeList.getData() != null) {
                subTypeCodeMap = ((List)subTypeList.getData()).stream().collect(Collectors.toMap(SubTypeVO::getLongCode, v -> v, (p1, p2) -> p1));
            }
            Map<Object, Object> secondCategoryCodeMap = new HashMap();
            CommonResponse secondCategoryList = this.materialCategoryApi.getMaterialSecondCategoryList();
            if (secondCategoryList.isSuccess() && secondCategoryList.getData() != null) {
                secondCategoryCodeMap = ((List)secondCategoryList.getData()).stream().collect(Collectors.toMap(MaterialCategoryVO::getCode, v -> v, (p1, p2) -> p1));
            }
            for (int i = 0; i < result.size(); ++i) {
                String materialPackCode;
                List datas = (List)result.get(i);
                StringBuilder errMsg = new StringBuilder();
                BudgetProjectDetailVO detailVO = new BudgetProjectDetailVO();
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(codeIndex)))) {
                    detailVO.setCode(((String)datas.get(codeIndex)).trim());
                } else {
                    detailVO.setCode(null);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(nameIndex)))) {
                    detailVO.setName(((String)datas.get(nameIndex)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(featureIndex)))) {
                    detailVO.setFeature(((String)datas.get(featureIndex)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(unitIndex)))) {
                    detailVO.setUnit(((String)datas.get(unitIndex)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(contractNumIndex)))) {
                    detailVO.setContractNum(ComputeUtil.toBigDecimal((String)((String)datas.get(contractNumIndex)).replace(",", "")));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(checkEngineeringNumIndex)))) {
                    detailVO.setCheckEngineeringNum(ComputeUtil.toBigDecimal((String)((String)datas.get(checkEngineeringNumIndex)).replace(",", "")));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(materialPriceIndex)))) {
                    detailVO.setMaterialPrice(ComputeUtil.toBigDecimal((String)((String)datas.get(materialPriceIndex)).replace(",", "")));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(fixPriceIndex)))) {
                    detailVO.setFixPrice(ComputeUtil.toBigDecimal((String)((String)datas.get(fixPriceIndex)).replace(",", "")));
                }
                detailVO.setPrice(ComputeUtil.safeAdd((BigDecimal)detailVO.getMaterialPrice(), (BigDecimal)detailVO.getFixPrice()));
                detailVO.setMoney(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailVO.getPrice(), (BigDecimal)detailVO.getContractNum())));
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(bigPackNameIndex)))) {
                    detailVO.setBigPackName(((String)datas.get(bigPackNameIndex)).trim());
                    DefdocDetailVO defdocDetailVO = (DefdocDetailVO)bigPakgMap.get(detailVO.getBigPackName());
                    if (defdocDetailVO == null) {
                        errMsg.append("`\u5927\u5305\u540d\u79f0\u672a\u5339\u914d`");
                    } else {
                        detailVO.setBigPackSid(defdocDetailVO.getAttrCode());
                        detailVO.setBigPackId(defdocDetailVO.getId());
                        detailVO.setBigPackCode(defdocDetailVO.getCode());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(puchaseFlagIndex)))) {
                    detailVO.setPuchaseFlag((String)datas.get(puchaseFlagIndex));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(materialPackCodeIndex)))) {
                    materialPackCode = ((String)datas.get(materialPackCodeIndex)).trim();
                    detailVO.setMaterialPackCode(materialPackCode);
                    MaterialCategoryVO materialCategoryVO = null;
                    materialCategoryVO = materialPackCode.contains("-") ? (MaterialCategoryVO)secondCategoryCodeMap.get(materialPackCode.split("-")[0]) : (MaterialCategoryVO)secondCategoryCodeMap.get(materialPackCode);
                    if (materialCategoryVO == null) {
                        errMsg.append("`\u6750\u6599\u5305\u4ee3\u7801\u672a\u5339\u914d`");
                    } else {
                        detailVO.setMaterialPackSid(materialCategoryVO.getSourceId());
                        detailVO.setMaterialPackId(materialCategoryVO.getId());
                        detailVO.setMaterialPackCode(materialCategoryVO.getCode());
                        detailVO.setMaterialPackName(materialCategoryVO.getName());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(engineeringPackCodeIndex)))) {
                    materialPackCode = ((String)datas.get(engineeringPackCodeIndex)).trim();
                    detailVO.setEngineeringPackCode(materialPackCode);
                    SubTypeVO subTypeVO = null;
                    subTypeVO = materialPackCode.contains("-") ? (SubTypeVO)subTypeCodeMap.get(materialPackCode.split("-")[0]) : (SubTypeVO)subTypeCodeMap.get(detailVO.getEngineeringPackCode());
                    if (subTypeVO == null) {
                        errMsg.append("`\u5de5\u7a0b\u5305\u4ee3\u7801\u672a\u5339\u914d`");
                    } else {
                        detailVO.setEngineeringPackSid(subTypeVO.getSourceId());
                        detailVO.setEngineeringPackId(subTypeVO.getId());
                        detailVO.setEngineeringPackCode(subTypeVO.getLongCode());
                        detailVO.setEngineeringPackName(subTypeVO.getName());
                    }
                } else if (StringUtils.isNotBlank((CharSequence)detailVO.getMaterialPackCode())) {
                    errMsg.append("`\u6750\u6599\u5305\u4ee3\u7801\u548c\u5de5\u7a0b\u5305\u4ee3\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a`");
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemNameIndex)))) {
                    detailVO.setItemName(((String)datas.get(itemNameIndex)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemFeatureIndex)))) {
                    detailVO.setItemFeature(((String)datas.get(itemFeatureIndex)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemUnitIndex)))) {
                    detailVO.setItemUnit(((String)datas.get(itemUnitIndex)).trim());
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(itemNumIndex)))) {
                    detailVO.setItemNum(ComputeUtil.toBigDecimal((String)((String)datas.get(itemNumIndex)).replace(",", "")));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(upperMaterialPriceIndex)))) {
                    detailVO.setUpperMaterialPrice(ComputeUtil.toBigDecimal((String)((String)datas.get(upperMaterialPriceIndex)).replace(",", "")));
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(upperFixPriceIndex)))) {
                    detailVO.setUpperFixPrice(ComputeUtil.toBigDecimal((String)((String)datas.get(upperFixPriceIndex)).replace(",", "")));
                }
                detailVO.setUpperPrice(ComputeUtil.safeAdd((BigDecimal)detailVO.getUpperMaterialPrice(), (BigDecimal)detailVO.getUpperFixPrice()));
                detailVO.setUpperMoney(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailVO.getUpperPrice(), (BigDecimal)detailVO.getItemNum())));
                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                    detailVO.setErrorMessage(errMsg.toString());
                    errorList.add(detailVO);
                    continue;
                }
                successList.add(detailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

