package com.ejianc.business.zdscost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.util.CostExcelReader;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.api.IZDSMaterialCategoryApi;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 切包清单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetProject")
@Api(value = "切包清单", tags = {"切包清单"})
public class BudgetProjectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IZDSSubTypeApi subTypeApi;

    @Autowired
    private IZDSMaterialCategoryApi materialCategoryApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BUDGET_PROJECT_CODE";

    @Autowired
    private IBudgetProjectService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody BudgetProjectVO saveOrUpdateVO) {
        BudgetProjectEntity entity = BeanMapper.map(saveOrUpdateVO, BudgetProjectEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setChangeStatus(1);
            entity.setChangeVersion(1);
            entity.setBillDate(new Date());
        }
        List<BudgetProjectDetailEntity> detailList = entity.getBudgetProjectDetailList();

        // 上包清单code map
        Map<String, Long> packUpMap = detailList.stream().filter(t -> StringUtils.isNotBlank(t.getCode()) && t.getPackUpId() != null).collect(Collectors.toMap(s -> s.getCode(), s -> s.getPackUpId()));

        Map<Long, DefdocDetailVO> bigPakgMap = new HashMap<>();
        CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefCode("professional-package");
        if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
            bigPakgMap = resp.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getId, v -> v, (p1, p2) -> p1));
        }
        Map<String, Integer> codeNumMap = new HashMap<>();
        Integer engineeringPackNum = 0;
        Integer materialPackNum = 0;
        for (BudgetProjectDetailEntity detailEntity : detailList) {
            detailEntity.setChangeType(ChangTypeConst.UNCHANGED);
            Long bigPackId = detailEntity.getBigPackId();
            if (bigPackId != null && bigPakgMap.get(bigPackId) != null) {
                detailEntity.setBigPackSid(bigPakgMap.get(bigPackId).getAttrCode());
                detailEntity.setBigPackCode(bigPakgMap.get(bigPackId).getCode());
                detailEntity.setBigPackName(bigPakgMap.get(bigPackId).getName());
            }


            if (!"del".equals(detailEntity.getRowState())) {
                engineeringPackNum++;
                materialPackNum++;
                String code = detailEntity.getCode();
                if (StringUtils.isNotBlank(code)) {
                    detailEntity.setPackUpFlag(1);
                    Long packUpId = packUpMap.get(code);
                    if (packUpId == null) {
                        packUpId = IdWorker.getId();
                        packUpMap.put(code, packUpId);
                    }
                    detailEntity.setPackUpId(packUpId);
                } else {
                    detailEntity.setPackUpFlag(0);
                    detailEntity.setPackUpId(null);
                    detailEntity.setCode(null);
                    code = null;
                }
                Integer number = codeNumMap.get(code);
                if (number != null) {
                    number++;
                    detailEntity.setItemCode(code + String.format("%02d", number));
                    codeNumMap.put(code, number);
                } else {
                    codeNumMap.put(code, 1);
                    detailEntity.setItemCode(code + "01");
                }
                if (detailEntity.getMaterialPackId() != null) {
                    detailEntity.setMaterialListFlag(1);
                    if (detailEntity.getMaterialListId() == null) {
                        detailEntity.setMaterialListId(IdWorker.getId());
                    }
                } else {
                    detailEntity.setMaterialListFlag(0);
                    detailEntity.setMaterialListId(null);
                }
                if (detailEntity.getEngineeringPackId() != null) {
                    detailEntity.setEngineeringListFlag(1);
                    if (detailEntity.getEngineeringListId() == null) {
                        detailEntity.setEngineeringListId(IdWorker.getId());
                    }
                } else {
                    detailEntity.setEngineeringListFlag(0);
                    detailEntity.setEngineeringListId(null);
                }
            }
        }
        entity.setEngineeringPackNum(engineeringPackNum);
        entity.setMaterialPackNum(materialPackNum);
        service.saveOrUpdate(entity, false);
        BudgetProjectVO vo = BeanMapper.map(entity, BudgetProjectVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectVO> queryDetail(@RequestParam Long id) {
        BudgetProjectEntity entity = service.selectById(id);
        List<BudgetProjectDetailEntity> budgetProjectDetailList = entity.getBudgetProjectDetailList();
        List<BudgetProjectDetailEntity> projectDetailEntities = budgetProjectDetailList.stream().filter(t -> !ChangTypeConst.DELETE.equals(t.getChangeType())).collect(Collectors.toList());
        entity.setBudgetProjectDetailList(projectDetailEntities);
        BudgetProjectVO vo = BeanMapper.map(entity, BudgetProjectVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BudgetProjectVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BudgetProjectVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "parentOrgName", "employeeName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BudgetProjectEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "parentOrgName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetProjectEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("BudgetProject-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refBudgetProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectVO>> refBudgetProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetProjectEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "budgetProjectDetail-import.xlsx", "切包清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {

            int codeIndex = 0;
            int nameIndex = 1;
            int featureIndex = 2;
            int unitIndex = 3;
            int contractNumIndex = 10;
            int checkEngineeringNumIndex = 11;
            int materialPriceIndex = 17;
            int fixPriceIndex = 18;
            int bigPackNameIndex = 4;
            int puchaseFlagIndex = 5;
            int materialPackNameIndex = 6;
            int materialPackCodeIndex = 7;
            int engineeringPackNameIndex = 8;
            int engineeringPackCodeIndex = 9;
            //int itemCodeIndex = 1;
            int itemNameIndex = 14;
            int itemFeatureIndex = 15;
            int itemUnitIndex = 16;
            int itemNumIndex = 12;
            int upperMaterialPriceIndex = 21;
            int upperFixPriceIndex = 22;
            int upperPriceIndex = 23;
            int upperMoneyIndex = 24;

            List<List<String>> result = CostExcelReader.readExcel(mf);
            List<BudgetProjectDetailVO> successList = new ArrayList<>();
            List<BudgetProjectDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                /*if (result.get(0).size() != 11) {
                    throw new BusinessException("请按照导入模板导入数据");
                }*/
                Map<String, DefdocDetailVO> bigPakgMap = new HashMap<>();
                CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefCode("professional-package");
                if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
                    bigPakgMap = resp.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, v -> v, (p1, p2) -> p1));
                }

                Map<String, SubTypeVO> subTypeCodeMap = new HashMap<>();
                CommonResponse<List<SubTypeVO>> subTypeList = subTypeApi.getSubTypeList();
                if (subTypeList.isSuccess() && subTypeList.getData() != null) {
                    subTypeCodeMap = subTypeList.getData().stream().collect(Collectors.toMap(SubTypeVO::getLongCode, v -> v, (p1, p2) -> p1));
                }

                Map<String, MaterialCategoryVO> secondCategoryCodeMap = new HashMap<>();
                CommonResponse<List<MaterialCategoryVO>> secondCategoryList = materialCategoryApi.getMaterialSecondCategoryList();
                if (secondCategoryList.isSuccess() && secondCategoryList.getData() != null) {
                    secondCategoryCodeMap = secondCategoryList.getData().stream().collect(Collectors.toMap(MaterialCategoryVO::getCode, v -> v, (p1, p2) -> p1));
                }

                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errMsg = new StringBuilder();
                    BudgetProjectDetailVO detailVO = new BudgetProjectDetailVO();
                    if (StringUtils.isNotBlank(datas.get(codeIndex))) {
                        detailVO.setCode(datas.get(codeIndex).trim());
                    } else {
                        detailVO.setCode(null);
                    }
                    if (StringUtils.isNotBlank(datas.get(nameIndex))) {
                        detailVO.setName(datas.get(nameIndex).trim());
                    }
                    if (StringUtils.isNotBlank(datas.get(featureIndex))) {
                        detailVO.setFeature(datas.get(featureIndex).trim());
                    }
                    if (StringUtils.isNotBlank(datas.get(unitIndex))) {
                        detailVO.setUnit(datas.get(unitIndex).trim());
                    }
                    if (StringUtils.isNotBlank(datas.get(contractNumIndex))) {
                        detailVO.setContractNum(ComputeUtil.toBigDecimal(datas.get(contractNumIndex).replace(",", "")));
                    }
                    if (StringUtils.isNotBlank(datas.get(checkEngineeringNumIndex))) {
                        detailVO.setCheckEngineeringNum(ComputeUtil.toBigDecimal(datas.get(checkEngineeringNumIndex).replace(",", "")));
                    }
                    if (StringUtils.isNotBlank(datas.get(materialPriceIndex))) {
                        detailVO.setMaterialPrice(ComputeUtil.toBigDecimal(datas.get(materialPriceIndex).replace(",", "")));
                    }
                    if (StringUtils.isNotBlank(datas.get(fixPriceIndex))) {
                        detailVO.setFixPrice(ComputeUtil.toBigDecimal(datas.get(fixPriceIndex).replace(",", "")));
                    }
                    detailVO.setPrice(ComputeUtil.safeAdd(detailVO.getMaterialPrice(), detailVO.getFixPrice()));
                    detailVO.setMoney(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(detailVO.getPrice(), detailVO.getContractNum())));
                    if (StringUtils.isNotBlank(datas.get(bigPackNameIndex))) {
                        detailVO.setBigPackName(datas.get(bigPackNameIndex).trim());
                        DefdocDetailVO defdocDetailVO = bigPakgMap.get(detailVO.getBigPackName());
                        if (defdocDetailVO == null) {
                            errMsg.append("`大包名称未匹配`");
                        } else {
                            detailVO.setBigPackSid(defdocDetailVO.getAttrCode());
                            detailVO.setBigPackId(defdocDetailVO.getId());
                            detailVO.setBigPackCode(defdocDetailVO.getCode());
                        }
                    }
                    if (StringUtils.isNotBlank(datas.get(puchaseFlagIndex))) {
                        detailVO.setPuchaseFlag(datas.get(puchaseFlagIndex));
                    }
                    if (StringUtils.isNotBlank(datas.get(materialPackCodeIndex))) {
                        String materialPackCode = datas.get(materialPackCodeIndex).trim();
                        detailVO.setMaterialPackCode(materialPackCode);
                        MaterialCategoryVO materialCategoryVO = null;
                        if (materialPackCode.contains("-")) {
                            materialCategoryVO = secondCategoryCodeMap.get(materialPackCode.split("-")[0]);
                        } else {
                            materialCategoryVO = secondCategoryCodeMap.get(materialPackCode);
                        }
                        if (materialCategoryVO == null) {
                            errMsg.append("`材料包代码未匹配`");
                        } else {
                            detailVO.setMaterialPackSid(materialCategoryVO.getSourceId());
                            detailVO.setMaterialPackId(materialCategoryVO.getId());
                            detailVO.setMaterialPackCode(materialCategoryVO.getCode());
                            detailVO.setMaterialPackName(materialCategoryVO.getName());
                        }
                    }
                  /*  if (StringUtils.isNotBlank(datas.get(materialPackNameIndex))) {
                        detailVO.setMaterialPackName(datas.get(materialPackNameIndex).trim());
                    }*/
                    if (StringUtils.isNotBlank(datas.get(engineeringPackCodeIndex))) {
                        String materialPackCode = datas.get(engineeringPackCodeIndex).trim();
                        detailVO.setEngineeringPackCode(materialPackCode);
                        SubTypeVO subTypeVO = null;
                        if (materialPackCode.contains("-")) {
                            subTypeVO = subTypeCodeMap.get(materialPackCode.split("-")[0]);
                        } else {
                            subTypeVO = subTypeCodeMap.get(detailVO.getEngineeringPackCode());
                        }
                        if (subTypeVO == null) {
                            errMsg.append("`工程包代码未匹配`");
                        } else {
                            detailVO.setEngineeringPackSid(subTypeVO.getSourceId());
                            detailVO.setEngineeringPackId(subTypeVO.getId());
                            detailVO.setEngineeringPackCode(subTypeVO.getLongCode());
                            detailVO.setEngineeringPackName(subTypeVO.getName());
                        }
                    } else {
                        if (StringUtils.isNotBlank(detailVO.getMaterialPackCode())) {
                            errMsg.append("`材料包代码和工程包代码不能同时为空`");
                        }
                    }
                   /* if (StringUtils.isNotBlank(datas.get(engineeringPackNameIndex))) {
                        detailVO.setEngineeringPackName(datas.get(engineeringPackNameIndex).trim());
                    }*/
                 /*   if (codeNumMap.containsKey(de))) {
                        detailVO.setItemCode(datas.get(itemCodeIndex).trim());
                    }*/
                    if (StringUtils.isNotBlank(datas.get(itemNameIndex))) {
                        detailVO.setItemName(datas.get(itemNameIndex).trim());
                    }
                    if (StringUtils.isNotBlank(datas.get(itemFeatureIndex))) {
                        detailVO.setItemFeature(datas.get(itemFeatureIndex).trim());
                    }
                    if (StringUtils.isNotBlank(datas.get(itemUnitIndex))) {
                        detailVO.setItemUnit(datas.get(itemUnitIndex).trim());
                    }
                    if (StringUtils.isNotBlank(datas.get(itemNumIndex))) {
                        detailVO.setItemNum(ComputeUtil.toBigDecimal(datas.get(itemNumIndex).replace(",", "")));
                    }
                    if (StringUtils.isNotBlank(datas.get(upperMaterialPriceIndex))) {
                        detailVO.setUpperMaterialPrice(ComputeUtil.toBigDecimal(datas.get(upperMaterialPriceIndex).replace(",", "")));
                    }
                    if (StringUtils.isNotBlank(datas.get(upperFixPriceIndex))) {
                        detailVO.setUpperFixPrice(ComputeUtil.toBigDecimal(datas.get(upperFixPriceIndex).replace(",", "")));
                    }
                    detailVO.setUpperPrice(ComputeUtil.safeAdd(detailVO.getUpperMaterialPrice(), detailVO.getUpperFixPrice()));
                    detailVO.setUpperMoney(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(detailVO.getUpperPrice(), detailVO.getItemNum())));
                /*    if (StringUtils.isNotBlank(datas.get(upperPriceIndex))) {
                        detailVO.setUpperPrice(ComputeUtil.toBigDecimal(datas.get(upperPriceIndex).replace(",", "")));
                    }
                    if (StringUtils.isNotBlank(datas.get(upperMoneyIndex))) {
                        detailVO.setUpperMoney(ComputeUtil.toBigDecimal(datas.get(upperMoneyIndex).replace(",", "")));
                    }*/

                    if (StringUtils.isNotBlank(errMsg)) {
                        detailVO.setErrorMessage(errMsg.toString());
                        errorList.add(detailVO);
                    } else {
                        successList.add(detailVO);
                    }
                }
            }

            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

}
