package com.ejianc.business.zdscost.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zdscost.mapper.BudgetProjectDetailMapper;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;

import java.util.List;
import java.util.Map;

/**
 * 切包清单-明细
 *
 * @author generator
 *
 */
@Service("budgetProjectDetailService")
public class BudgetProjectDetailServiceImpl extends BaseServiceImpl<BudgetProjectDetailMapper, BudgetProjectDetailEntity> implements IBudgetProjectDetailService {

    @Override
    public List queryPackageList(Page<Map> page, BudgetProjectDetailQueryVO queryVO) {
        String projectSid = queryVO.getProjectSid();
        String paramStr = queryVO.getParamStr();
        String packageFlag = "";
        String packageCode = "";
        String packageName = "";
        if (StringUtils.isNotEmpty(paramStr)) {
            String[] split = paramStr.split(",");
            packageFlag = split.length > 0 ? split[0] : null;
            packageCode = split.length > 1 ? split[1] : null;
            packageName = split.length > 2 ? split[2] : null;
        }
        return baseMapper.queryPackageList(page, projectSid, packageFlag, packageCode, packageName);
    }
}
