/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectChangeVO;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectChange"})
@Api(value="\u5207\u5305\u6e05\u5355\u53d8\u66f4", tags={"\u5207\u5305\u6e05\u5355\u53d8\u66f4"})
public class BudgetProjectChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "BUDGET_PROJECT_CHANGE_CODE";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBudgetProjectChangeService service;
    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody BudgetProjectChangeVO saveOrUpdateVO) {
        BudgetProjectChangeEntity entity = (BudgetProjectChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BudgetProjectChangeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setChangeStatus(2);
            entity.setChangeVersion(entity.getChangeVersion() + 1);
            entity.setBillDate(new Date());
        }
        List<BudgetProjectDetailChangeEntity> detailList = entity.getBudgetProjectDetailList();
        HashMap<Object, Long> packUpMap = new HashMap<Object, Long>();
        HashMap codeNumMap = new HashMap();
        for (BudgetProjectDetailChangeEntity t : detailList) {
            List codeList;
            String code = t.getCode();
            if (StringUtils.isNotBlank((CharSequence)code) && t.getPackUpId() != null) {
                packUpMap.put(code, t.getPackUpId());
            }
            if ((codeList = (List)codeNumMap.get(code)) == null) {
                codeNumMap.put(code, new ArrayList());
            }
            if (!StringUtils.isNotBlank((CharSequence)t.getItemCode())) continue;
            ((List)codeNumMap.get(code)).add(t.getItemCode());
        }
        Integer engineeringPackNum = 0;
        Integer materialPackNum = 0;
        for (BudgetProjectDetailChangeEntity detailEntity : detailList) {
            if ("del".equals(detailEntity.getRowState()) || "2".equals(detailEntity.getChangeType())) continue;
            Integer n = engineeringPackNum;
            Integer n2 = engineeringPackNum = Integer.valueOf(engineeringPackNum + 1);
            n = materialPackNum;
            n2 = materialPackNum = Integer.valueOf(materialPackNum + 1);
            String code = detailEntity.getCode();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                detailEntity.setPackUpFlag(1);
                Long packUpId = (Long)packUpMap.get(code);
                if (packUpId == null) {
                    packUpId = IdWorker.getId();
                    packUpMap.put(code, packUpId);
                }
                detailEntity.setPackUpId(packUpId);
            } else {
                detailEntity.setPackUpFlag(0);
                detailEntity.setPackUpId(null);
                detailEntity.setCode(null);
                code = null;
            }
            if (StringUtils.isBlank((CharSequence)detailEntity.getItemCode())) {
                ArrayList<String> itemCodeList = (ArrayList<String>)codeNumMap.get(code);
                if (itemCodeList != null) {
                    Integer number = itemCodeList.size() + 1;
                    String itemCode = Optional.ofNullable(code).orElse("") + String.format("%02d", number);
                    detailEntity.setItemCode(itemCode);
                    while (itemCodeList.contains(itemCode)) {
                        Integer n3 = number;
                        Integer n4 = number = Integer.valueOf(number + 1);
                        itemCode = Optional.ofNullable(code).orElse("") + String.format("%02d", number);
                        if (itemCodeList.contains(itemCode)) continue;
                        detailEntity.setItemCode(itemCode);
                        ((List)codeNumMap.get(code)).add(itemCode);
                        break;
                    }
                } else {
                    String itemCode = Optional.ofNullable(code).orElse("") + "01";
                    detailEntity.setItemCode(itemCode);
                    itemCodeList = new ArrayList<String>();
                    itemCodeList.add(itemCode);
                    codeNumMap.put(Optional.ofNullable(code).orElse(""), itemCodeList);
                }
            }
            if (detailEntity.getMaterialPackId() != null) {
                detailEntity.setMaterialListFlag(1);
                if (detailEntity.getMaterialListId() == null) {
                    detailEntity.setMaterialListId(IdWorker.getId());
                }
            } else {
                detailEntity.setMaterialListFlag(0);
                detailEntity.setMaterialListId(null);
            }
            if (detailEntity.getEngineeringPackId() != null) {
                detailEntity.setEngineeringListFlag(1);
                if (detailEntity.getEngineeringListId() != null) continue;
                detailEntity.setEngineeringListId(IdWorker.getId());
                continue;
            }
            detailEntity.setEngineeringListFlag(0);
            detailEntity.setEngineeringListId(null);
        }
        entity.setEngineeringPackNum(engineeringPackNum);
        entity.setMaterialPackNum(materialPackNum);
        this.service.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)entity.getChangeId());
        wrapper.set(BudgetProjectEntity::getChangeId, (Object)entity.getId());
        wrapper.set(BudgetProjectEntity::getChangeCode, (Object)entity.getBillCode());
        wrapper.set(BudgetProjectEntity::getChangeStatus, (Object)BudgetProjectVO.CHANGE_STATE_CHANGING);
        this.budgetProjectService.update((Wrapper)wrapper);
        BudgetProjectChangeVO vo = (BudgetProjectChangeVO)BeanMapper.map((Object)((Object)entity), BudgetProjectChangeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> queryDetail(@RequestParam Long id) {
        BudgetProjectChangeEntity entity = (BudgetProjectChangeEntity)((Object)this.service.selectById(id));
        BudgetProjectChangeVO vo = (BudgetProjectChangeVO)BeanMapper.map((Object)((Object)entity), BudgetProjectChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addByBudgetId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> addByBudgetId(Long budgetId) {
        BudgetProjectChangeVO vo = this.service.addByBudgetId(budgetId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectChangeVO> vos) {
        BudgetProjectChangeVO changeVo = vos.get(0);
        BudgetProjectChangeEntity entity = (BudgetProjectChangeEntity)((Object)this.service.getById(changeVo.getId()));
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)entity.getChangeId());
        wrapper.set(BudgetProjectEntity::getChangeId, null);
        wrapper.set(BudgetProjectEntity::getChangeCode, null);
        wrapper.set(BudgetProjectEntity::getChangeStatus, (Object)BudgetProjectVO.CHANGE_STATE_UNCHANGED);
        this.budgetProjectService.update((Wrapper)wrapper);
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BudgetProjectChange-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refBudgetProjectChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeVO>> refBudgetProjectChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BudgetProjectChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

