package com.ejianc.business.zdscost.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 切包清单-明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetProjectDetailApi")
@Api(value = "切包清单-查询Api", tags = {"切包清单-查询Api"})
public class BudgetProjectDetailApi implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBudgetProjectService budgetProjectService;

    @Autowired
    private IBudgetProjectDetailService service;

    @ApiOperation("项目费用包接口")
    @RequestMapping(value = "/queryPackageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<Map>> queryPackageList(@RequestBody BudgetProjectDetailQueryVO queryVO) {
        if (queryVO.getProjectSid() == null || queryVO.getPageSize() == null || queryVO.getPageIndex() == null) {
            throw new BusinessException("参数项目ID[projectId/projectSid]不能为空！");
        }
        if (queryVO.getPageSize() == null) {
            throw new BusinessException("参数每页行数[pageSize]不能为空！");
        }
        if (queryVO.getPageIndex() == null) {
            throw new BusinessException("参数页码[pageIndex]不能为空！");
        }
        Page<Map> page = new Page<>((long) queryVO.getPageIndex(), (long) queryVO.getPageSize());
        List<Map> list = service.queryPackageList(page, queryVO);
        IPage<Map> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("切包清单接口")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailEntity>> queryList(@RequestBody BudgetProjectDetailQueryVO queryVO) {
        if (queryVO.getProjectId() == null && queryVO.getProjectSid() == null) {
            throw new BusinessException("参数项目ID[projectId/projectSid]不能为空！");
        }
        LambdaQueryWrapper<BudgetProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BudgetProjectEntity::getProjectSid, queryVO.getProjectSid());
        queryWrapper.in(BudgetProjectEntity::getBillState, "1,3");
        List<BudgetProjectEntity> list1 = budgetProjectService.list(queryWrapper);
        Long budgetId = 1L;
        if (CollectionUtils.isNotEmpty(list1)) {
            budgetId = list1.get(0).getId();
        }

        QueryParam queryParam = new QueryParam();
        Map<String, Parameter> params = queryParam.getParams();
        /** 租户隔离 */
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        params.put("budgetId", new Parameter(QueryParam.EQ, budgetId));
        params.put("changeType", new Parameter(QueryParam.NE, ChangTypeConst.DELETE));
        IPage<BudgetProjectDetailEntity> entityIPage = service.queryPage(queryParam, false);
        return CommonResponse.success("查询列表数据成功！", entityIPage);
    }


}
