/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.controller;

import com.ejianc.business.zdscost.bean.BudgetProjectRecordEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailRecordService;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailPackageVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailRecordVO;
import com.ejianc.business.zdscost.vo.BudgetProjectRecordVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectRecord"})
public class BudgetProjectRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetProjectRecordService service;
    @Autowired
    private IBudgetProjectDetailRecordService detailRecordService;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BudgetProjectRecordVO> queryDetail(Long id) {
        BudgetProjectRecordEntity entity = (BudgetProjectRecordEntity)((Object)this.service.selectById(id));
        BudgetProjectRecordVO vo = (BudgetProjectRecordVO)BeanMapper.map((Object)((Object)entity), BudgetProjectRecordVO.class);
        List<BudgetProjectDetailPackageVO> packageTreeList = this.detailRecordService.queryPackageTree(id);
        vo.setPackageTreeData(TreeNodeBUtil.buildTree(packageTreeList));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailRecordVO>> queryDetailList(@RequestBody BudgetProjectDetailPackageVO packageVO) {
        String packageFlag;
        Long budgetId = packageVO.getBudgetId();
        if (budgetId == null) {
            budgetId = 1L;
        }
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        Map params = queryParam.getParams();
        params.put("budgetId", new Parameter("eq", (Object)packageVO.getBudgetId()));
        params.put("changeType", new Parameter("ne", (Object)"2"));
        queryParam.setSearchText(packageVO.getSearchText());
        Long bigPackId = packageVO.getBigPackId();
        if (bigPackId != null) {
            params.put("bigPackId", new Parameter("eq", (Object)bigPackId));
        }
        if (StringUtils.isNotBlank((CharSequence)(packageFlag = packageVO.getPackageFlag()))) {
            if ("material".equals(packageFlag)) {
                params.put("materialListFlag", new Parameter("eq", (Object)1));
            } else {
                params.put("engineeringListFlag", new Parameter("eq", (Object)1));
            }
        }
        Long packId = packageVO.getPackId();
        if (StringUtils.isNotBlank((CharSequence)packageFlag) && "material".equals(packageFlag)) {
            params.put("materialPackId", new Parameter("eq", (Object)packId));
        } else {
            params.put("engineeringPackId", new Parameter("eq", (Object)packId));
        }
        List budgetProjectDetailEntities = this.detailRecordService.queryList(queryParam);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)budgetProjectDetailEntities, BudgetProjectDetailRecordVO.class));
    }
}

