/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectDetailApi"})
@Api(value="\u5207\u5305\u6e05\u5355-\u67e5\u8be2Api", tags={"\u5207\u5305\u6e05\u5355-\u67e5\u8be2Api"})
public class BudgetProjectDetailApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetProjectDetailService service;

    @ApiOperation(value="\u9879\u76ee\u8d39\u7528\u5305\u63a5\u53e3")
    @RequestMapping(value={"/queryPackageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<Map>> queryPackageList(@RequestBody BudgetProjectDetailQueryVO queryVO) {
        if (queryVO.getProjectSid() == null || queryVO.getPageSize() == null || queryVO.getPageIndex() == null) {
            throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId/projectSid]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (queryVO.getPageSize() == null) {
            throw new BusinessException("\u53c2\u6570\u6bcf\u9875\u884c\u6570[pageSize]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (queryVO.getPageIndex() == null) {
            throw new BusinessException("\u53c2\u6570\u9875\u7801[pageIndex]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Page page = new Page((long)queryVO.getPageIndex().intValue(), (long)queryVO.getPageSize().intValue());
        List<Map> list = this.service.queryPackageList((Page<Map>)page, queryVO);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5207\u5305\u6e05\u5355\u63a5\u53e3")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectDetailEntity>> queryList(@RequestBody BudgetProjectDetailQueryVO queryVO) {
        if (queryVO.getProjectId() == null && queryVO.getProjectSid() == null) {
            throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId/projectSid]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetProjectEntity::getProjectSid, (Object)queryVO.getProjectSid());
        queryWrapper.in(BudgetProjectEntity::getBillState, new Object[]{"1,3"});
        List list1 = this.budgetProjectService.list((Wrapper)queryWrapper);
        Long budgetId = 1L;
        if (CollectionUtils.isNotEmpty((Collection)list1)) {
            budgetId = ((BudgetProjectEntity)((Object)list1.get(0))).getId();
        }
        QueryParam queryParam = new QueryParam();
        Map params = queryParam.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        params.put("budgetId", new Parameter("eq", (Object)budgetId));
        params.put("changeType", new Parameter("ne", (Object)"2"));
        IPage entityIPage = this.service.queryPage(queryParam, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)entityIPage);
    }
}

