package com.ejianc.business.zdscost.service.impl;

import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.mapper.BudgetProjectChangeMapper;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectChangeVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailChangeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 切包清单变更
 *
 * @author generator
 *
 */
@Service("budgetProjectChangeService")
public class BudgetProjectChangeServiceImpl extends BaseServiceImpl<BudgetProjectChangeMapper, BudgetProjectChangeEntity> implements IBudgetProjectChangeService {

    @Autowired
    private IBudgetProjectService budgetProjectService;

    @Override
    public BudgetProjectChangeVO addByBudgetId(Long budgetId) {
        BudgetProjectEntity budgetProjectEntity = budgetProjectService.selectById(budgetId);
        BudgetProjectChangeVO changeVO = BeanMapper.map(budgetProjectEntity, BudgetProjectChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setChangeId(budgetId);
        changeVO.setChangeVersion(budgetProjectEntity.getChangeVersion() == null ? 1 : budgetProjectEntity.getChangeVersion() + 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setBillDate(new Date());
        changeVO.setId(null);
        List<BudgetProjectDetailChangeVO> detailChangeList = changeVO.getBudgetProjectDetailList();
        if (CollectionUtils.isNotEmpty(detailChangeList)) {
            detailChangeList.forEach(changeDetailVO -> {
                changeDetailVO.setChangeBid(changeDetailVO.getId());
                changeDetailVO.setChangeId(changeDetailVO.getBudgetId());
                changeDetailVO.setRowState("add");
                changeDetailVO.setChangeType("0");
            });
        }
        return changeVO;
    }
}
