package com.ejianc.business.zdscost.controller;

import java.io.Serializable;

import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailRecordEntity;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailRecordService;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailPackageVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailRecordVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdscost.bean.BudgetProjectRecordEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.vo.BudgetProjectRecordVO;

/**
 * 切包清单记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetProjectRecord")
public class BudgetProjectRecordController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBudgetProjectRecordService service;

    @Autowired
    private IBudgetProjectDetailRecordService detailRecordService;


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectRecordVO> queryDetail(Long id) {
        BudgetProjectRecordEntity entity = service.selectById(id);
        BudgetProjectRecordVO vo = BeanMapper.map(entity, BudgetProjectRecordVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryPackageTree", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailPackageVO>> queryPackageTree(@RequestParam Long id) {
        List<BudgetProjectDetailPackageVO> packageTreeList = detailRecordService.queryPackageTree(id);
        List<BudgetProjectDetailPackageVO> budgetProjectDetailPackageVOS = TreeNodeBUtil.buildTree(packageTreeList);
        return CommonResponse.success("查询详情数据成功！", budgetProjectDetailPackageVOS);
    }

    /**
     * @Description queryDetailList 按包展示查询列表
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailRecordVO>> queryDetailList(@RequestBody BudgetProjectDetailPackageVO packageVO) {
        Long budgetId = packageVO.getBudgetId();
        if (budgetId == null) {
            budgetId = 1L;
        }
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        Map<String, Parameter> params = queryParam.getParams();
        params.put("budgetId", new Parameter(QueryParam.EQ, packageVO.getBudgetId()));
        params.put("changeType", new Parameter(QueryParam.NE, ChangTypeConst.DELETE));
        queryParam.setSearchText(packageVO.getSearchText());

        Long bigPackId = packageVO.getBigPackId();
        if (bigPackId != null) {
            params.put("bigPackId", new Parameter(QueryParam.EQ, bigPackId));
        }
        String packageFlag = packageVO.getPackageFlag();
        if (StringUtils.isNotBlank(packageFlag)) {
            if ("material".equals(packageFlag)) {
                params.put("materialListFlag", new Parameter(QueryParam.EQ, 1));
            } else {
                params.put("engineeringListFlag", new Parameter(QueryParam.EQ, 1));
            }
        }

        Long packId = packageVO.getPackId();
        if (StringUtils.isNotBlank(packageFlag) && "material".equals(packageFlag)) {
            params.put("materialPackId", new Parameter(QueryParam.EQ, packId));
        } else {
            params.put("engineeringPackId", new Parameter(QueryParam.EQ, packId));
        }

        List<BudgetProjectDetailRecordEntity> budgetProjectDetailEntities = detailRecordService.queryList(queryParam);
        return CommonResponse.success("查询列表数据成功！", BeanMapper.mapList(budgetProjectDetailEntities, BudgetProjectDetailRecordVO.class));
    }


}
