/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectRecordEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectChange")
public class BudgetProjectChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBudgetProjectChangeService changeService;
    @Autowired
    private IBudgetProjectService service;
    @Autowired
    private IBudgetProjectDetailService detailService;
    @Autowired
    private IBudgetProjectRecordService recordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectChangeEntity changeEntity = (BudgetProjectChangeEntity)((Object)this.changeService.selectById(billId));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(BudgetProjectChangeEntity::getEffectiveTime, (Object)new Date());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getId());
        this.changeService.update((Wrapper)updateWrapper);
        BudgetProjectEntity budgetProjectEntity = (BudgetProjectEntity)((Object)this.service.selectById(changeEntity.getChangeId()));
        List<BudgetProjectDetailEntity> projectDetailEntities = budgetProjectEntity.getBudgetProjectDetailList().stream().filter(t -> !"2".equals(t.getChangeType())).collect(Collectors.toList());
        budgetProjectEntity.setBudgetProjectDetailList(projectDetailEntities);
        HashMap contIdVersionMap = new HashMap();
        BudgetProjectRecordEntity recordEntity = (BudgetProjectRecordEntity)((Object)BeanMapper.map((Object)((Object)budgetProjectEntity), BudgetProjectRecordEntity.class));
        recordEntity.setBillCode(budgetProjectEntity.getBillCode() + "-" + budgetProjectEntity.getChangeVersion());
        recordEntity.setChangeId(changeEntity.getId());
        recordEntity.setChangeCode(changeEntity.getBillCode());
        recordEntity.setChangeReason(changeEntity.getChangeReason());
        recordEntity.setEffectiveTime(new Date());
        recordEntity.setCreateTime(changeEntity.getCreateTime());
        recordEntity.setId(null);
        recordEntity.setOriginBudgetId(budgetProjectEntity.getId());
        recordEntity.setOptType(changeEntity.getOptType());
        if (CollectionUtils.isNotEmpty(recordEntity.getBudgetProjectDetailList())) {
            recordEntity.getBudgetProjectDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setChangeBid(vo.getId());
                vo.setChangeId(vo.getBudgetId());
                vo.setId(null);
                vo.setVersion(null);
            });
        }
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        budgetProjectEntity.setChangeId(null);
        budgetProjectEntity.setChangeStatus(BudgetProjectVO.CHANGE_STATE_CHANGED);
        budgetProjectEntity.setChangeVersion(changeEntity.getChangeVersion());
        budgetProjectEntity.setEffectiveTime(new Date());
        budgetProjectEntity.setMaterialPackNum(changeEntity.getMaterialPackNum());
        budgetProjectEntity.setEngineeringPackNum(changeEntity.getEngineeringPackNum());
        this.service.updateById((Object)budgetProjectEntity);
        BudgetProjectEntity contractChangeEntity = (BudgetProjectEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), BudgetProjectEntity.class));
        List<BudgetProjectDetailEntity> budgetProjectDetailList = contractChangeEntity.getBudgetProjectDetailList();
        if (CollectionUtils.isNotEmpty(budgetProjectDetailList)) {
            budgetProjectDetailList.forEach(contractDetailEntity -> {
                Long changeBid = contractDetailEntity.getChangeBid();
                contractDetailEntity.setBudgetId(changeEntity.getChangeId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                contractDetailEntity.setChangeId(contractDetailEntity.getId());
                contractDetailEntity.setId(changeBid);
                contractDetailEntity.setVersion((Integer)contIdVersionMap.get(changeBid));
            });
            this.detailService.saveOrUpdateBatch(budgetProjectDetailList, budgetProjectDetailList.size(), false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

