package com.ejianc.business.zdscost.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectRecordEntity;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("budgetProjectChange")
public class BudgetProjectChangeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBudgetProjectChangeService changeService;

    @Autowired
    private IBudgetProjectService service;

    @Autowired
    private IBudgetProjectDetailService detailService;

    @Autowired
    private IBudgetProjectRecordService recordService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        /**更新变更的审批时间  begin */
        BudgetProjectChangeEntity changeEntity = changeService.selectById(billId);
        LambdaUpdateWrapper<BudgetProjectChangeEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BudgetProjectChangeEntity::getEffectiveTime, new Date());
        updateWrapper.eq(BudgetProjectChangeEntity::getId, changeEntity.getId());
        changeService.update(updateWrapper);
        /**更新变更的审批时间  end */

        BudgetProjectEntity contractChangeEntity = BeanMapper.map(changeEntity, BudgetProjectEntity.class);
        List<BudgetProjectDetailEntity> budgetProjectDetailList = contractChangeEntity.getBudgetProjectDetailList();
        List<BudgetProjectDetailEntity> sourceItemIds = budgetProjectDetailList.stream().filter(t -> t.getChangeBid() != null).collect(Collectors.toList());

        /**复制合同表数据到记录表 begin */
        BudgetProjectEntity budgetProjectEntity = service.selectById(changeEntity.getChangeId());
        Map<Long, Integer> contIdVersionMap = new HashMap<>();
        BudgetProjectRecordEntity recordEntity = BeanMapper.map(budgetProjectEntity, BudgetProjectRecordEntity.class);
        recordEntity.setBillCode(budgetProjectEntity.getBillCode() + "-" + budgetProjectEntity.getChangeVersion());
        recordEntity.setChangeId(changeEntity.getId());
        recordEntity.setChangeCode(changeEntity.getBillCode());
        recordEntity.setChangeReason(changeEntity.getChangeReason());
        recordEntity.setEffectiveTime(new Date());
        recordEntity.setCreateTime(changeEntity.getCreateTime());
        recordEntity.setId(null);
        recordEntity.setOriginBudgetId(budgetProjectEntity.getId());
        recordEntity.setOptType(changeEntity.getOptType());

        Set<String> engineeringPackNum = new HashSet();
        Set<String> materialPackNum = new HashSet<>();
        if (CollectionUtils.isNotEmpty(recordEntity.getBudgetProjectDetailList())) {
            recordEntity.getBudgetProjectDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setChangeBid(vo.getId());
                vo.setChangeId(vo.getBudgetId());
                vo.setId(null);
                vo.setVersion(null);
                if (!sourceItemIds.contains(vo.getId())) {
                    if (StringUtils.isNotBlank(vo.getMaterialPackCode())) {
                        materialPackNum.add(vo.getMaterialPackCode());
                    }
                    if (StringUtils.isNotBlank(vo.getEngineeringPackCode())) {
                        engineeringPackNum.add(vo.getEngineeringPackCode());
                    }
                }
            });
        }
        recordService.saveOrUpdate(recordEntity, false);
        /**复制合同表数据到记录表 end */


        /**复制合同子表数据 begin */
        List<Long> delIds = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(budgetProjectDetailList)) {
            budgetProjectDetailList.forEach(contractDetailEntity -> {
                //记录虚拟父子关系
                Long changeBid = contractDetailEntity.getChangeBid();
                contractDetailEntity.setBudgetId(changeEntity.getChangeId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                contractDetailEntity.setChangeId(contractDetailEntity.getId());
                contractDetailEntity.setId(changeBid);
                contractDetailEntity.setVersion(contIdVersionMap.get(changeBid));
                if (ChangTypeConst.DELETE.equals(contractDetailEntity.getChangeType())) {
                    if (changeBid != null) {
                        delIds.add(changeBid);
                    }
                } else {
                    if (StringUtils.isNotBlank(contractDetailEntity.getMaterialPackCode())) {
                        materialPackNum.add(contractDetailEntity.getMaterialPackCode());
                    }
                    if (StringUtils.isNotBlank(contractDetailEntity.getEngineeringPackCode())) {
                        engineeringPackNum.add(contractDetailEntity.getEngineeringPackCode());
                    }
                }
            });
            detailService.saveOrUpdateBatch(budgetProjectDetailList, budgetProjectDetailList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(delIds)) {
            detailService.removeByIds(delIds);
        }


        /**更新变更表表头数据到合同 begin */
        LambdaUpdateWrapper<BudgetProjectEntity> updateWr = new LambdaUpdateWrapper<>();
        updateWr.eq(BudgetProjectEntity::getId, budgetProjectEntity.getId());
        updateWr.set(BudgetProjectEntity::getChangeId, null);
        updateWr.set(BudgetProjectEntity::getChangeStatus, BudgetProjectVO.CHANGE_STATE_CHANGED);
        updateWr.set(BudgetProjectEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWr.set(BudgetProjectEntity::getEffectiveTime, new Date());
        updateWr.set(BudgetProjectEntity::getMaterialPackNum, materialPackNum.size());
        updateWr.set(BudgetProjectEntity::getEngineeringPackNum, engineeringPackNum.size());
        service.update(updateWr);
        /**更新变更表表头数据到合同 end */
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error("变更单暂不支持回退功能!");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
