package com.ejianc.business.zdscost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.*;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.util.CostExcelReader;
import com.ejianc.business.zdscost.util.ZDSTreeNodeBUtil;
import com.ejianc.business.zdscost.vo.BudgetProjectChangeVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailChangeVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailPackageVO;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.business.zdscost.vo.query.PackageQueryVO;
import com.ejianc.business.zdsmaterial.erp.api.IZDSSubTypeApi;
import com.ejianc.business.zdsmaterial.material.api.IZDSMaterialCategoryApi;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.SubTypeVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.api.IZDSMaterialConjectureApi;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 切包清单变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("budgetProjectChange")
@Api(value = "切包清单变更", tags = {"切包清单变更"})
public class BudgetProjectChangeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "BUDGET_PROJECT_CHANGE_CODE";

    @Autowired
    private IZDSSubTypeApi subTypeApi;

    @Autowired
    private IZDSMaterialCategoryApi materialCategoryApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IBudgetProjectChangeService service;

    @Autowired
    private IBudgetProjectService budgetProjectService;

    @Autowired
    private IBudgetProjectDetailChangeService detailChangeService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBudgetProjectRecordService recordService;

    @Autowired
    private IZDSMaterialConjectureApi materialConjectureApi;

    @ApiOperation("ai物料识别")
    @RequestMapping(value = "/materialConjecture", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> materialConjecture(@RequestParam Long id) {
        BudgetProjectChangeEntity entity = service.selectById(id);
        List<BudgetProjectDetailChangeEntity> budgetProjectDetailList = entity.getBudgetProjectDetailList();
        List<BudgetProjectDetailChangeEntity> projectDetailEntities = budgetProjectDetailList.stream().filter(t -> StringUtils.isNotBlank(t.getItemFeature()) && !ChangTypeConst.DELETE.equals(t.getChangeType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(projectDetailEntities)) {
            return CommonResponse.success("没有需要识别的物料！");
        }
        String uuid = UUID.randomUUID().toString();
        List<MaterialConjectureVO> materialConjectureVOS = new ArrayList<>();
        MaterialConjectureVO materialConjectureVO = null;
        for (BudgetProjectDetailChangeEntity projectDetailEntity : projectDetailEntities) {
            materialConjectureVO = new MaterialConjectureVO();
            materialConjectureVO.setSourceMaterialName(projectDetailEntity.getItemFeature());
            materialConjectureVO.setSourceMaterialSpec(projectDetailEntity.getItemFeature());
            materialConjectureVO.setIdentificationId(uuid);
            materialConjectureVO.setMateType("4");
            materialConjectureVO.setIdentificationDate(new Date());
            materialConjectureVO.setBudgetDetailId(projectDetailEntity.getId());
            materialConjectureVO.setBillId(id);
            materialConjectureVO.setBillCode(entity.getBillCode());
            materialConjectureVOS.add(materialConjectureVO);
        }
        materialConjectureApi.materialConjecture(materialConjectureVOS);
        return CommonResponse.success("识别物料中，请稍后！");
    }


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody BudgetProjectChangeVO saveOrUpdateVO) {
        BudgetProjectChangeEntity entity = BeanMapper.map(saveOrUpdateVO, BudgetProjectChangeEntity.class);
        List<BudgetProjectDetailChangeEntity> detailList = entity.getBudgetProjectDetailList();
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setChangeStatus(2);
            entity.setBillDate(new Date());
        }

        // 上包清单code map
        Map<String, Long> packUpMap = new HashMap<>();
        Map<String, List<String>> codeNumMap = new HashMap<>();
        for (BudgetProjectDetailChangeEntity t : detailList) {
            String code = t.getCode();
            if (t.getPackUpId() != null) {
                packUpMap.put(code, t.getPackUpId());
            }
            List<String> codeList = codeNumMap.get(code);
            if (codeList == null) {
                codeNumMap.put(code, new ArrayList<>());
            }
            if (StringUtils.isNotBlank(t.getItemCode())) {
                // 该项目编码时，下包项目编码清空，然后重新生成
                if (StringUtils.isNotBlank(code) && !t.getItemCode().startsWith(code)) {
                    t.setItemCode(null);
                    continue;
                }
                codeNumMap.get(code).add(t.getItemCode());
            }
        }

        Set<String> engineeringPackNum = new HashSet();
        Set<String> materialPackNum = new HashSet<>();
        for (BudgetProjectDetailChangeEntity detailEntity : detailList) {
            if (!"del".equals(detailEntity.getRowState()) && !ChangTypeConst.DELETE.equals(detailEntity.getChangeType())) {
                String code = detailEntity.getCode();
                if (StringUtils.isNotBlank(code)) {
                    detailEntity.setPackUpFlag(1);
                    Long packUpId = packUpMap.get(code);
                    if (packUpId == null) {
                        packUpId = IdWorker.getId();
                        packUpMap.put(code, packUpId);
                    }
                    detailEntity.setPackUpId(packUpId);
                } else {
                    detailEntity.setPackUpFlag(0);
                    detailEntity.setPackUpId(null);
                    detailEntity.setCode(null);
                    code = null;
                }
                if (StringUtils.isBlank(detailEntity.getItemCode())) {
                    List<String> itemCodeList = codeNumMap.get(code);
                    if (itemCodeList != null) {
                        Integer number = itemCodeList.size() + 1;
                        String itemCode = Optional.ofNullable(code).orElse("") + String.format("%02d", number);
                        detailEntity.setItemCode(itemCode);
                        while (itemCodeList.contains(itemCode)) {
                            number++;
                            itemCode = Optional.ofNullable(code).orElse("") + String.format("%02d", number);
                            if (!itemCodeList.contains(itemCode)) {
                                detailEntity.setItemCode(itemCode);
                                codeNumMap.get(code).add(itemCode);
                                break;
                            }
                        }
                    } else {
                        String itemCode = Optional.ofNullable(code).orElse("") + "01";
                        detailEntity.setItemCode(itemCode);
                        itemCodeList = new ArrayList<>();
                        itemCodeList.add(itemCode);
                        codeNumMap.put(Optional.ofNullable(code).orElse(""), itemCodeList);
                    }
                }

                if (detailEntity.getMaterialPackId() != null) {
                    materialPackNum.add(detailEntity.getMaterialPackCode());
                    detailEntity.setMaterialListFlag(1);
                    if (detailEntity.getMaterialListId() == null) {
                        detailEntity.setMaterialListId(IdWorker.getId());
                    }
                } else {
                    detailEntity.setMaterialListFlag(0);
                    detailEntity.setMaterialListId(null);
                }
                if (detailEntity.getEngineeringPackId() != null) {
                    engineeringPackNum.add(detailEntity.getEngineeringPackCode());
                    detailEntity.setEngineeringListFlag(1);
                    if (detailEntity.getEngineeringListId() == null) {
                        detailEntity.setEngineeringListId(IdWorker.getId());
                    }
                } else {
                    detailEntity.setEngineeringListFlag(0);
                    detailEntity.setEngineeringListId(null);
                }
            }
        }
        entity.setEngineeringPackNum(engineeringPackNum.size());
        entity.setMaterialPackNum(materialPackNum.size());

        service.saveOrUpdate(entity, false);
        LambdaUpdateWrapper<BudgetProjectEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BudgetProjectEntity::getId, entity.getChangeId());
        wrapper.set(BudgetProjectEntity::getChangeId, entity.getId());
        wrapper.set(BudgetProjectEntity::getChangeCode, entity.getBillCode());
        wrapper.set(BudgetProjectEntity::getChangeStatus, BudgetProjectVO.CHANGE_STATE_CHANGING);
        budgetProjectService.update(wrapper);
        BudgetProjectChangeVO vo = BeanMapper.map(entity, BudgetProjectChangeVO.class);
        return CommonResponse.success("保存或修改单据成功！", queryDetail(vo.getId()).getData());
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> queryDetail(@RequestParam Long id) {
        BudgetProjectChangeEntity entity = service.selectById(id);
        BudgetProjectChangeVO vo = BeanMapper.map(entity, BudgetProjectChangeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryPackageTree", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailPackageVO>> queryPackageTree(@RequestParam Long id) {
        List<BudgetProjectDetailPackageVO> packageTreeList = detailChangeService.queryPackageTree(id);
        List<BudgetProjectDetailPackageVO> budgetProjectDetailPackageVOS = ZDSTreeNodeBUtil.buildTree(packageTreeList);
        return CommonResponse.success("查询详情数据成功！", budgetProjectDetailPackageVOS);
    }

    /**
     * @Description queryDetailList 按包展示查询列表
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<BudgetProjectDetailChangeVO>> queryDetailList(@RequestBody BudgetProjectDetailPackageVO packageVO) {
        Long budgetId = packageVO.getBudgetId();
        if (budgetId == null) {
            budgetId = 1L;
        }
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        Map<String, Parameter> params = queryParam.getParams();
        params.put("budgetId", new Parameter(QueryParam.EQ, packageVO.getBudgetId()));
        params.put("changeType", new Parameter(QueryParam.NE, ChangTypeConst.DELETE));
        queryParam.setSearchText(packageVO.getSearchText());

        Long bigPackId = packageVO.getBigPackId();
        if (bigPackId != null) {
            params.put("bigPackId", new Parameter(QueryParam.EQ, bigPackId));
        }
        String packageFlag = packageVO.getPackageFlag();
        if (StringUtils.isNotBlank(packageFlag)) {
            if ("material".equals(packageFlag)) {
                params.put("materialListFlag", new Parameter(QueryParam.EQ, 1));
            } else {
                params.put("engineeringListFlag", new Parameter(QueryParam.EQ, 1));
            }
        }

        String code = packageVO.getCode();
        if (StringUtils.isNotBlank(code)) {
            if ("material".equals(packageFlag)) {
                params.put("materialPackCode", new Parameter(QueryParam.EQ, code));
            } else {
                params.put("engineeringPackCode", new Parameter(QueryParam.EQ, code));
            }
        }

        List<BudgetProjectDetailChangeEntity> budgetProjectDetailEntities = detailChangeService.queryList(queryParam);
        return CommonResponse.success("查询列表数据成功！", BeanMapper.mapList(budgetProjectDetailEntities, BudgetProjectDetailChangeVO.class));
    }

    @RequestMapping(value = "/addByBudgetId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BudgetProjectChangeVO> addByBudgetId(@RequestBody PackageQueryVO packageQueryVO) {
        BudgetProjectChangeVO vo = service.addByBudgetId(packageQueryVO);
        return CommonResponse.success("新增转换数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BudgetProjectChangeVO> vos) {
        BudgetProjectChangeVO changeVo = vos.get(0);
        BudgetProjectChangeEntity entity = service.getById(changeVo.getId());
        Long id = entity.getChangeId();
        LambdaQueryWrapper<BudgetProjectRecordEntity> recordEntityLambdaUpdateWrapper = new LambdaQueryWrapper<>();
        recordEntityLambdaUpdateWrapper.eq(BudgetProjectRecordEntity::getOriginBudgetId, id);
        int count = recordService.count(recordEntityLambdaUpdateWrapper);
        LambdaUpdateWrapper<BudgetProjectEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BudgetProjectEntity::getId, id);
        wrapper.set(BudgetProjectEntity::getChangeId, null);
        wrapper.set(BudgetProjectEntity::getChangeCode, null);
        wrapper.set(BudgetProjectEntity::getChangeStatus, count == 0 ? BudgetProjectVO.CHANGE_STATE_UNCHANGED : BudgetProjectVO.CHANGE_STATE_CHANGED);
        budgetProjectService.update(wrapper);
        service.removeByIds(vos.stream().map(BudgetProjectChangeVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BudgetProjectChangeEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectChangeVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "parentOrgName", "employeeName"));
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BudgetProjectChangeEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("BudgetProject-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportDetail", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDetail(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BudgetProjectDetailChangeEntity> list = detailChangeService.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("budgetProjectDetail-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refBudgetProjectChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BudgetProjectChangeVO>> refBudgetProjectChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                   String condition,
                                                                                   String searchObject,
                                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BudgetProjectChangeEntity> page = service.queryPage(param, false);
        IPage<BudgetProjectChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BudgetProjectChangeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "budgetProjectDetail-import.xlsx", "切包清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, @RequestParam Long id) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {

            int codeIndex = 0;
            int nameIndex = 1;
            int featureIndex = 2;
            int unitIndex = 3;
            int contractNumIndex = 10;
            int checkEngineeringNumIndex = 11;
            int materialPriceIndex = 17;
            int fixPriceIndex = 18;
            int bigPackNameIndex = 4;
            int puchaseFlagIndex = 5;
            int materialPackNameIndex = 6;
            int materialPackCodeIndex = 7;
            int engineeringPackNameIndex = 8;
            int engineeringPackCodeIndex = 9;
            int itemCodeIndex = 13;
            int itemNameIndex = 14;
            int itemFeatureIndex = 15;
            int itemUnitIndex = 16;
            int itemNumIndex = 12;
            int upperMaterialPriceIndex = 21;
            int upperFixPriceIndex = 22;
            int upperPriceIndex = 23;
            int upperMoneyIndex = 24;

            List<List<String>> result = CostExcelReader.readExcel(mf);
            List<BudgetProjectDetailChangeVO> successList = new ArrayList<>();
            List<BudgetProjectDetailChangeVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                /*if (result.get(0).size() != 11) {
                    throw new BusinessException("请按照导入模板导入数据");
                }*/
                Map<String, DefdocDetailVO> bigPakgMap = new HashMap<>();
                CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefCode("professional-package");
                if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
                    bigPakgMap = resp.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, v -> v, (p1, p2) -> p1));
                }

                Map<String, SubTypeVO> subTypeCodeMap = new HashMap<>();
                CommonResponse<List<SubTypeVO>> subTypeList = subTypeApi.getSubTypeList();
                if (subTypeList.isSuccess() && subTypeList.getData() != null) {
                    subTypeCodeMap = subTypeList.getData().stream().collect(Collectors.toMap(SubTypeVO::getLongCode, v -> v, (p1, p2) -> p1));
                }

                Map<String, MaterialCategoryVO> secondCategoryCodeMap = new HashMap<>();
                CommonResponse<List<MaterialCategoryVO>> secondCategoryList = materialCategoryApi.getMaterialSecondCategoryList();
                if (secondCategoryList.isSuccess() && secondCategoryList.getData() != null) {
                    secondCategoryCodeMap = secondCategoryList.getData().stream().collect(Collectors.toMap(MaterialCategoryVO::getCode, v -> v, (p1, p2) -> p1));
                }

                BudgetProjectChangeEntity changeEntity = service.getById(id);
                String optType = changeEntity.getOptType();
                LambdaQueryWrapper<BudgetProjectDetailChangeEntity> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(BudgetProjectDetailChangeEntity::getBudgetId, id);
                List<BudgetProjectDetailChangeEntity> oldListen = detailChangeService.list(wrapper);
                List<BudgetProjectDetailChangeVO> oldList = BeanMapper.mapList(oldListen, BudgetProjectDetailChangeVO.class);
                Map<String, BudgetProjectDetailChangeVO> codeOldDataMap = new HashMap<>();
                Map<String, BudgetProjectDetailChangeVO> itemCodeOldDataMap = new HashMap<>();
                // 上包清单code map
                Map<String, Long> packUpMap = new HashMap<>();
                for (BudgetProjectDetailChangeVO detailChangeVO : oldList) {
                    itemCodeOldDataMap.put(detailChangeVO.getItemCode(), detailChangeVO);
                    codeOldDataMap.put(detailChangeVO.getCode(), detailChangeVO);
                    String code = detailChangeVO.getCode();
                    if (detailChangeVO.getPackUpId() != null) {
                        packUpMap.put(code, detailChangeVO.getPackUpId());
                    }
                }
                // 变更
                if ("BG".equals(optType)) {

                    for (int i = 0; i < result.size(); i++) {
                        List<String> datas = result.get(i);
                        StringBuilder errMsg = new StringBuilder();
                        BudgetProjectDetailChangeVO detailVO = new BudgetProjectDetailChangeVO();
                        if (StringUtils.isNotBlank(datas.get(codeIndex))) {
                            detailVO.setCode(datas.get(codeIndex).trim());
                        } else {
                            detailVO.setCode(null);
                        }
                        if (StringUtils.isNotBlank(datas.get(nameIndex))) {
                            detailVO.setName(datas.get(nameIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(featureIndex))) {
                            detailVO.setFeature(datas.get(featureIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(unitIndex))) {
                            detailVO.setUnit(datas.get(unitIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(contractNumIndex))) {
                            detailVO.setContractNum(ComputeUtil.toBigDecimal(datas.get(contractNumIndex).replace(",", "")));
                        }
                        if (StringUtils.isNotBlank(datas.get(checkEngineeringNumIndex))) {
                            detailVO.setCheckEngineeringNum(ComputeUtil.toBigDecimal(datas.get(checkEngineeringNumIndex).replace(",", "")));
                        }
                        if (StringUtils.isNotBlank(datas.get(materialPriceIndex))) {
                            detailVO.setMaterialPrice(ComputeUtil.toBigDecimal(datas.get(materialPriceIndex).replace(",", "")));
                        }
                        if (StringUtils.isNotBlank(datas.get(fixPriceIndex))) {
                            detailVO.setFixPrice(ComputeUtil.toBigDecimal(datas.get(fixPriceIndex).replace(",", "")));
                        }
                        detailVO.setPrice(ComputeUtil.safeAdd(detailVO.getMaterialPrice(), detailVO.getFixPrice()));
                        detailVO.setMoney(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(detailVO.getPrice(), detailVO.getContractNum())));
                        if (StringUtils.isNotBlank(datas.get(bigPackNameIndex))) {
                            detailVO.setBigPackName(datas.get(bigPackNameIndex).trim());
                            DefdocDetailVO defdocDetailVO = bigPakgMap.get(detailVO.getBigPackName());
                            if (defdocDetailVO == null) {
                                errMsg.append("`大包名称未匹配`");
                            } else {
                                detailVO.setBigPackSid(defdocDetailVO.getAttrCode());
                                detailVO.setBigPackId(defdocDetailVO.getId());
                                detailVO.setBigPackCode(defdocDetailVO.getCode());
                            }
                        } else {
                            errMsg.append("`大包名称不能为空`");
                        }

                        if (StringUtils.isNotBlank(datas.get(puchaseFlagIndex))) {
                            detailVO.setPuchaseFlag(datas.get(puchaseFlagIndex));
                        } else {
                            errMsg.append("`是否公司采购不能为空`");
                        }
                        if (StringUtils.isNotBlank(datas.get(materialPackCodeIndex))) {
                            String materialPackCode = datas.get(materialPackCodeIndex).trim();
                            detailVO.setMaterialPackCode(materialPackCode);
                            MaterialCategoryVO materialCategoryVO = null;
                            if (materialPackCode.contains("-")) {
                                materialCategoryVO = secondCategoryCodeMap.get(materialPackCode.split("-")[0]);
                            } else {
                                materialCategoryVO = secondCategoryCodeMap.get(materialPackCode);
                            }
                            if (materialCategoryVO == null) {
                                errMsg.append("`材料包代码未匹配`");
                            } else {
                                detailVO.setMaterialPackSid(materialCategoryVO.getSourceId());
                                detailVO.setMaterialPackId(materialCategoryVO.getId());
                                detailVO.setMaterialPackName(materialCategoryVO.getName());
                            }
                        }
                        if (StringUtils.isNotBlank(datas.get(engineeringPackCodeIndex))) {
                            String materialPackCode = datas.get(engineeringPackCodeIndex).trim();
                            detailVO.setEngineeringPackCode(materialPackCode);
                            SubTypeVO subTypeVO = null;
                            if (materialPackCode.contains("-")) {
                                subTypeVO = subTypeCodeMap.get(materialPackCode.split("-")[0]);
                            } else {
                                subTypeVO = subTypeCodeMap.get(detailVO.getEngineeringPackCode());
                            }
                            if (subTypeVO == null) {
                                errMsg.append("`工程包代码未匹配`");
                            } else {
                                detailVO.setEngineeringPackSid(subTypeVO.getSourceId());
                                detailVO.setEngineeringPackId(subTypeVO.getId());
                                detailVO.setEngineeringPackName(subTypeVO.getName());
                            }
                        } else {
                            if (StringUtils.isBlank(detailVO.getMaterialPackCode())) {
                                errMsg.append("`材料包代码和工程包代码不能同时为空`");
                            }
                        }
                        if (StringUtils.isNotBlank(datas.get(itemCodeIndex)) && StringUtils.isNotBlank(detailVO.getCode())) {
                            String itemCode = datas.get(itemCodeIndex).trim();
                            if (StringUtils.isNotBlank(itemCode) && !itemCode.startsWith(detailVO.getCode())) {
                                detailVO.setItemCode(null);
                            }
                        }
                        if (StringUtils.isNotBlank(datas.get(itemCodeIndex))) {
                            detailVO.setItemCode(datas.get(itemCodeIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(itemNameIndex))) {
                            detailVO.setItemName(datas.get(itemNameIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(itemFeatureIndex))) {
                            detailVO.setItemFeature(datas.get(itemFeatureIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(itemUnitIndex))) {
                            detailVO.setItemUnit(datas.get(itemUnitIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(itemNumIndex))) {
                            detailVO.setItemNum(ComputeUtil.toBigDecimal(datas.get(itemNumIndex).replace(",", "")));
                        }
                        if (StringUtils.isNotBlank(datas.get(upperMaterialPriceIndex))) {
                            detailVO.setUpperMaterialPrice(ComputeUtil.toBigDecimal(datas.get(upperMaterialPriceIndex).replace(",", "")));
                        }
                        if (StringUtils.isNotBlank(datas.get(upperFixPriceIndex))) {
                            detailVO.setUpperFixPrice(ComputeUtil.toBigDecimal(datas.get(upperFixPriceIndex).replace(",", "")));
                        }
                        detailVO.setUpperPrice(ComputeUtil.safeAdd(detailVO.getUpperMaterialPrice(), detailVO.getUpperFixPrice()));
                        detailVO.setUpperMoney(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(detailVO.getUpperPrice(), detailVO.getCheckEngineeringNum())));

                        if (StringUtils.isNotBlank(errMsg)) {
                            detailVO.setErrorMessage(errMsg.toString());
                            errorList.add(detailVO);
                        } else {
                            // 如果下包项目编码不为空
                            if (StringUtils.isNotBlank(datas.get(itemCodeIndex))) {
                                String itemCode = datas.get(itemCodeIndex).trim();
                                BudgetProjectDetailChangeVO oldDetailChangeVO = itemCodeOldDataMap.get(itemCode);
                                if (oldDetailChangeVO != null) {
                                    // 覆盖数据
                                    List<CompareDifferenceUtil.FieldDifference> fieldDifferences = CompareDifferenceUtil.compareObj(oldDetailChangeVO, detailVO);
                                    detailVO.setId(oldDetailChangeVO.getId());
                                    detailVO.setBudgetId(oldDetailChangeVO.getBudgetId());
                                    detailVO.setVersion(oldDetailChangeVO.getVersion());
                                    detailVO.setTenantId(oldDetailChangeVO.getTenantId());
                                    detailVO.setCreateUserCode(oldDetailChangeVO.getCreateUserCode());
                                    detailVO.setCreateTime(oldDetailChangeVO.getCreateTime());
                                    detailVO.setUpdateUserCode(oldDetailChangeVO.getUpdateUserCode());
                                    detailVO.setUpdateTime(oldDetailChangeVO.getUpdateTime());
                                    detailVO.setPackUpId(packUpMap.get(detailVO.getCode()));
                                    detailVO.setPackUpFlag(oldDetailChangeVO.getPackUpFlag());
                                    detailVO.setChangeId(oldDetailChangeVO.getChangeId());
                                    detailVO.setChangeBid(oldDetailChangeVO.getChangeBid());
                                    if (detailVO.getMaterialPackId() != null) {
                                        detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                                    }
                                    if (detailVO.getEngineeringPackId() != null) {
                                        detailVO.setEngineeringListId(oldDetailChangeVO.getEngineeringListId());
                                    }
                                    if (detailVO.getMaterialPackId() != null) {
                                        detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                                    }
                                    if ("update".equals(detailVO.getChangeFlag())) {
                                        detailVO.setChangeType(ChangTypeConst.UPDATE);
                                    } else {
                                        detailVO.setChangeType(ChangTypeConst.UNCHANGED);
                                    }
                                    itemCodeOldDataMap.remove(itemCode);
                                } else {
                                    //为空一定是新增项
                                    detailVO.setChangeType(ChangTypeConst.ADD);
                                    detailVO.setItemCode(null);
                                    detailVO.setId(IdWorker.getId());
                                }

                            } else {
                                //为空一定是新增项
                                detailVO.setChangeType(ChangTypeConst.ADD);
                                detailVO.setItemCode(null);
                                detailVO.setId(IdWorker.getId());
                            }
                            successList.add(detailVO);
                        }
                    }
                    // 剩余未匹配到的说明是删除，理论上这里应该为空，因为导入excel不支持删除操作
                    if (MapUtils.isNotEmpty(itemCodeOldDataMap)) {
                        for (BudgetProjectDetailChangeVO detailChangeVO : itemCodeOldDataMap.values()) {
                            detailChangeVO.setRowState("edit");
                            successList.add(detailChangeVO);
                        }
                    }
                } else {
                    // 二次点量
                    for (int i = 0; i < result.size(); i++) {
                        List<String> datas = result.get(i);
                        StringBuilder errMsg = new StringBuilder();
                        BudgetProjectDetailChangeVO detailVO = new BudgetProjectDetailChangeVO();
                        if (StringUtils.isNotBlank(datas.get(codeIndex))) {
                            detailVO.setCode(datas.get(codeIndex).trim());
                        } else {
                            detailVO.setCode(null);
                        }
                        BudgetProjectDetailChangeVO oldDetailVO = codeOldDataMap.get(detailVO.getCode());
                        if (oldDetailVO == null) {
                            errMsg.append("`不能增加新的上包清单项目编码`");
                        } else {
                            // 上包清单信息不允许修改
                            detailVO.setName(oldDetailVO.getName());
                            detailVO.setFeature(oldDetailVO.getFeature());
                            detailVO.setUnit(oldDetailVO.getUnit());
                            detailVO.setContractNum(oldDetailVO.getContractNum());
                            detailVO.setCheckEngineeringNum(oldDetailVO.getCheckEngineeringNum());
                            detailVO.setMaterialPrice(oldDetailVO.getMaterialPrice());
                            detailVO.setFixPrice(oldDetailVO.getFixPrice());
                            detailVO.setPrice(oldDetailVO.getPrice());
                            detailVO.setMoney(oldDetailVO.getMoney());
                            detailVO.setPackUpId(oldDetailVO.getPackUpId());
                            detailVO.setPackUpFlag(oldDetailVO.getPackUpFlag());
                        }
                        if (StringUtils.isNotBlank(datas.get(bigPackNameIndex))) {
                            detailVO.setBigPackName(datas.get(bigPackNameIndex).trim());
                            DefdocDetailVO defdocDetailVO = bigPakgMap.get(detailVO.getBigPackName());
                            if (defdocDetailVO == null) {
                                errMsg.append("`大包名称未匹配`");
                            } else {
                                detailVO.setBigPackSid(defdocDetailVO.getAttrCode());
                                detailVO.setBigPackId(defdocDetailVO.getId());
                                detailVO.setBigPackCode(defdocDetailVO.getCode());
                            }
                        } else {
                            errMsg.append("`大包名称不能为空`");
                        }

                        if (StringUtils.isNotBlank(datas.get(puchaseFlagIndex))) {
                            detailVO.setPuchaseFlag(datas.get(puchaseFlagIndex));
                        } else {
                            errMsg.append("`是否公司采购不能为空`");
                        }
                        if (StringUtils.isNotBlank(datas.get(materialPackCodeIndex))) {
                            String materialPackCode = datas.get(materialPackCodeIndex).trim();
                            detailVO.setMaterialPackCode(materialPackCode);
                            MaterialCategoryVO materialCategoryVO = null;
                            if (materialPackCode.contains("-")) {
                                materialCategoryVO = secondCategoryCodeMap.get(materialPackCode.split("-")[0]);
                            } else {
                                materialCategoryVO = secondCategoryCodeMap.get(materialPackCode);
                            }
                            if (materialCategoryVO == null) {
                                errMsg.append("`材料包代码未匹配`");
                            } else {
                                detailVO.setMaterialPackSid(materialCategoryVO.getSourceId());
                                detailVO.setMaterialPackId(materialCategoryVO.getId());
                                detailVO.setMaterialPackName(materialCategoryVO.getName());
                            }
                        }
                        if (StringUtils.isNotBlank(datas.get(engineeringPackCodeIndex))) {
                            String materialPackCode = datas.get(engineeringPackCodeIndex).trim();
                            detailVO.setEngineeringPackCode(materialPackCode);
                            SubTypeVO subTypeVO = null;
                            if (materialPackCode.contains("-")) {
                                subTypeVO = subTypeCodeMap.get(materialPackCode.split("-")[0]);
                            } else {
                                subTypeVO = subTypeCodeMap.get(detailVO.getEngineeringPackCode());
                            }
                            if (subTypeVO == null) {
                                errMsg.append("`工程包代码未匹配`");
                            } else {
                                detailVO.setEngineeringPackSid(subTypeVO.getSourceId());
                                detailVO.setEngineeringPackId(subTypeVO.getId());
                                detailVO.setEngineeringPackName(subTypeVO.getName());
                            }
                        } else {
                            if (StringUtils.isBlank(detailVO.getMaterialPackCode())) {
                                errMsg.append("`材料包代码和工程包代码不能同时为空`");
                            }
                        }
                        if (StringUtils.isNotBlank(datas.get(itemCodeIndex))) {
                            detailVO.setItemCode(datas.get(itemCodeIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(itemNameIndex))) {
                            detailVO.setItemName(datas.get(itemNameIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(itemFeatureIndex))) {
                            detailVO.setItemFeature(datas.get(itemFeatureIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(itemUnitIndex))) {
                            detailVO.setItemUnit(datas.get(itemUnitIndex).trim());
                        }
                        if (StringUtils.isNotBlank(datas.get(itemNumIndex))) {
                            detailVO.setItemNum(ComputeUtil.toBigDecimal(datas.get(itemNumIndex).replace(",", "")));
                        }
                        if (StringUtils.isNotBlank(datas.get(upperMaterialPriceIndex))) {
                            detailVO.setUpperMaterialPrice(ComputeUtil.toBigDecimal(datas.get(upperMaterialPriceIndex).replace(",", "")));
                        }
                        if (StringUtils.isNotBlank(datas.get(upperFixPriceIndex))) {
                            detailVO.setUpperFixPrice(ComputeUtil.toBigDecimal(datas.get(upperFixPriceIndex).replace(",", "")));
                        }
                        detailVO.setUpperPrice(ComputeUtil.safeAdd(detailVO.getUpperMaterialPrice(), detailVO.getUpperFixPrice()));
                        detailVO.setUpperMoney(ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(detailVO.getUpperPrice(), detailVO.getCheckEngineeringNum())));

                        if (StringUtils.isNotBlank(errMsg)) {
                            detailVO.setErrorMessage(errMsg.toString());
                            errorList.add(detailVO);
                        } else {
                            // 如果下包项目编码不为空
                            if (StringUtils.isNotBlank(datas.get(itemCodeIndex))) {
                                String itemCode = datas.get(itemCodeIndex).trim();
                                BudgetProjectDetailChangeVO oldDetailChangeVO = itemCodeOldDataMap.get(itemCode);
                                if (oldDetailChangeVO != null) {
                                    // 覆盖数据
                                    CompareDifferenceUtil.compareObj(oldDetailChangeVO, detailVO);
                                    detailVO.setId(oldDetailChangeVO.getId());
                                    detailVO.setBudgetId(oldDetailChangeVO.getBudgetId());
                                    detailVO.setVersion(oldDetailChangeVO.getVersion());
                                    detailVO.setTenantId(oldDetailChangeVO.getTenantId());
                                    detailVO.setCreateUserCode(oldDetailChangeVO.getCreateUserCode());
                                    detailVO.setCreateTime(oldDetailChangeVO.getCreateTime());
                                    detailVO.setUpdateUserCode(oldDetailChangeVO.getUpdateUserCode());
                                    detailVO.setUpdateTime(oldDetailChangeVO.getUpdateTime());
                                    detailVO.setChangeId(oldDetailChangeVO.getChangeId());
                                    detailVO.setChangeBid(oldDetailChangeVO.getChangeBid());
                                    if (detailVO.getMaterialPackId() != null) {
                                        detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                                    }
                                    if (detailVO.getEngineeringPackId() != null) {
                                        detailVO.setEngineeringListId(oldDetailChangeVO.getEngineeringListId());
                                    }
                                    if (detailVO.getMaterialPackId() != null) {
                                        detailVO.setMaterialListId(oldDetailChangeVO.getMaterialListId());
                                    }
                                    if ("update".equals(detailVO.getChangeFlag())) {
                                        detailVO.setChangeType(ChangTypeConst.UPDATE);
                                    } else {
                                        detailVO.setChangeType(ChangTypeConst.UNCHANGED);
                                    }
                                    itemCodeOldDataMap.remove(itemCode);
                                } else {
                                    //为空一定是新增项
                                    detailVO.setChangeType(ChangTypeConst.ADD);
                                    detailVO.setItemCode(null);
                                    detailVO.setId(IdWorker.getId());
                                }

                            } else {
                                //为空一定是新增项
                                detailVO.setChangeType(ChangTypeConst.ADD);
                                detailVO.setItemCode(null);
                                detailVO.setId(IdWorker.getId());
                            }
                            successList.add(detailVO);
                        }
                    }
                    // 剩余未匹配到的说明是删除，理论上这里应该为空，因为导入excel不支持删除操作
                    if (MapUtils.isNotEmpty(itemCodeOldDataMap)) {
                        for (BudgetProjectDetailChangeVO detailChangeVO : itemCodeOldDataMap.values()) {
                            detailChangeVO.setRowState("edit");
                            successList.add(detailChangeVO);
                        }
                    }
                }

            }

            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

}
