package com.ejianc.business.zdscost.controller;

import com.ejianc.business.zdsmaterial.plan.conjecture.api.IZDSMaterialConjectureApi;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class AiMaterialThread implements Runnable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private IZDSMaterialConjectureApi materialConjectureApi;

    private List<MaterialConjectureVO> materialConjectureVOS;

    private String authority;

    @Override
    public void run() {
        try {
            logger.info("authority----------------:{}", authority);
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            logger.info("AiMaterialThread线程开始----------------");
            materialConjectureApi.materialConjecture(materialConjectureVOS);
            logger.info("AiMaterialThread线程结束----------------");
        } catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw, true));
            String infomsg = sw.toString();
            logger.error(infomsg);
        }
    }

    public IZDSMaterialConjectureApi getMaterialConjectureApi() {
        return materialConjectureApi;
    }

    public void setMaterialConjectureApi(IZDSMaterialConjectureApi materialConjectureApi) {
        this.materialConjectureApi = materialConjectureApi;
    }

    public List<MaterialConjectureVO> getMaterialConjectureVOS() {
        return materialConjectureVOS;
    }

    public void setMaterialConjectureVOS(List<MaterialConjectureVO> materialConjectureVOS) {
        this.materialConjectureVOS = materialConjectureVOS;
    }

    public String getAuthority() {
        return authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }
}
