/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.service.impl;

import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.mapper.BudgetProjectChangeMapper;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectChangeVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailChangeVO;
import com.ejianc.business.zdscost.vo.query.PackageQueryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectChangeService")
public class BudgetProjectChangeServiceImpl
extends BaseServiceImpl<BudgetProjectChangeMapper, BudgetProjectChangeEntity>
implements IBudgetProjectChangeService {
    @Autowired
    private IBudgetProjectService budgetProjectService;

    @Override
    public BudgetProjectChangeVO addByBudgetId(PackageQueryVO queryVO) {
        Long budgetId = queryVO.getBudgetId();
        List materialPackCodes = Optional.ofNullable(queryVO.getMaterialPackCodes()).orElse(new ArrayList());
        List engineeringPackCodes = Optional.ofNullable(queryVO.getEngineeringPackCodes()).orElse(new ArrayList());
        BudgetProjectEntity budgetProjectEntity = (BudgetProjectEntity)((Object)this.budgetProjectService.selectById(budgetId));
        BudgetProjectChangeVO changeVO = (BudgetProjectChangeVO)BeanMapper.map((Object)((Object)budgetProjectEntity), BudgetProjectChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setChangeId(budgetId);
        changeVO.setChangeVersion(Integer.valueOf(budgetProjectEntity.getChangeVersion() + 1));
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setBillDate(new Date());
        changeVO.setId(null);
        changeVO.setIdentificationId(null);
        changeVO.setIdentificationState(null);
        List<BudgetProjectDetailChangeVO> detailChangeList = changeVO.getBudgetProjectDetailList();
        if (CollectionUtils.isNotEmpty((Collection)materialPackCodes) || CollectionUtils.isNotEmpty((Collection)engineeringPackCodes)) {
            detailChangeList = detailChangeList.stream().filter(t -> materialPackCodes.contains(t.getMaterialPackCode()) || engineeringPackCodes.contains(t.getEngineeringPackCode())).collect(Collectors.toList());
        }
        HashSet engineeringPackNum = new HashSet();
        HashSet materialPackNum = new HashSet();
        if (CollectionUtils.isNotEmpty(detailChangeList)) {
            detailChangeList.forEach(changeDetailVO -> {
                changeDetailVO.setChangeBid(changeDetailVO.getId());
                changeDetailVO.setChangeId(changeDetailVO.getBudgetId());
                changeDetailVO.setRowState("add");
                changeDetailVO.setChangeType("0");
                if (StringUtils.isNotBlank((CharSequence)changeDetailVO.getMaterialPackCode())) {
                    materialPackNum.add(changeDetailVO.getMaterialPackCode());
                }
                if (StringUtils.isNotBlank((CharSequence)changeDetailVO.getEngineeringPackCode())) {
                    engineeringPackNum.add(changeDetailVO.getEngineeringPackCode());
                }
            });
            detailChangeList.sort(Comparator.comparing(BudgetProjectDetailChangeVO::getSequen, Comparator.nullsLast(Integer::compareTo)));
        }
        changeVO.setMaterialPackNum(Integer.valueOf(materialPackNum.size()));
        changeVO.setEngineeringPackNum(Integer.valueOf(engineeringPackNum.size()));
        changeVO.setBudgetProjectDetailList(detailChangeList);
        return changeVO;
    }
}

