package com.ejianc.business.zdscost.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 切包清单
 *
 * @author generator
 *
 */
@TableName("ejc_budget_project")
public class BudgetProjectEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value = "org_id")
    private Long orgId; // 组织主键
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "project_id")
    private Long projectId; // 项目
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "engineering_pack_num")
    private Integer engineeringPackNum; // 工程包数量
    @TableField(value = "material_pack_num")
    private Integer materialPackNum; // 材料包数量
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "bill_date")
    private Date billDate; // 单据日期
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人
    @TableField(value = "change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value = "change_version")
    private Integer changeVersion; // 变更版本号
    @TableField(value = "change_id")
    private Long changeId; // 变更主键
    @TableField(value = "change_code")
    private String changeCode; // 变更单号
    @TableField(value = "change_reason")
    private String changeReason; // 变更原因
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "project_sid")
    private String projectSid; // erp项目id
    @TableField(value = "project_code")
    private String projectCode; // 项目编码
    @TableField(value = "effective_time")
    private Date effectiveTime; // 生效时间
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="opt_type")
    private String optType; // 操作类型

    @TableField(value="identification_id")
    private String identificationId; // 物料识别唯一标识

    @TableField(value="identification_state")
    private Integer identificationState; // 物料识别状态

    @TableField(exist = false)
    @SubEntity(serviceName = "budgetProjectDetailService", pidName = "budgetId")
    private List<BudgetProjectDetailEntity> budgetProjectDetailList = new ArrayList<>(); // 切包清单-明细

    public String getIdentificationId() {
        return identificationId;
    }

    public void setIdentificationId(String identificationId) {
        this.identificationId = identificationId;
    }

    public Integer getIdentificationState() {
        return identificationState;
    }

    public void setIdentificationState(Integer identificationState) {
        this.identificationState = identificationState;
    }

    public String getOptType() {
        return optType;
    }

    public void setOptType(String optType) {
        this.optType = optType;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Integer getEngineeringPackNum() {
        return engineeringPackNum;
    }

    public void setEngineeringPackNum(Integer engineeringPackNum) {
        this.engineeringPackNum = engineeringPackNum;
    }

    public Integer getMaterialPackNum() {
        return materialPackNum;
    }

    public void setMaterialPackNum(Integer materialPackNum) {
        this.materialPackNum = materialPackNum;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getProjectSid() {
        return projectSid;
    }

    public void setProjectSid(String projectSid) {
        this.projectSid = projectSid;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public List<BudgetProjectDetailEntity> getBudgetProjectDetailList() {
        return budgetProjectDetailList;
    }

    public void setBudgetProjectDetailList(List<BudgetProjectDetailEntity> budgetProjectDetailList) {
        this.budgetProjectDetailList = budgetProjectDetailList;
    }
}
