/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"budgetProjectDetailApi"})
@Api(value="\u5207\u5305\u6e05\u5355-\u67e5\u8be2Api", tags={"\u5207\u5305\u6e05\u5355-\u67e5\u8be2Api"})
public class BudgetProjectDetailApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetProjectService budgetProjectService;
    @Autowired
    private IBudgetProjectDetailService detailService;
    @Autowired
    private IBudgetProjectChangeService budgetProjectChangeService;
    @Autowired
    private IBudgetProjectDetailChangeService detailChangeService;
    @Autowired
    private IBudgetProjectDetailService service;
    @Autowired
    private RedissonLocker redissonLocker;

    @RequestMapping(value={"/updateMaterialConjecture"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateMaterialConjecture(@RequestBody List<MaterialConjectureVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Long, MaterialConjectureVO> map = list.stream().collect(Collectors.toMap(MaterialConjectureVO::getBudgetDetailId, student -> student, (k1, k2) -> k1));
            Long billId = list.get(0).getBillId();
            BudgetProjectEntity entity = (BudgetProjectEntity)((Object)this.budgetProjectService.selectById(billId));
            if (entity != null) {
                ArrayList<BudgetProjectDetailEntity> detailEntities = new ArrayList<BudgetProjectDetailEntity>();
                for (BudgetProjectDetailEntity detailEntity : entity.getBudgetProjectDetailList()) {
                    Long id = detailEntity.getId();
                    MaterialConjectureVO materialConjectureVO = map.get(id);
                    if (materialConjectureVO == null) continue;
                    detailEntity.setMateType(materialConjectureVO.getMateType());
                    detailEntity.setMaterialId(materialConjectureVO.getActualMaterialId());
                    detailEntity.setMaterialCode(materialConjectureVO.getActualMaterialCode());
                    detailEntity.setMaterialName(materialConjectureVO.getActualMaterialName());
                    detailEntity.setMaterialSpec(materialConjectureVO.getActualMaterialSpec());
                    if (materialConjectureVO.getActualSecCategoryId() != null) {
                        detailEntity.setMaterialPackId(materialConjectureVO.getActualSecCategoryId());
                        detailEntity.setMaterialPackName(materialConjectureVO.getActualSecCategoryName());
                        this.logger.info("===================={}", (Object)materialConjectureVO.getActualSecCategoryId());
                    }
                    detailEntities.add(detailEntity);
                }
                if (CollectionUtils.isNotEmpty(detailEntities)) {
                    this.detailService.saveOrUpdateBatch(detailEntities);
                }
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)billId);
                updateWrapper.set(BudgetProjectEntity::getIdentificationState, (Object)2);
                this.budgetProjectService.update((Wrapper)updateWrapper);
            } else {
                BudgetProjectChangeEntity changeEntity = (BudgetProjectChangeEntity)((Object)this.budgetProjectChangeService.selectById(billId));
                if (changeEntity != null) {
                    ArrayList<BudgetProjectDetailChangeEntity> detailEntities = new ArrayList<BudgetProjectDetailChangeEntity>();
                    for (BudgetProjectDetailChangeEntity detailEntity : changeEntity.getBudgetProjectDetailList()) {
                        Long id = detailEntity.getId();
                        MaterialConjectureVO materialConjectureVO = map.get(id);
                        if (materialConjectureVO == null) continue;
                        detailEntity.setMateType(materialConjectureVO.getMateType());
                        detailEntity.setMaterialId(materialConjectureVO.getActualMaterialId());
                        detailEntity.setMaterialCode(materialConjectureVO.getActualMaterialCode());
                        detailEntity.setMaterialName(materialConjectureVO.getActualMaterialName());
                        detailEntity.setMaterialSpec(materialConjectureVO.getActualMaterialSpec());
                        if (materialConjectureVO.getActualSecCategoryId() != null) {
                            detailEntity.setMaterialPackId(materialConjectureVO.getActualSecCategoryId());
                            detailEntity.setMaterialPackName(materialConjectureVO.getActualSecCategoryName());
                            this.logger.info("===================={}", (Object)materialConjectureVO.getActualSecCategoryId());
                        }
                        detailEntities.add(detailEntity);
                    }
                    if (CollectionUtils.isNotEmpty(detailEntities)) {
                        this.detailChangeService.saveOrUpdateBatch(detailEntities);
                    }
                    LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                    updateWrapper.eq(BaseEntity::getId, (Object)billId);
                    updateWrapper.set(BudgetProjectChangeEntity::getIdentificationState, (Object)2);
                    this.budgetProjectChangeService.update((Wrapper)updateWrapper);
                }
            }
            this.logger.info("updateMaterialConjecture\u56de\u8c03-------{}---------", (Object)billId);
            String lockKey = "AiMaterialKey_" + billId;
            this.redissonLocker.unlock(lockKey);
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u7269\u6599\u8bc6\u522b\u7ed3\u679c\u6570\u636e\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u9879\u76ee\u8d39\u7528\u5305\u63a5\u53e3")
    @RequestMapping(value={"/queryPackageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<Map>> queryPackageList(@RequestBody BudgetProjectDetailQueryVO queryVO) {
        if (queryVO.getProjectSid() == null || queryVO.getPageSize() == null || queryVO.getPageIndex() == null) {
            throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId/projectSid]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (queryVO.getPageSize() == null) {
            throw new BusinessException("\u53c2\u6570\u6bcf\u9875\u884c\u6570[pageSize]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (queryVO.getPageIndex() == null) {
            throw new BusinessException("\u53c2\u6570\u9875\u7801[pageIndex]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Page page = new Page((long)queryVO.getPageIndex().intValue(), (long)queryVO.getPageSize().intValue());
        List<Map> list = this.service.queryPackageList((Page<Map>)page, queryVO);
        for (Map map : list) {
            if (!map.containsKey("materialCode")) {
                map.put("materialCode", null);
            }
            if (!map.containsKey("materialId")) {
                map.put("materialId", null);
            }
            if (!map.containsKey("materialName")) {
                map.put("materialName", null);
            }
            if (map.containsKey("materialSpec")) continue;
            map.put("materialSpec", null);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5207\u5305\u6e05\u5355\u63a5\u53e3")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Page<BudgetProjectDetailVO>> queryList(@RequestBody BudgetProjectDetailQueryVO queryVO) {
        if (queryVO.getProjectId() == null && queryVO.getProjectSid() == null) {
            throw new BusinessException("\u53c2\u6570\u9879\u76eeID[projectId/projectSid]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(null != queryVO.getProjectSid(), BudgetProjectEntity::getProjectSid, (Object)queryVO.getProjectSid());
        queryWrapper.eq(null != queryVO.getProjectId(), BudgetProjectEntity::getProjectId, (Object)queryVO.getProjectId());
        queryWrapper.in(BudgetProjectEntity::getBillState, new Object[]{"1,3"});
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List list1 = this.budgetProjectService.list((Wrapper)queryWrapper);
        Long budgetId = 1L;
        if (CollectionUtils.isNotEmpty((Collection)list1)) {
            budgetId = ((BudgetProjectEntity)((Object)list1.get(0))).getId();
        }
        QueryParam queryParam = new QueryParam();
        if (null != queryVO.getPageSize()) {
            queryParam.setPageSize(queryVO.getPageSize().intValue());
        }
        if (null != queryVO.getPageIndex()) {
            queryParam.setPageIndex(queryVO.getPageIndex().intValue());
        }
        Map params = queryParam.getParams();
        String paramStr = queryVO.getParamStr();
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            String[] split = paramStr.split(",");
            if (split.length > 0 && StringUtil.isNotBlank((CharSequence)split[0])) {
                params.put("bigPackCode", new Parameter("like", (Object)split[0]));
            }
            if (split.length > 1 && StringUtil.isNotBlank((CharSequence)split[1])) {
                params.put("bigPackName", new Parameter("like", (Object)split[1]));
            }
            if (split.length > 2 && StringUtil.isNotBlank((CharSequence)split[2])) {
                if ("engineering".equals(split[2])) {
                    params.put("engineeringListFlag", new Parameter("eq", (Object)1));
                } else {
                    params.put("materialListFlag", new Parameter("eq", (Object)1));
                }
            }
            if (split.length > 3 && StringUtil.isNotBlank((CharSequence)split[3])) {
                params.put("SQL", new Parameter("sql", (Object)("(engineering_pack_code like '%" + split[3] + "%' or material_pack_code like '%" + split[3] + "%' )")));
            }
            if (split.length > 4 && StringUtil.isNotBlank((CharSequence)split[4])) {
                params.put("SQL", new Parameter("sql", (Object)("(engineering_pack_name like '%" + split[4] + "%' or material_pack_name like '%" + split[4] + "%' )")));
            }
        }
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        params.put("budgetId", new Parameter("eq", (Object)budgetId));
        params.put("changeType", new Parameter("ne", (Object)"2"));
        if (null != queryVO.getMaterialPackIds()) {
            params.put("materialPackId", new Parameter("in", (Object)queryVO.getMaterialPackIds()));
        }
        if (null != queryVO.getMaterialPackCodes()) {
            params.put("materialPackCode", new Parameter("in", (Object)queryVO.getMaterialPackCodes()));
        }
        if (null != queryVO.getBudgetDetailIds()) {
            params.put("id", new Parameter("in", (Object)queryVO.getBudgetDetailIds()));
        }
        IPage entityIPage = this.service.queryPage(queryParam, false);
        Page pageData = new Page(entityIPage.getCurrent(), entityIPage.getSize(), entityIPage.getTotal());
        List detailVOS = BeanMapper.mapList((Iterable)entityIPage.getRecords(), BudgetProjectDetailVO.class);
        Iterator iterator = detailVOS.iterator();
        while (iterator.hasNext()) {
            BudgetProjectDetailVO detailVO;
            detailVO.setMaterialPackName(null != (detailVO = (BudgetProjectDetailVO)iterator.next()).getMaterialPackCode() ? detailVO.getMaterialPackName() + detailVO.getMaterialPackCode() : detailVO.getMaterialPackName());
            detailVO.setEngineeringPackName(null != detailVO.getEngineeringPackCode() ? detailVO.getEngineeringPackName() + detailVO.getEngineeringPackCode() : detailVO.getEngineeringPackName());
        }
        pageData.setRecords(detailVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

