/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.mapper.BudgetProjectDetailMapper;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailPackageVO;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectDetailService")
public class BudgetProjectDetailServiceImpl
extends BaseServiceImpl<BudgetProjectDetailMapper, BudgetProjectDetailEntity>
implements IBudgetProjectDetailService {
    @Autowired
    private IBudgetProjectService budgetProjectService;

    public List queryPackageList(Page<Map> page, BudgetProjectDetailQueryVO queryVO) {
        String projectSid = queryVO.getProjectSid();
        String paramStr = queryVO.getParamStr();
        String packageFlag = "";
        String packageCode = "";
        String packageName = "";
        if (StringUtils.isNotEmpty((CharSequence)paramStr)) {
            String[] split = paramStr.split(",");
            packageFlag = split.length > 0 ? split[0] : null;
            packageCode = split.length > 1 ? split[1] : null;
            packageName = split.length > 2 ? split[2] : null;
        }
        return ((BudgetProjectDetailMapper)this.baseMapper).queryPackageList(page, projectSid, packageFlag, packageCode, packageName);
    }

    @Override
    public List<BudgetProjectDetailPackageVO> queryPackageTree(Long id) {
        return ((BudgetProjectDetailMapper)this.baseMapper).queryPackageTree(id);
    }

    @Override
    public JSONObject queryDetailNoAuth(String projectSid, String packageCode) {
        JSONObject result = new JSONObject();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BudgetProjectEntity::getProjectSid, (Object)projectSid);
        queryWrapper.in(BudgetProjectEntity::getBillState, new Object[]{"1,3"});
        List list1 = this.budgetProjectService.list((Wrapper)queryWrapper);
        List<Long> ids = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)list1)) {
            ids = list1.stream().map(BaseEntity::getId).collect(Collectors.toList());
        } else {
            ids.add(1L);
        }
        QueryParam queryParam = new QueryParam();
        Map params = queryParam.getParams();
        params.put("budgetId", new Parameter("in", ids));
        params.put("changeType", new Parameter("ne", (Object)"2"));
        List list = super.queryList(queryParam, false);
        result.put("budgetProjectDetailList", (Object)list);
        if (StringUtil.isNotBlank((CharSequence)packageCode)) {
            params.put("SQL", new Parameter("sql", (Object)("(engineering_pack_code like '%" + packageCode + "%' or material_pack_code like '%" + packageCode + "%' )")));
            List selfDetailList = super.queryList(queryParam, false);
            result.put("selfDetailList", (Object)selfDetailList);
        }
        return result;
    }

    @Override
    public IPage<BudgetProjectDetailEntity> refBudgetProjectDetailData(Page<BudgetProjectDetailEntity> page, QueryParam param) {
        QueryWrapper qw = BudgetProjectDetailServiceImpl.changeToQueryWrapper((QueryParam)param);
        qw.groupBy((Object[])new String[]{"material_pack_code"});
        IPage list = ((BudgetProjectDetailMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)qw);
        Iterator iterator = list.getRecords().iterator();
        while (iterator.hasNext()) {
            BudgetProjectDetailEntity detailVO;
            detailVO.setMaterialPackName(null != (detailVO = (BudgetProjectDetailEntity)((Object)iterator.next())).getMaterialPackCode() ? detailVO.getMaterialPackName() + detailVO.getMaterialPackCode() : detailVO.getMaterialPackName());
            detailVO.setEngineeringPackName(null != detailVO.getEngineeringPackCode() ? detailVO.getEngineeringPackName() + detailVO.getEngineeringPackCode() : detailVO.getEngineeringPackName());
        }
        return list;
    }

    @Override
    public List<BudgetProjectDetailPackageVO> queryPackageDetailList(Page<BudgetProjectDetailPackageVO> page, Long budgetId, QueryWrapper qw) {
        return ((BudgetProjectDetailMapper)this.baseMapper).queryPackageDetailList(page, budgetId, qw);
    }

    @Override
    public List<String> queryDianLiangPackCode(Long budgetId) {
        return ((BudgetProjectDetailMapper)this.baseMapper).queryDianLiangPackCode(budgetId);
    }
}

