package com.ejianc.business.zdscost.service.impl;

import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.mapper.BudgetProjectChangeMapper;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectChangeVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailChangeVO;
import com.ejianc.business.zdscost.vo.query.PackageQueryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 切包清单变更
 *
 * @author generator
 *
 */
@Service("budgetProjectChangeService")
public class BudgetProjectChangeServiceImpl extends BaseServiceImpl<BudgetProjectChangeMapper, BudgetProjectChangeEntity> implements IBudgetProjectChangeService {

    @Autowired
    private IBudgetProjectService budgetProjectService;

    @Override
    public BudgetProjectChangeVO addByBudgetId(PackageQueryVO queryVO) {
        Long budgetId = queryVO.getBudgetId();
        List<String> materialPackCodes = Optional.ofNullable(queryVO.getMaterialPackCodes()).orElse(new ArrayList<>());
        List<String> engineeringPackCodes = Optional.ofNullable(queryVO.getEngineeringPackCodes()).orElse(new ArrayList<>());
        BudgetProjectEntity budgetProjectEntity = budgetProjectService.selectById(budgetId);
        BudgetProjectChangeVO changeVO = BeanMapper.map(budgetProjectEntity, BudgetProjectChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setChangeId(budgetId);
        changeVO.setChangeVersion(budgetProjectEntity.getChangeVersion() + 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setBillDate(new Date());
        changeVO.setId(null);
        changeVO.setIdentificationId(null);
        changeVO.setIdentificationState(null);
        List<BudgetProjectDetailChangeVO> detailChangeList = changeVO.getBudgetProjectDetailList();
        if (CollectionUtils.isNotEmpty(materialPackCodes) || CollectionUtils.isNotEmpty(engineeringPackCodes)) {
            detailChangeList = detailChangeList.stream().filter(t -> materialPackCodes.contains(t.getMaterialPackCode()) || engineeringPackCodes.contains(t.getEngineeringPackCode())).collect(Collectors.toList());
        }
        Set<String> engineeringPackNum = new HashSet();
        Set<String> materialPackNum = new HashSet<>();
        if (CollectionUtils.isNotEmpty(detailChangeList)) {
            detailChangeList.forEach(changeDetailVO -> {
                changeDetailVO.setChangeBid(changeDetailVO.getId());
                changeDetailVO.setChangeId(changeDetailVO.getBudgetId());
                changeDetailVO.setRowState("add");
                changeDetailVO.setChangeType("0");
                if (StringUtils.isNotBlank(changeDetailVO.getMaterialPackCode())) {
                    materialPackNum.add(changeDetailVO.getMaterialPackCode());
                }
                if (StringUtils.isNotBlank(changeDetailVO.getEngineeringPackCode())) {
                    engineeringPackNum.add(changeDetailVO.getEngineeringPackCode());
                }
            });
            detailChangeList.sort(Comparator.comparing(
                    BudgetProjectDetailChangeVO::getSequen,
                    Comparator.nullsLast(BigDecimal::compareTo)
            ));
        }
        changeVO.setMaterialPackNum(materialPackNum.size());
        changeVO.setEngineeringPackNum(engineeringPackNum.size());
        changeVO.setBudgetProjectDetailList(detailChangeList);
        return changeVO;
    }
}
