/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdscost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdscost.bean.BudgetProjectChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectRecordEntity;
import com.ejianc.business.zdscost.service.IBudgetProjectChangeService;
import com.ejianc.business.zdscost.service.IBudgetProjectDetailService;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.QuoteParamsVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="budgetProjectChange")
public class BudgetProjectChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBudgetProjectChangeService changeService;
    @Autowired
    private IBudgetProjectService service;
    @Autowired
    private IBudgetProjectDetailService detailService;
    @Autowired
    private IBudgetProjectRecordService recordService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectChangeEntity changeEntity = (BudgetProjectChangeEntity)((Object)this.changeService.selectById(billId));
        Map<Long, BudgetProjectDetailChangeEntity> detailDelMap = changeEntity.getBudgetProjectDetailList().stream().filter(t -> "2".equals(t.getChangeType()) && t.getChangeBid() != null).collect(Collectors.toMap(BudgetProjectDetailChangeEntity::getChangeBid, student -> student));
        this.logger.info("================beforeSubmitProcessor detailDelMap:{}", (Object)JSONObject.toJSONString(detailDelMap));
        if (MapUtils.isNotEmpty(detailDelMap)) {
            QuoteParamsVO quoteParamsVO = new QuoteParamsVO();
            quoteParamsVO.setBillTypeCode("EJCBT202508000001");
            quoteParamsVO.setBillIds(new ArrayList<Long>(detailDelMap.keySet()));
            CommonResponse resp = this.billTypeApi.checkQuotesAndReturnQuoteBillIds(quoteParamsVO);
            this.logger.info("================beforeSubmitProcessor \u6821\u9a8c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)quoteParamsVO), (Object)JSONObject.toJSONString((Object)resp));
            if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
                for (Long detailId : (List)resp.getData()) {
                    BudgetProjectDetailChangeEntity detailChangeEntity = detailDelMap.get(detailId);
                    if (detailChangeEntity == null) continue;
                    return CommonResponse.error((String)("\u6e05\u5355\u660e\u7ec6\uff1a\u9879\u76ee\u7f16\u7801\u3010" + detailChangeEntity.getCode() + "\u3011\u9879\u76ee\u540d\u79f0\u3010" + detailChangeEntity.getName() + "\u3011\u5df2\u88ab\u4e0b\u6e38\u91c7\u8d2d\u8ba1\u5212/\u603b\u63a7\u8ba1\u5212\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectChangeEntity changeEntity = (BudgetProjectChangeEntity)((Object)this.changeService.selectById(billId));
        Map<Long, BudgetProjectDetailChangeEntity> detailDelMap = changeEntity.getBudgetProjectDetailList().stream().filter(t -> "2".equals(t.getChangeType()) && t.getChangeBid() != null).collect(Collectors.toMap(BudgetProjectDetailChangeEntity::getChangeBid, student -> student));
        this.logger.info("================beforeApprovalProcessor detailDelMap:{}", (Object)JSONObject.toJSONString(detailDelMap));
        if (MapUtils.isNotEmpty(detailDelMap)) {
            QuoteParamsVO quoteParamsVO = new QuoteParamsVO();
            quoteParamsVO.setBillTypeCode("EJCBT202508000001");
            quoteParamsVO.setBillIds(new ArrayList<Long>(detailDelMap.keySet()));
            CommonResponse resp = this.billTypeApi.checkQuotesAndReturnQuoteBillIds(quoteParamsVO);
            this.logger.info("================beforeSubmitProcessor \u6821\u9a8c\u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)quoteParamsVO), (Object)JSONObject.toJSONString((Object)resp));
            if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
                for (Long detailId : (List)resp.getData()) {
                    BudgetProjectDetailChangeEntity detailChangeEntity = detailDelMap.get(detailId);
                    if (detailChangeEntity == null) continue;
                    return CommonResponse.error((String)("\u6e05\u5355\u660e\u7ec6\uff1a\u9879\u76ee\u7f16\u7801\u3010" + detailChangeEntity.getCode() + "\u3011\u9879\u76ee\u540d\u79f0\u3010" + detailChangeEntity.getName() + "\u3011\u5df2\u88ab\u4e0b\u6e38\u91c7\u8d2d\u8ba1\u5212/\u603b\u63a7\u8ba1\u5212\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BudgetProjectChangeEntity changeEntity = (BudgetProjectChangeEntity)((Object)this.changeService.selectById(billId));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(BudgetProjectChangeEntity::getEffectiveTime, (Object)new Date());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getId());
        this.changeService.update((Wrapper)updateWrapper);
        BudgetProjectEntity contractChangeEntity = (BudgetProjectEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), BudgetProjectEntity.class));
        List<BudgetProjectDetailEntity> budgetProjectDetailList = contractChangeEntity.getBudgetProjectDetailList();
        List sourceItemIds = budgetProjectDetailList.stream().filter(t -> t.getChangeBid() != null).map(BudgetProjectDetailEntity::getChangeBid).collect(Collectors.toList());
        BudgetProjectEntity budgetProjectEntity = (BudgetProjectEntity)((Object)this.service.selectById(changeEntity.getChangeId()));
        HashMap contIdVersionMap = new HashMap();
        BudgetProjectRecordEntity recordEntity = (BudgetProjectRecordEntity)((Object)BeanMapper.map((Object)((Object)budgetProjectEntity), BudgetProjectRecordEntity.class));
        recordEntity.setBillCode(budgetProjectEntity.getBillCode() + "-" + budgetProjectEntity.getChangeVersion());
        recordEntity.setChangeId(changeEntity.getId());
        recordEntity.setChangeCode(changeEntity.getBillCode());
        recordEntity.setChangeReason(changeEntity.getChangeReason());
        recordEntity.setEffectiveTime(new Date());
        recordEntity.setCreateTime(changeEntity.getCreateTime());
        recordEntity.setId(null);
        recordEntity.setOriginBudgetId(budgetProjectEntity.getId());
        recordEntity.setOptType(changeEntity.getOptType());
        HashSet engineeringPackNum = new HashSet();
        HashSet materialPackNum = new HashSet();
        if (CollectionUtils.isNotEmpty(recordEntity.getBudgetProjectDetailList())) {
            recordEntity.getBudgetProjectDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                if (!sourceItemIds.contains(vo.getId())) {
                    if (StringUtils.isNotBlank((CharSequence)vo.getMaterialPackCode())) {
                        materialPackNum.add(vo.getMaterialPackCode());
                    }
                    if (StringUtils.isNotBlank((CharSequence)vo.getEngineeringPackCode())) {
                        engineeringPackNum.add(vo.getEngineeringPackCode());
                    }
                }
                vo.setChangeBid(vo.getId());
                vo.setChangeId(vo.getBudgetId());
                vo.setId(null);
                vo.setVersion(null);
            });
        }
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        ArrayList delIds = new ArrayList();
        if (CollectionUtils.isNotEmpty(budgetProjectDetailList)) {
            budgetProjectDetailList.forEach(contractDetailEntity -> {
                Long changeBid = contractDetailEntity.getChangeBid();
                contractDetailEntity.setBudgetId(changeEntity.getChangeId());
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                contractDetailEntity.setChangeId(contractDetailEntity.getId());
                contractDetailEntity.setId(changeBid);
                contractDetailEntity.setVersion((Integer)contIdVersionMap.get(changeBid));
                if ("2".equals(contractDetailEntity.getChangeType())) {
                    if (changeBid != null) {
                        delIds.add(changeBid);
                    }
                } else {
                    if (StringUtils.isNotBlank((CharSequence)contractDetailEntity.getMaterialPackCode())) {
                        materialPackNum.add(contractDetailEntity.getMaterialPackCode());
                    }
                    if (StringUtils.isNotBlank((CharSequence)contractDetailEntity.getEngineeringPackCode())) {
                        engineeringPackNum.add(contractDetailEntity.getEngineeringPackCode());
                    }
                }
            });
            this.detailService.saveOrUpdateBatch(budgetProjectDetailList, budgetProjectDetailList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(delIds)) {
            this.detailService.removeByIds(delIds);
        }
        LambdaQueryWrapper changeQueryWrapper = new LambdaQueryWrapper();
        changeQueryWrapper.eq(BudgetProjectChangeEntity::getChangeId, (Object)changeEntity.getChangeId());
        changeQueryWrapper.ne(changeEntity.getId() == null, BaseEntity::getId, (Object)changeEntity.getId());
        changeQueryWrapper.notIn(BudgetProjectChangeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        changeQueryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.changeService.list((Wrapper)changeQueryWrapper);
        LambdaUpdateWrapper updateWr = new LambdaUpdateWrapper();
        updateWr.eq(BaseEntity::getId, (Object)budgetProjectEntity.getId());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            updateWr.set(BudgetProjectEntity::getChangeId, (Object)((BudgetProjectChangeEntity)((Object)list.get(0))).getId());
            updateWr.set(BudgetProjectEntity::getChangeCode, (Object)((BudgetProjectChangeEntity)((Object)list.get(0))).getBillCode());
            updateWr.set(BudgetProjectEntity::getChangeStatus, (Object)BudgetProjectVO.CHANGE_STATE_CHANGING);
        } else {
            updateWr.set(BudgetProjectEntity::getChangeId, null);
            updateWr.set(BudgetProjectEntity::getChangeCode, null);
            updateWr.set(BudgetProjectEntity::getChangeStatus, (Object)BudgetProjectVO.CHANGE_STATE_CHANGED);
        }
        updateWr.set(BudgetProjectEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWr.set(BudgetProjectEntity::getEffectiveTime, (Object)new Date());
        updateWr.set(BudgetProjectEntity::getMaterialPackNum, (Object)materialPackNum.size());
        updateWr.set(BudgetProjectEntity::getEngineeringPackNum, (Object)engineeringPackNum.size());
        this.service.update((Wrapper)updateWr);
        String result = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectDepartmentId", (Object)budgetProjectEntity.getOrgId());
        HashMap<String, String> headers = new HashMap<String, String>();
        String authority = this.request.getHeader("authority");
        headers.put("authority", authority);
        try {
            result = HttpTookit.get((String)(this.baseHost + "/ejc-share-web/projectTeam/queryList?="), (Map)jsonObject, headers);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u9879\u76ee\u4eba\u5458\u4efb\u804c\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4eba\u5458\u4efb\u804c\u5931\u8d25!");
        }
        CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)result, (TypeReference)new TypeReference<CommonResponse<List<Map<String, Object>>>>(){}, (Feature[])new Feature[0]);
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            ArrayList<String> reccIds = new ArrayList<String>();
            for (Map datum : (List)resp.getData()) {
                Object userId;
                Object projectPost = datum.get("projectPost");
                if (projectPost == null || !"\u9879\u76ee\u5546\u52a1\u5de5\u7a0b\u5e08\u3001\u9879\u76ee\u5546\u52a1\u7ecf\u7406\u3001\u9879\u76ee\u7ecf\u7406".contains(projectPost.toString()) || (userId = datum.get("userId")) == null) continue;
                reccIds.add(userId.toString());
            }
            this.logger.info("\u5207\u5305\u6e05\u5355\u53d8\u66f4id-{},\u53d1\u9001\u6d88\u606f\u63a5\u6536\u4eba\uff1a{}\uff01", (Object)changeEntity.getId().toString(), (Object)JSONObject.toJSONString(reccIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            if (!reccIds.isEmpty()) {
                PushMsgParameter pushMsgParameter = new PushMsgParameter();
                String subject = "\u5207\u5305\u6e05\u5355\u3010" + budgetProjectEntity.getBillCode() + "\u3011\u4e8e" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u53d1\u751f\u4e86\u53d8\u66f4\uff0c\u9700\u8981\u60a8\u67e5\u770b\u548c\u5904\u7406\uff01";
                pushMsgParameter.setSubject(subject);
                StringBuilder content = new StringBuilder();
                content.append("\u3010" + budgetProjectEntity.getBillCode() + "\u3011\uff0c\u3010" + budgetProjectEntity.getProjectCode() + "\uff0c" + budgetProjectEntity.getProjectName() + "\u3011\uff0c\u9879\u76ee\u6e05\u5355\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u53ca\u65f6\u5bf9\u8d39\u7528\u5305\u9884\u7b97\u8fdb\u884c\u8c03\u6574\uff0c\u4ee5\u4fdd\u8bc1\u9650\u4ef7\u4e0e\u8be2\u4ef7\u8303\u56f4\u4e00\u81f4\u3002\n");
                pushMsgParameter.setContent(content.toString());
                pushMsgParameter.setPcUrl(this.baseHost + "ejc-zdscost-frontend/#/budgetProject/card?id=" + changeEntity.getId().toString());
                pushMsgParameter.setReceivers(reccIds.toArray(new String[reccIds.size()]));
                pushMsgParameter.setSaveFlag(true);
                pushMsgParameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
                pushMsgParameter.setMsgType("notice");
                pushMsgParameter.setChannel(new String[]{"sys", "email"});
                JSONObject params = new JSONObject();
                params.put("comeFrom", (Object)("\u5de5\u7a0b\u7ba1\u7406\u4e2d\u5fc3 " + DateFormatUtil.formatDate((String)"yyyy/MM/dd", (Date)new Date())));
                pushMsgParameter.setZdsExtEmailParams(params);
                CommonResponse sendResp = this.pushMessageApi.pushMessage(pushMsgParameter);
                if (!sendResp.isSuccess()) {
                    this.logger.error("\u5207\u5305\u6e05\u5355\u53d8\u66f4id-{},\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c{}", (Object)changeEntity.getId().toString(), (Object)JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                } else {
                    this.logger.info("\u5207\u5305\u6e05\u5355\u53d8\u66f4id-{},\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)changeEntity.getId().toString());
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

