package com.ejianc.business.zdscost.service.impl;

import com.ejianc.business.zdscost.bean.BudgetProjectDetailChangeEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectDetailEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectEntity;
import com.ejianc.business.zdscost.bean.BudgetProjectRecordEntity;
import com.ejianc.business.zdscost.consts.ChangTypeConst;
import com.ejianc.business.zdscost.mapper.BudgetProjectMapper;
import com.ejianc.business.zdscost.service.IBudgetProjectRecordService;
import com.ejianc.business.zdscost.service.IBudgetProjectService;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailRecordVO;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.business.zdscost.vo.BudgetProjectRecordVO;
import com.ejianc.business.zdscost.vo.BudgetProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.fieldCompare.CompareDifferenceUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 切包清单
 *
 * @author generator
 *
 */
@Service("budgetProjectService")
public class BudgetProjectServiceImpl extends BaseServiceImpl<BudgetProjectMapper, BudgetProjectEntity> implements IBudgetProjectService {

    @Autowired
    private IBudgetProjectRecordService recordService;

    @Override
    public BudgetProjectVO compareDetail(Long id, Long recordId) {
        BudgetProjectEntity entity = this.selectById(id);
        BudgetProjectVO vo = BeanMapper.map(entity, BudgetProjectVO.class);
        List<BudgetProjectDetailVO> detailList = vo.getBudgetProjectDetailList();
        detailList = detailList.stream().filter(t -> !ChangTypeConst.DELETE.equals(t.getChangeType())).collect(Collectors.toList());
        vo.setBudgetProjectDetailList(detailList);
        BudgetProjectRecordEntity budgetProjectRecordEntity = recordService.selectById(recordId);
        BudgetProjectRecordVO recordVO = BeanMapper.map(budgetProjectRecordEntity, BudgetProjectRecordVO.class);
        List<BudgetProjectDetailRecordVO> list = recordVO.getBudgetProjectDetailList();
        list = list.stream().filter(t -> !ChangTypeConst.DELETE.equals(t.getChangeType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            CompareDifferenceUtil.compareList(list, detailList, true);
        }
        vo.setBeforeEngineeringPackNum(budgetProjectRecordEntity.getEngineeringPackNum());
        vo.setBeforeMaterialPackNum(budgetProjectRecordEntity.getMaterialPackNum());
        detailList.sort(Comparator.comparing(
                BudgetProjectDetailVO::getSequen,
                Comparator.nullsLast(BigDecimal::compareTo)
        ));
        return vo;
    }


}
