package com.ejianc.business.zdsmaterial.material.api;

import com.ejianc.business.zdsmaterial.material.hystrix.ZDSMaterialCategoryHystrix;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author 姜轶凯
 * @version 1.0
 * @description: 对账结算api
 * @date 2022/3/9
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = ZDSMaterialCategoryHystrix.class)
public interface IZDSMaterialCategoryApi {

    @PostMapping(value = "/api/zdsMaterialCategory/getAllByIds")
    CommonResponse<List<MaterialCategoryVO>> getAllByIds(@RequestBody List<Long> ids);

    @PostMapping(value = "/api/zdsMaterialCategory/getAllBySourceIdsAndPropertyFlag")
    CommonResponse<List<MaterialCategoryVO>> getAllBySourceIdsAndPropertyFlag(@RequestBody List<String> sourceIds, @RequestParam Integer propertyFlag);

    @PostMapping(value = "/api/zdsMaterialCategory/getAllBySourceIds")
    CommonResponse<List<MaterialCategoryVO>> getAllBySourceIds(@RequestBody List<String> sourceIds);

    @PostMapping(value = "/api/zdsMaterialCategory/getMaterialSecondCategoryList")
    CommonResponse<List<MaterialCategoryVO>> getMaterialSecondCategoryList();
}

