package com.ejianc.business.zdsmaterial.erp.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 物资合同
 *
 * @author generator
 *
 */
public class ContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    public static String CONTRACT_TYPE_MAIN = "1"; //主合同
    public static String CONTRACT_TYPE_ADDITIONAL = "2"; //附加合同
    public static String CONTRACT_TYPE_ORDER = "3"; //订单

    private String contractCode; //合同编码
    private String sourceContractId; // ERP合同主键
    private String billCode; // 单据编码
    private String contractName; // 合同名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 单据组织id
    private String orgName; // 单据组织名称
    private String orgCode; // 单据组织编码
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 上级组织名称
    private String parentOrgCode; // 上级组织编码
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private String supplierCode; // 供应商编码
    private Integer priceType; // 计价方式：1-单价合同，2-总价合同
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date signDate; // 合同签订日期
    private Integer enableStatus; // 合同状态：1-启用，2停用
    private BigDecimal rate; // 合同税率
    private BigDecimal taxMny; // 合同金额（含税）
    private BigDecimal mny; // 合同金额
    private BigDecimal tax; // 合同税额
    private String masterPorterSid; // ERP接货人SID
    private Long masterPorterId; // ERP接货人主键
    private String masterPorterName; // ERP接货人名称
    private String masterPorterCode; // ERP接货人编码
    private String linkPhone; // 接收人电话
    private String deliveryAddress; // 接货地址
    private String deliveryRemark; // 接货要求
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date deliveryDate; // 交货日期
    private String supplierManagerName; // 乙方联系人名称
    private String supplierManagerPhone; // 乙方联系人电话
    private Long supplierManagerSupId; //乙方联系人供方用户Id
    private String supplierManagerSid; //乙方联系人ERP SID
    private String remark; // 备注

    private Long employeeId; // 业务经办人ID
    private String employeeName; // 业务经办人名称
    private String employeeCode; // 业务经办人工号
    private String employeePhone; //经办人电话

    private BigDecimal approvedTaxMny; //已审金额
    private BigDecimal balanceTaxMny; //合同余额  采购合同的余额=采购合同-已批准的采购费用金额之和
    private String invoiceType; //发票类型
    private String contractType; //合同类型：1主合同；2附加合同，3订单
    private String applyFlag; //费用申请状态：0没有正在审批中的费用，1有正在审批中的费用
    private BigDecimal additionalTaxMny; //附加合同总金额（批准的和盖章的）
    private String sealedFlag; //是否盖章  0否，1是
    private String mainContractSid;//主合同SID
    private Long mainContractId;//主合同Id
    private String isOfficialSeal;//是否盖章
    private BigDecimal payMoney;//已经支付的金额
    private BigDecimal billMoney;//发票登记金额
    private String paymentStyleSid;//付款类型
    private String paymentStyle;//付款类型 预付款、进度款等
    private String paymentWayCom;//支付方式
    private String paymentPeriodCom;//付款账期
    private String contactBankAccount;//银行账号
    private String contactBank;//开户行
    private Long projectManagementId; // 项目经理
    private Long projectSupManagementId; // 项目经理  供方id
    private String projectManagementName; // 项目经理
    private String projectManagementPhone; // 项目经理电话
    private String contractTypeName; //合同类型：1主合同；2附加合同，3订单
    private String priceTypeName; // 计价方式：1-单价合同，2-总价合同
    private String systemId; // 系统id
    private String checkIds; //审核人id
    private String checkNames; //审核人名称

    private String executCode; //执行编码
    private String executUnitSid; //执行总部SID
    private String executUnitName; //执行总部名称
    private String executUnitId;//执行总部id(EL组织Id)

    private String purchaseType; //采购方式 0-业务单元，1-公司集采，2-公式直属
    private String sysLastUpd; //ERP最后更新时间

    private String projectSid; //项目Sid
    private String supplierSid; //供应商SID
    private String taxPointName; //

    private String changePorterSid; // 转签ERP接货人SID
    private Long changePorterId; // 转签ERP接货人主键
    private String changePorterName; // 转签ERP接货人名称
    private String changePorterCode; // 转签ERP接货人编码

    private String contractPartyA; // 合同甲方

    public String getContractPartyA() {
        return contractPartyA;
    }

    public void setContractPartyA(String contractPartyA) {
        this.contractPartyA = contractPartyA;
    }

    public String getTaxPointName() {
        return taxPointName;
    }

    public void setTaxPointName(String taxPointName) {
        this.taxPointName = taxPointName;
    }

    public String getProjectSid() {
        return projectSid;
    }

    public void setProjectSid(String projectSid) {
        this.projectSid = projectSid;
    }

    public String getSupplierSid() {
        return supplierSid;
    }

    public void setSupplierSid(String supplierSid) {
        this.supplierSid = supplierSid;
    }

    public String getMasterPorterSid() {
        return masterPorterSid;
    }

    public void setMasterPorterSid(String masterPorterSid) {
        this.masterPorterSid = masterPorterSid;
    }

    public String getSysLastUpd() {
        return sysLastUpd;
    }

    public void setSysLastUpd(String sysLastUpd) {
        this.sysLastUpd = sysLastUpd;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getSupplierManagerSid() {
        return supplierManagerSid;
    }

    public void setSupplierManagerSid(String supplierManagerSid) {
        this.supplierManagerSid = supplierManagerSid;
    }

    public String getExecutCode() {
        return executCode;
    }

    public void setExecutCode(String executCode) {
        this.executCode = executCode;
    }

    public String getExecutUnitSid() {
        return executUnitSid;
    }

    public void setExecutUnitSid(String executUnitSid) {
        this.executUnitSid = executUnitSid;
    }

    public String getExecutUnitName() {
        return executUnitName;
    }

    public void setExecutUnitName(String executUnitName) {
        this.executUnitName = executUnitName;
    }

    public String getExecutUnitId() {
        return executUnitId;
    }

    public void setExecutUnitId(String executUnitId) {
        this.executUnitId = executUnitId;
    }

    private List<ContractDetailVO> detailList = new ArrayList<>(); // 物资合同-清单明细

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getIsOfficialSeal() {
        return isOfficialSeal;
    }

    public void setIsOfficialSeal(String isOfficialSeal) {
        this.isOfficialSeal = isOfficialSeal;
    }

    public BigDecimal getPayMoney() {
        return payMoney;
    }

    public void setPayMoney(BigDecimal payMoney) {
        this.payMoney = payMoney;
    }

    public BigDecimal getBillMoney() {
        return billMoney;
    }

    public void setBillMoney(BigDecimal billMoney) {
        this.billMoney = billMoney;
    }

    public String getPaymentStyleSid() {
        return paymentStyleSid;
    }

    public void setPaymentStyleSid(String paymentStyleSid) {
        this.paymentStyleSid = paymentStyleSid;
    }

    public String getPaymentStyle() {
        return paymentStyle;
    }

    public void setPaymentStyle(String paymentStyle) {
        this.paymentStyle = paymentStyle;
    }

    public String getPaymentWayCom() {
        return paymentWayCom;
    }

    public void setPaymentWayCom(String paymentWayCom) {
        this.paymentWayCom = paymentWayCom;
    }

    public String getPaymentPeriodCom() {
        return paymentPeriodCom;
    }

    public void setPaymentPeriodCom(String paymentPeriodCom) {
        this.paymentPeriodCom = paymentPeriodCom;
    }

    public String getContactBankAccount() {
        return contactBankAccount;
    }

    public void setContactBankAccount(String contactBankAccount) {
        this.contactBankAccount = contactBankAccount;
    }

    public String getContactBank() {
        return contactBank;
    }

    public void setContactBank(String contactBank) {
        this.contactBank = contactBank;
    }

    public Long getProjectManagementId() {
        return projectManagementId;
    }

    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }

    public Long getProjectSupManagementId() {
        return projectSupManagementId;
    }

    public void setProjectSupManagementId(Long projectSupManagementId) {
        this.projectSupManagementId = projectSupManagementId;
    }

    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }

    public String getProjectManagementPhone() {
        return projectManagementPhone;
    }

    public void setProjectManagementPhone(String projectManagementPhone) {
        this.projectManagementPhone = projectManagementPhone;
    }

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    public String getPriceTypeName() {
        return priceTypeName;
    }

    public void setPriceTypeName(String priceTypeName) {
        this.priceTypeName = priceTypeName;
    }

    public Long getSupplierManagerSupId() {
        return supplierManagerSupId;
    }

    public void setSupplierManagerSupId(Long supplierManagerSupId) {
        this.supplierManagerSupId = supplierManagerSupId;
    }

    public String getMainContractSid() {
        return mainContractSid;
    }

    public void setMainContractSid(String mainContractSid) {
        this.mainContractSid = mainContractSid;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public BigDecimal getApprovedTaxMny() {
        return approvedTaxMny;
    }

    public void setApprovedTaxMny(BigDecimal approvedTaxMny) {
        this.approvedTaxMny = approvedTaxMny;
    }

    public BigDecimal getBalanceTaxMny() {
        return balanceTaxMny;
    }

    public void setBalanceTaxMny(BigDecimal balanceTaxMny) {
        this.balanceTaxMny = balanceTaxMny;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getApplyFlag() {
        return applyFlag;
    }

    public void setApplyFlag(String applyFlag) {
        this.applyFlag = applyFlag;
    }

    public BigDecimal getAdditionalTaxMny() {
        return additionalTaxMny;
    }

    public void setAdditionalTaxMny(BigDecimal additionalTaxMny) {
        this.additionalTaxMny = additionalTaxMny;
    }

    public String getSealedFlag() {
        return sealedFlag;
    }

    public void setSealedFlag(String sealedFlag) {
        this.sealedFlag = sealedFlag;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }
    public Integer getPriceType() {
        return priceType;
    }

    public void setPriceType(Integer priceType) {
        this.priceType = priceType;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }
    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public Long getMasterPorterId() {
        return masterPorterId;
    }

    public void setMasterPorterId(Long masterPorterId) {
        this.masterPorterId = masterPorterId;
    }
    public String getMasterPorterName() {
        return masterPorterName;
    }

    public void setMasterPorterName(String masterPorterName) {
        this.masterPorterName = masterPorterName;
    }
    public String getMasterPorterCode() {
        return masterPorterCode;
    }

    public void setMasterPorterCode(String masterPorterCode) {
        this.masterPorterCode = masterPorterCode;
    }
    public String getLinkPhone() {
        return linkPhone;
    }

    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }
    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }
    public String getDeliveryRemark() {
        return deliveryRemark;
    }

    public void setDeliveryRemark(String deliveryRemark) {
        this.deliveryRemark = deliveryRemark;
    }
    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    public String getSupplierManagerName() {
        return supplierManagerName;
    }

    public void setSupplierManagerName(String supplierManagerName) {
        this.supplierManagerName = supplierManagerName;
    }
    public String getSupplierManagerPhone() {
        return supplierManagerPhone;
    }

    public void setSupplierManagerPhone(String supplierManagerPhone) {
        this.supplierManagerPhone = supplierManagerPhone;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCheckIds() {
        return checkIds;
    }

    public void setCheckIds(String checkIds) {
        this.checkIds = checkIds;
    }

    public String getCheckNames() {
        return checkNames;
    }

    public void setCheckNames(String checkNames) {
        this.checkNames = checkNames;
    }

    public String getChangePorterSid() {
        return changePorterSid;
    }

    public void setChangePorterSid(String changePorterSid) {
        this.changePorterSid = changePorterSid;
    }

    public Long getChangePorterId() {
        return changePorterId;
    }

    public void setChangePorterId(Long changePorterId) {
        this.changePorterId = changePorterId;
    }

    public String getChangePorterName() {
        return changePorterName;
    }

    public void setChangePorterName(String changePorterName) {
        this.changePorterName = changePorterName;
    }

    public String getChangePorterCode() {
        return changePorterCode;
    }

    public void setChangePorterCode(String changePorterCode) {
        this.changePorterCode = changePorterCode;
    }

    public List<ContractDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<ContractDetailVO> detailList) {
        this.detailList = detailList;
     }


}
