package com.ejianc.business.zdsmaterial.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 材料分类
 * 
 * @author generator
 * 
 */
@ApiModel("材料分类")
public class MaterialCategoryVO extends BaseVO {

    private static final long serialVersionUID = -2100609853600017434L;

    @ApiModelProperty("材料分类编码")
    private String code;
    @ApiModelProperty("材料分类名称")
    private String name;
    @ApiModelProperty("材料分类序号")
    private Integer sequence;
    @ApiModelProperty("材料分类描述")
    private String description;
    @ApiModelProperty("来源系统Id")
    private String systemId;
    @ApiModelProperty("来源系统业务Id")
    private String sourceId;
    @ApiModelProperty("停启用标识：0-停用，1-启用")
    private Integer enabled;
    @ApiModelProperty("属性列表展示名称")
    private String propertyShowName;
    @ApiModelProperty("父分类Id")
    private Long parentId;
    @ApiModelProperty("内码")
    private String innerCode;
    @ApiModelProperty("属性设置标识：0-不设置属性，1-设置属性")
    private Integer propertyFlag;
    @ApiModelProperty("是否是叶子节点")
    private Boolean leafFlag;

    @ApiModelProperty("来源类型：1-ERP，2-EL新增")
    private String sourceType;

    @ApiModelProperty("是否启用类别：0-不启用，1-启用")
    private Integer enableCategory;

    @ApiModelProperty("是否重点类别：0-否，1-是")
    private Integer importantCategory;

    @ApiModelProperty("损耗系数")
    private BigDecimal lossConfficient;

    @ApiModelProperty("是否已设置规则: 0-未设置,1-已设置")
    private Integer ruledFlag;

    @ApiModelProperty("是否基准价校验：0-否，1-")
    private Integer basePriceCheckFlag;

    @ApiModelProperty("备注")
    private String memo;

    @ApiModelProperty("分类下属性分类列表")
    private List<MaterialCategoryPropertyVO> propertyList = new ArrayList<>();

    @ApiModelProperty("父级分类名称")
    private String parentName;

    @ApiModelProperty("是否协同验收：0-否，1-是")
    private Integer coordinationFlag;

    //物资供应商变更审核使用字段
    @ApiModelProperty("是否已设置物资供应商审核人： 0-否，1-是")
    private Integer managerFlag;

    @ApiModelProperty("品牌管控标识：0-否，1-是")
    private String brandControlFlag;

    @ApiModelProperty("父级分类sourceId")
    private String parentSourceId;
    @ApiModelProperty("计量单位Id")
    private Long mainUnitId;

    @ApiModelProperty("计量单位名称")
    private String mainUnitName;

    /*价格计算使用*/
    private Long materialTypeId; //原材料id
    private String materialType;  //原材料编码
    private String materialTypeName; //原材料名称

    private String calcFields; //辅助计算字段 JsonArr

    public String getCalcFields() {
        return calcFields;
    }

    public void setCalcFields(String calcFields) {
        this.calcFields = calcFields;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMainUnitId() {
        return mainUnitId;
    }

    public void setMainUnitId(Long mainUnitId) {
        this.mainUnitId = mainUnitId;
    }

    public String getMainUnitName() {
        return mainUnitName;
    }

    public void setMainUnitName(String mainUnitName) {
        this.mainUnitName = mainUnitName;
    }
    public String getParentSourceId() {
        return parentSourceId;
    }

    public void setParentSourceId(String parentSourceId) {
        this.parentSourceId = parentSourceId;
    }

    public String getBrandControlFlag() {
        return brandControlFlag;
    }

    public void setBrandControlFlag(String brandControlFlag) {
        this.brandControlFlag = brandControlFlag;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public Integer getManagerFlag() {
        return managerFlag;
    }

    public void setManagerFlag(Integer managerFlag) {
        this.managerFlag = managerFlag;
    }

    public Integer getCoordinationFlag() {
        return coordinationFlag;
    }

    public void setCoordinationFlag(Integer coordinationFlag) {
        this.coordinationFlag = coordinationFlag;
    }


    /*导入使用字段*/
    private String parentCode;

    public String getParentName() {
        return parentName;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public Integer getBasePriceCheckFlag() {
        return basePriceCheckFlag;
    }

    public void setBasePriceCheckFlag(Integer basePriceCheckFlag) {
        this.basePriceCheckFlag = basePriceCheckFlag;
    }

    public Integer getEnableCategory() {
        return enableCategory;
    }

    public void setEnableCategory(Integer enableCategory) {
        this.enableCategory = enableCategory;
    }

    public Integer getImportantCategory() {
        return importantCategory;
    }

    public void setImportantCategory(Integer importantCategory) {
        this.importantCategory = importantCategory;
    }

    public BigDecimal getLossConfficient() {
        return lossConfficient;
    }

    public void setLossConfficient(BigDecimal lossConfficient) {
        this.lossConfficient = lossConfficient;
    }

    public Integer getRuledFlag() {
        return ruledFlag;
    }

    public void setRuledFlag(Integer ruledFlag) {
        this.ruledFlag = ruledFlag;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getSequence() {
        return sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public String getPropertyShowName() {
        return propertyShowName;
    }

    public void setPropertyShowName(String propertyShowName) {
        this.propertyShowName = propertyShowName;
    }

    @ReferSerialTransfer(referCode = "ref-zdsmteral-category")
    public Long getParentId() {
        return parentId;
    }

    @ReferDeserialTransfer
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public Integer getPropertyFlag() {
        return propertyFlag;
    }

    public void setPropertyFlag(Integer propertyFlag) {
        this.propertyFlag = propertyFlag;
    }

    public List<MaterialCategoryPropertyVO> getPropertyList() {
        return propertyList;
    }

    public void setPropertyList(List<MaterialCategoryPropertyVO> propertyList) {
        this.propertyList = propertyList;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }
}
