package com.ejianc.business.zdsmaterial.erp.api;

import com.ejianc.business.zdsmaterial.erp.hystrix.OrderHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/1/26 13:45
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zdsmaterial-web", fallback = OrderHystrix.class)
public interface IZDSOrderApi {

    @PostMapping(value = "/api/zdsOrder/syncToSupCenterBySupplierId")
    CommonResponse<List<String>> syncToSupCenterBySupplierId(@RequestBody Long supplierId);

}
