package com.ejianc.business.zdsmaterial.material.api;

import com.ejianc.business.zdsmaterial.material.hystrix.ZDSMatSupManagerHystrix;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author 姜轶凯
 * @version 1.0
 * @description: 对账结算api
 * @date 2022/3/9
 */
@FeignClient(name = "ejc-zdsmaterial-web", url = "${common.env.feign-client-url}",
        path = "ejc-zdsmaterial-web", fallback = ZDSMatSupManagerHystrix.class)
public interface IZDSMatSupManagerApi {

    /**
     * 查询指定用户所能审核的所有物料末级分类Id
     *
     * @param userId
     * @return
     */
    @GetMapping(value = "/api/zdsMatSupManagerApi/getCategoryIdsByUseId")
    CommonResponse<List<Long>> getCategoryIdsByUseId(@RequestParam Long userId);

    /**
     * 根据物料分类查询对应的审核人设置信息
     *
     * @param categoryIds
     * @return
     */
    @GetMapping(value = "/api/zdsMatSupManagerApi/getAllByCategoryIds")
    public CommonResponse<List<MatSupplierManagerVO>> getAllByCategoryIds(@RequestParam List<Long> categoryIds);
}
