package com.ejianc.business.zdsmaterial.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 领料出库明细
 * 
 * @author generator
 * 
 */
@ApiModel("领料出库明细")
public class SupOutStoreSubVO {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("主键")
    private Long id;
    @ApiModelProperty("主表id")
    private Long outStoreId;
    @ApiModelProperty("物资分类名称")
    private String materialTypeName;
    @ApiModelProperty("物资分类id")
    private Long materialTypeId;
    @ApiModelProperty("物资分类编码")
    private String materialTypeCode;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("属性")
    private String property;
    @ApiModelProperty("属性值")
    private String propertyValue;
    @ApiModelProperty("单位主键")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unitName;
    @ApiModelProperty("出库数量")
    private BigDecimal num;
    @ApiModelProperty("单价")
    private BigDecimal price;
    @ApiModelProperty("金额")
    private BigDecimal money;
    @ApiModelProperty("单价(含税)")
    private BigDecimal taxPrice;
    @ApiModelProperty("金额(含税)")
    private BigDecimal taxMoney;
    @ApiModelProperty("税额")
    private BigDecimal outTax;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    @ApiModelProperty("库存可用数量")
    private BigDecimal storeNum;
    private Long sourceId; // 来源主键ID
    private Long sourceDetailId; // 来源明细主键ID
    @ApiModelProperty("产品代码")
    private String productCode;
    @ApiModelProperty("品牌主键")
    private Long brandId;
    @ApiModelProperty("品牌名称")
    private String brandName;
    @ApiModelProperty("出库仓库主键")
    private Long storeId;
    @ApiModelProperty("出库仓库名称")
    private String storeName;
    @ApiModelProperty("仓库属性")
    private Integer attrFlag; // 仓库属性 1-主材；3-甲供材；2-临建


    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 主表id
     */
    public Long getOutStoreId() {
        return outStoreId;
    }

    /**
     * 主表id
     */
    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资分类id
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资分类id
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    /**
     * 物资id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getProperty() {
        return property;
    }

    public void setProperty(String property) {
        this.property = property;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }
    /**
     * 单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 出库数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 出库数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 单价
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 金额
     */
    public BigDecimal getMoney() {
        return money;
    }

    /**
     * 金额
     */
    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    /**
     * 单价(含税)
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 单价(含税)
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 金额(含税)
     */
    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    /**
     * 金额(含税)
     */
    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }
    /**
     * 税额
     */
    public BigDecimal getOutTax() {
        return outTax;
    }

    /**
     * 税额
     */
    public void setOutTax(BigDecimal outTax) {
        this.outTax = outTax;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 库存可用数量
     */
    public BigDecimal getStoreNum() {
        return storeNum;
    }

    /**
     * 库存可用数量
     */
    public void setStoreNum(BigDecimal storeNum) {
        this.storeNum = storeNum;
    }
    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    @ReferSerialTransfer(referCode="ref-zdsBrand")
    public Long getBrandId() {
        return brandId;
    }

    @ReferDeserialTransfer
    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Integer getAttrFlag() {
        return attrFlag;
    }

    public void setAttrFlag(Integer attrFlag) {
        this.attrFlag = attrFlag;
    }
    
}
