package com.ejianc.business.zdsmaterial.pricelib.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 价格库-历史价明细
 * 
 * @author generator
 * 
 */
@ApiModel("价格库-历史价明细")
public class PriceHistoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    @ApiModelProperty("物料Id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资分类Id")
    private Long materialTypeId;
    @ApiModelProperty("物资分类名称")
    private String materialTypeName;
    @ApiModelProperty("分类内码")
    private String innerCode;
    @ApiModelProperty("规则/型号")
    private String spec;
    @ApiModelProperty("计量单位主键")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unitName;
    @ApiModelProperty("合同价格区间（无税）")
    private String contractPriceArea;
    @ApiModelProperty("合同价格区间（含税）")
    private String contractTaxPriceArea;
    @ApiModelProperty("验收价格区间（无税）")
    private String checkPriceArea;
    @ApiModelProperty("验收价格区间（含税）")
    private String checkTaxPriceArea;
    @ApiModelProperty("结算价格区间（无税）")
    private String settlePriceArea;
    @ApiModelProperty("结算价格区间（含税）")
    private String settleTaxPriceArea;
    @ApiModelProperty("合同数量")
    private BigDecimal contractNum;
    @ApiModelProperty("合同税率")
    private BigDecimal contractTaxRate;
    @ApiModelProperty("合同最高价(无税)")
    private BigDecimal contractMaxPrice;
    @ApiModelProperty("合同最高价(含税)")
    private BigDecimal contractMaxTaxPrice;
    @ApiModelProperty("合同最低价格(无税)")
    private BigDecimal contractMinPrice;
    @ApiModelProperty("合同最低价格(含税)")
    private BigDecimal contractMinTaxPrice;
    @ApiModelProperty("合同均价(含税)")
    private BigDecimal contractAvgTaxPrice;
    @ApiModelProperty("合同均价(无税)")
    private BigDecimal contractAvgPrice;
    @ApiModelProperty("市场价（无税）")
    private String marketPriceArea;
    @ApiModelProperty("公司指导价（无税）")
    private String guidePriceArea;
    @ApiModelProperty("市场价（含税）")
    private String marketTaxPriceArea;
    @ApiModelProperty("公司指导价（含税）")
    private String guideTaxPriceArea;
    @ApiModelProperty("验收数量")
    private BigDecimal checkNum;
    @ApiModelProperty("验收税率")
    private BigDecimal checkTaxRate;
    @ApiModelProperty("验收最高价(无税)")
    private BigDecimal checkMaxPrice;
    @ApiModelProperty("验收最高价(含税)")
    private BigDecimal checkMaxTaxPrice;
    @ApiModelProperty("验收最低价格(无税)")
    private BigDecimal checkMinPrice;
    @ApiModelProperty("验收最低价格(含税)")
    private BigDecimal checkMinTaxPrice;
    @ApiModelProperty("验收均价(含税)")
    private BigDecimal checkAvgTaxPrice;
    @ApiModelProperty("验收均价(无税)")
    private BigDecimal checkAvgPrice;
    @ApiModelProperty("结算数量")
    private BigDecimal settleNum;
    @ApiModelProperty("结算税率")
    private BigDecimal settleTaxRate;
    @ApiModelProperty("结算最高价(无税)")
    private BigDecimal settleMaxPrice;
    @ApiModelProperty("结算最高价(含税)")
    private BigDecimal settleMaxTaxPrice;
    @ApiModelProperty("结算最低价格(无税)")
    private BigDecimal settleMinPrice;
    @ApiModelProperty("结算最低价格(含税)")
    private BigDecimal settleMinTaxPrice;
    @ApiModelProperty("结算均价(含税)")
    private BigDecimal settleAvgTaxPrice;
    @ApiModelProperty("结算均价(无税)")
    private BigDecimal settleAvgPrice;
    @ApiModelProperty("历史价格取值类型：1-合同 2-结算 3-验收")
    private Integer historyType;
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 物料Id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物料Id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 分类内码
     */
    public String getInnerCode() {
        return innerCode;
    }

    /**
     * 分类内码
     */
    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    /**
     * 规则/型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规则/型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位主键
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 计量单位主键
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 计量单位
     */
    public String getUnitName() {
        return unitName;
    }

    /**
     * 计量单位
     */
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    /**
     * 合同价格区间（无税）
     */
    public String getContractPriceArea() {
        return contractPriceArea;
    }

    /**
     * 合同价格区间（无税）
     */
    public void setContractPriceArea(String contractPriceArea) {
        this.contractPriceArea = contractPriceArea;
    }
    /**
     * 合同价格区间（含税）
     */
    public String getContractTaxPriceArea() {
        return contractTaxPriceArea;
    }

    /**
     * 合同价格区间（含税）
     */
    public void setContractTaxPriceArea(String contractTaxPriceArea) {
        this.contractTaxPriceArea = contractTaxPriceArea;
    }
    /**
     * 验收价格区间（无税）
     */
    public String getCheckPriceArea() {
        return checkPriceArea;
    }

    /**
     * 验收价格区间（无税）
     */
    public void setCheckPriceArea(String checkPriceArea) {
        this.checkPriceArea = checkPriceArea;
    }
    /**
     * 验收价格区间（含税）
     */
    public String getCheckTaxPriceArea() {
        return checkTaxPriceArea;
    }

    /**
     * 验收价格区间（含税）
     */
    public void setCheckTaxPriceArea(String checkTaxPriceArea) {
        this.checkTaxPriceArea = checkTaxPriceArea;
    }
    /**
     * 结算价格区间（无税）
     */
    public String getSettlePriceArea() {
        return settlePriceArea;
    }

    /**
     * 结算价格区间（无税）
     */
    public void setSettlePriceArea(String settlePriceArea) {
        this.settlePriceArea = settlePriceArea;
    }
    /**
     * 结算价格区间（含税）
     */
    public String getSettleTaxPriceArea() {
        return settleTaxPriceArea;
    }

    /**
     * 结算价格区间（含税）
     */
    public void setSettleTaxPriceArea(String settleTaxPriceArea) {
        this.settleTaxPriceArea = settleTaxPriceArea;
    }
    /**
     * 合同数量
     */
    public BigDecimal getContractNum() {
        return contractNum;
    }

    /**
     * 合同数量
     */
    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }
    /**
     * 合同税率
     */
    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    /**
     * 合同税率
     */
    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }
    /**
     * 合同最高价(无税)
     */
    public BigDecimal getContractMaxPrice() {
        return contractMaxPrice;
    }

    /**
     * 合同最高价(无税)
     */
    public void setContractMaxPrice(BigDecimal contractMaxPrice) {
        this.contractMaxPrice = contractMaxPrice;
    }
    /**
     * 合同最高价(含税)
     */
    public BigDecimal getContractMaxTaxPrice() {
        return contractMaxTaxPrice;
    }

    /**
     * 合同最高价(含税)
     */
    public void setContractMaxTaxPrice(BigDecimal contractMaxTaxPrice) {
        this.contractMaxTaxPrice = contractMaxTaxPrice;
    }
    /**
     * 合同最低价格(无税)
     */
    public BigDecimal getContractMinPrice() {
        return contractMinPrice;
    }

    /**
     * 合同最低价格(无税)
     */
    public void setContractMinPrice(BigDecimal contractMinPrice) {
        this.contractMinPrice = contractMinPrice;
    }
    /**
     * 合同最低价格(含税)
     */
    public BigDecimal getContractMinTaxPrice() {
        return contractMinTaxPrice;
    }

    /**
     * 合同最低价格(含税)
     */
    public void setContractMinTaxPrice(BigDecimal contractMinTaxPrice) {
        this.contractMinTaxPrice = contractMinTaxPrice;
    }
    /**
     * 合同均价(含税)
     */
    public BigDecimal getContractAvgTaxPrice() {
        return contractAvgTaxPrice;
    }

    /**
     * 合同均价(含税)
     */
    public void setContractAvgTaxPrice(BigDecimal contractAvgTaxPrice) {
        this.contractAvgTaxPrice = contractAvgTaxPrice;
    }
    /**
     * 合同均价(无税)
     */
    public BigDecimal getContractAvgPrice() {
        return contractAvgPrice;
    }

    /**
     * 合同均价(无税)
     */
    public void setContractAvgPrice(BigDecimal contractAvgPrice) {
        this.contractAvgPrice = contractAvgPrice;
    }
    /**
     * 市场价（无税）
     */
    public String getMarketPriceArea() {
        return marketPriceArea;
    }

    /**
     * 市场价（无税）
     */
    public void setMarketPriceArea(String marketPriceArea) {
        this.marketPriceArea = marketPriceArea;
    }
    /**
     * 公司指导价（无税）
     */
    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    /**
     * 公司指导价（无税）
     */
    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }
    /**
     * 市场价（含税）
     */
    public String getMarketTaxPriceArea() {
        return marketTaxPriceArea;
    }

    /**
     * 市场价（含税）
     */
    public void setMarketTaxPriceArea(String marketTaxPriceArea) {
        this.marketTaxPriceArea = marketTaxPriceArea;
    }
    /**
     * 公司指导价（含税）
     */
    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    /**
     * 公司指导价（含税）
     */
    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }
    /**
     * 验收数量
     */
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    /**
     * 验收数量
     */
    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    /**
     * 验收税率
     */
    public BigDecimal getCheckTaxRate() {
        return checkTaxRate;
    }

    /**
     * 验收税率
     */
    public void setCheckTaxRate(BigDecimal checkTaxRate) {
        this.checkTaxRate = checkTaxRate;
    }
    /**
     * 验收最高价(无税)
     */
    public BigDecimal getCheckMaxPrice() {
        return checkMaxPrice;
    }

    /**
     * 验收最高价(无税)
     */
    public void setCheckMaxPrice(BigDecimal checkMaxPrice) {
        this.checkMaxPrice = checkMaxPrice;
    }
    /**
     * 验收最高价(含税)
     */
    public BigDecimal getCheckMaxTaxPrice() {
        return checkMaxTaxPrice;
    }

    /**
     * 验收最高价(含税)
     */
    public void setCheckMaxTaxPrice(BigDecimal checkMaxTaxPrice) {
        this.checkMaxTaxPrice = checkMaxTaxPrice;
    }
    /**
     * 验收最低价格(无税)
     */
    public BigDecimal getCheckMinPrice() {
        return checkMinPrice;
    }

    /**
     * 验收最低价格(无税)
     */
    public void setCheckMinPrice(BigDecimal checkMinPrice) {
        this.checkMinPrice = checkMinPrice;
    }
    /**
     * 验收最低价格(含税)
     */
    public BigDecimal getCheckMinTaxPrice() {
        return checkMinTaxPrice;
    }

    /**
     * 验收最低价格(含税)
     */
    public void setCheckMinTaxPrice(BigDecimal checkMinTaxPrice) {
        this.checkMinTaxPrice = checkMinTaxPrice;
    }
    /**
     * 验收均价(含税)
     */
    public BigDecimal getCheckAvgTaxPrice() {
        return checkAvgTaxPrice;
    }

    /**
     * 验收均价(含税)
     */
    public void setCheckAvgTaxPrice(BigDecimal checkAvgTaxPrice) {
        this.checkAvgTaxPrice = checkAvgTaxPrice;
    }
    /**
     * 验收均价(无税)
     */
    public BigDecimal getCheckAvgPrice() {
        return checkAvgPrice;
    }

    /**
     * 验收均价(无税)
     */
    public void setCheckAvgPrice(BigDecimal checkAvgPrice) {
        this.checkAvgPrice = checkAvgPrice;
    }
    /**
     * 结算数量
     */
    public BigDecimal getSettleNum() {
        return settleNum;
    }

    /**
     * 结算数量
     */
    public void setSettleNum(BigDecimal settleNum) {
        this.settleNum = settleNum;
    }
    /**
     * 结算税率
     */
    public BigDecimal getSettleTaxRate() {
        return settleTaxRate;
    }

    /**
     * 结算税率
     */
    public void setSettleTaxRate(BigDecimal settleTaxRate) {
        this.settleTaxRate = settleTaxRate;
    }
    /**
     * 结算最高价(无税)
     */
    public BigDecimal getSettleMaxPrice() {
        return settleMaxPrice;
    }

    /**
     * 结算最高价(无税)
     */
    public void setSettleMaxPrice(BigDecimal settleMaxPrice) {
        this.settleMaxPrice = settleMaxPrice;
    }
    /**
     * 结算最高价(含税)
     */
    public BigDecimal getSettleMaxTaxPrice() {
        return settleMaxTaxPrice;
    }

    /**
     * 结算最高价(含税)
     */
    public void setSettleMaxTaxPrice(BigDecimal settleMaxTaxPrice) {
        this.settleMaxTaxPrice = settleMaxTaxPrice;
    }
    /**
     * 结算最低价格(无税)
     */
    public BigDecimal getSettleMinPrice() {
        return settleMinPrice;
    }

    /**
     * 结算最低价格(无税)
     */
    public void setSettleMinPrice(BigDecimal settleMinPrice) {
        this.settleMinPrice = settleMinPrice;
    }
    /**
     * 结算最低价格(含税)
     */
    public BigDecimal getSettleMinTaxPrice() {
        return settleMinTaxPrice;
    }

    /**
     * 结算最低价格(含税)
     */
    public void setSettleMinTaxPrice(BigDecimal settleMinTaxPrice) {
        this.settleMinTaxPrice = settleMinTaxPrice;
    }
    /**
     * 结算均价(含税)
     */
    public BigDecimal getSettleAvgTaxPrice() {
        return settleAvgTaxPrice;
    }

    /**
     * 结算均价(含税)
     */
    public void setSettleAvgTaxPrice(BigDecimal settleAvgTaxPrice) {
        this.settleAvgTaxPrice = settleAvgTaxPrice;
    }
    /**
     * 结算均价(无税)
     */
    public BigDecimal getSettleAvgPrice() {
        return settleAvgPrice;
    }

    /**
     * 结算均价(无税)
     */
    public void setSettleAvgPrice(BigDecimal settleAvgPrice) {
        this.settleAvgPrice = settleAvgPrice;
    }
    /**
     * 历史价格取值类型：1-合同 2-结算 3-验收
     */
    public Integer getHistoryType() {
        return historyType;
    }

    /**
     * 历史价格取值类型：1-合同 2-结算 3-验收
     */
    public void setHistoryType(Integer historyType) {
        this.historyType = historyType;
    }
    
}
